/*
 * syntax.c : The usage message for xarchie
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <stdio.h>

void
syntax(argc,argv)
int argc;
char **argv;
{
    char *program;

    program = *argv;
    argv += 1;
    if (argc > 2 || (strcmp(*argv,"-help") != 0 && strcmp(*argv,"-?") != 0)) {
	fprintf(stderr,"%s: bad argument(s): ",program);
	while (--argc)
	    fprintf(stderr,"%s ",*argv++);
	fprintf(stderr,"\n");
    }
    fprintf(stderr,"Valid options (in addition to X Toolkit options) are:\n");
    fprintf(stderr,"  -host host\tConnect to Archie at host\n");
    fprintf(stderr,"  -search type\tSet query type\n");
    fprintf(stderr,"  -e\t\tSet query type to exact\n");
    fprintf(stderr,"  -c\t\tSet query type to subcase\n");
    fprintf(stderr,"  -s\t\tSet query type to substr\n");
    fprintf(stderr,"  -r\t\tSet query type to regexp\n");
    fprintf(stderr,"  -ec\t\tSet query type to exactSubcase\n");
    fprintf(stderr,"  -es\t\tSet query type to exactSubstr\n");
    fprintf(stderr,"  -er\t\tSet query type to exactRegexp\n");
    fprintf(stderr,"  -sort type\tSet sort mode\n");
    fprintf(stderr,"  -t\t\tSet sort mode to date\n");
    fprintf(stderr,"  -w\t\tSet sort mode to weight\n");
    fprintf(stderr,"  -maxhits num\tSet maximum number of matches per query\n");
    fprintf(stderr,"  -offset off\tSet Prospero offset\n");
    fprintf(stderr,"  -[nice|N] #\tSet query niceness\n");
    fprintf(stderr,"  -noscroll\tDon't scroll browser lists\n");
    fprintf(stderr,"  -mono\t\tUse monochrome color resources\n");
    fprintf(stderr,"  -gray\t\tUse gray-scale color resources\n");
    fprintf(stderr,"  -color\t\tUse color resources\n");
    fprintf(stderr,"  -[debug|D] #\tSet Prospero debugging level\n");
    fprintf(stderr,"  -help\t\tPrint this message\n");
    fprintf(stderr,"  -xrm 'resource: value'  Pass arbitrary resources\n");
    fprintf(stderr,"Options can be abbreviated to their shortest unique prefix.\n");
}
