/*	/master/contrib/hylafax/faxd/FaxModem.h,v 1.1.1.1 1995/11/30 03:32:16 polk Exp */
/*
 * Copyright (c) 1990-1995 Sam Leffler
 * Copyright (c) 1991-1995 Silicon Graphics, Inc.
 * HylaFAX is a trademark of Silicon Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _FAXMODEM_
#define	_FAXMODEM_
/*
 * Class 1, 2, and 2.0 Fax Modem Driver Interface.
 */
#include "ClassModem.h"
#include "Class2Params.h"
#include "tiffio.h"
#include "G3Decoder.h"
#include "FaxSendStatus.h"

class FaxMachineInfo;
class fxStackBuffer;
class FaxFont;
class FaxServer;

/*
 * This is an abstract class that defines the interface to
 * the set of modem drivers.  Real drivers are derived from
 * this and fill in the pure virtual methods to, for example,
 * send specific commands to the modem.  The Class2Params
 * structure defines the session parameters used/supported
 * by this interface.  Class2Params is derived from the
 * set of parameters supported by the Class 2 interface spec.
 */
class FaxModem : public ClassModem, public G3Decoder {
private:
    FaxServer&	server;		// server for getting to device
// transmit tag line support
    u_int	pageNumber;	// current transmit page number
    FaxFont*	tagLineFont;	// font for imaging tag line
    u_int	tagLineSlop;	// extra space reserved for tag line re-encoding
    fxStr	tagLine;	// tag line formatted with transmit time
    u_int	tagLineFields;	// number of fields in the tag line

    void	setupTagLine(const FaxRequest&);
// phase c data receive & copy quality checking
    u_int	cblc;		// current count of consecutive bad lines
    fxBool	lastRowBad;	// last decoded row was bad

    u_long	recvEOLCount;	// EOL count for received page
    u_long	recvBadLineCount;
    u_long	recvConsecutiveBadLineCount;
    u_int	recvCC;		// data count during receive
    fxStackBuffer* recvBuf;	// raw input for current row recvd
    u_long	savedWriteOff;	// file offset to start of page data

    void	recvRow(TIFF* tif, fxStackBuffer& row, u_char* buf);
    void	invalidCode(const char* type, int x);
    void	prematureEOL(const char* type, int x);
    void	badPixelCount(const char* type, int x);
    void	badDecodingState(const char* type, int x);
protected:
// NB: these are defined protected for convenience (XXX)
    Class2Params modemParams;	// NOTE: these are masks of Class 2 codes

    FaxModem(FaxServer&, const ModemConfig&);

// miscellaneous
    void	countPage();
    void	recvTrace(const char* fmt, ...);
    void	copyQualityTrace(const char* fmt, ...);
    void	traceModemParams();
    void	tracePPR(const char* dir, u_int ppr);
    void	tracePPM(const char* dir, u_int ppm);
// server-related stuff
    fxBool	getHDLCTracing();
    FaxSendStatus sendSetupParams(TIFF*, Class2Params&,
		    FaxMachineInfo&, fxStr&);
    fxBool	recvCheckTSI(const fxStr&);
    void	recvCSI(fxStr&);
    void	recvDCS(Class2Params&);
    void	recvNSF(u_int nsf);
    void	recvSetupPage(TIFF* tif, long group3opts, int fillOrder);
    void	recvResetPage(TIFF* tif);
    fxBool	decodePPM(const fxStr& pph, u_int& ppm, fxStr& emsg);
// phase c data receive & copy quality checking
    fxBool	recvPageDLEData(TIFF* tif, fxBool checkQuality,
		    const Class2Params& params, fxStr& emsg);
    virtual void abortPageRecv() = 0;
    virtual int decodeNextByte();

    fxBool	checkQuality();
    fxBool	isQualityOK(const Class2Params&);
    u_long	getRecvEOLCount() const;
    u_long	getRecvBadLineCount() const;
    u_long	getRecvConsecutiveBadLineCount() const;
// tag line support
    fxBool	setupTagLineSlop(const Class2Params&);
    u_int	getTagLineSlop() const;
    u_char*	imageTagLine(u_char* buf, u_int fillorder, const Class2Params&);
public:
    virtual ~FaxModem();

    fxBool isFaxModem() const;

// configuration controls
    virtual void setLID(const fxStr& number) = 0;
    fxStr getCapabilities() const;
// methods for querying modem capabilities
    virtual fxBool supports2D() const;
    virtual fxBool supportsEOLPadding() const;
    virtual fxBool supportsVRes(float res) const;
    virtual fxBool supportsPageWidth(u_int w) const;
    virtual fxBool supportsPageLength(u_int l) const;
    virtual fxBool supportsPolling() const;
    virtual fxBool supportsECM() const;

    virtual int selectSignallingRate(int br) const;
    u_int getBestSignallingRate() const;

    u_int getBestScanlineTime() const;
    virtual int selectScanlineTime(int st) const;

    u_int getBestVRes() const;
    u_int getBestDataFormat() const;
    u_int getBestPageWidth() const;
    u_int getBestPageLength() const;
    u_int modemDIS() const;

    /*
     * Fax send protocol.  The expected sequence is:
     *
     * if (faxService() && dialFax(number, params, emsg) == OK) {
     *	  sendBegin(req);
     *	  if (getPrologue() == send_ok and parameters acceptable) {
     *	     select send parameters
     *	     sendSetupPhaseB();
     *	     for (each file)
     *		if (!sendPhaseB()) break;
     *	  }
     *	  sendEnd();
     * }
     * hangup();
     *
     * The post page handling parameter to sendPhaseB enables the
     * client to control whether successive files are lumped together
     * as a single T.30 document or split apart.  This is important
     * for doing things like keeping cover pages & documents in a
     * single T.30 document.
     */
    virtual fxBool faxService() = 0;
    virtual CallStatus dialFax(const char* number,
	const Class2Params& dis, fxStr& emsg);
    virtual void sendBegin(const FaxRequest&);
    virtual FaxSendStatus getPrologue(Class2Params&,
	u_int& nsf, fxStr& csi, fxBool& hasDoc, fxStr& emsg) = 0;
    virtual void sendSetupPhaseB();
    virtual FaxSendStatus sendPhaseB(TIFF*, Class2Params&, FaxMachineInfo&,
	fxStr& pph, fxStr& emsg) = 0;
    virtual void sendEnd();
    virtual void sendAbort() = 0;

    /*
     * Fax seceive protocol.  The expected sequence is:
     *
     * if (waitForRings(nrings, ctype)) {	# wait before answering phone
     *    case (answerCall(type, emsg)) {
     *    CALLTYPE_FAX:
     *	    if (recvBegin()) {
     *	      do {
     *		TIFF* tif = TIFFOpen(..., "w");
     *		int ppm = PPM_EOP;
     *		do {
     *		    if (!recvPage(tif, ppm, emsg))
     *		        error during receive;
     *	        } while (ppm == PPM_MPS);
     *		deal with received file
     *	      } while (ppm != PPM_EOP);
     *	      recvEnd();
     *	    }
     *	    hangup();
     *	  CALLTYPE_DATA:
     *	    dataService();
     *	    do data kinds of things...
     *	  CALLTYPE_VOICE:
     *	    voiceService();
     *	    do voice kinds of things...
     *    }
     * }
     */
    virtual fxBool setupReceive() = 0;
    virtual fxBool recvBegin(fxStr& emsg) = 0;
    virtual fxBool recvPage(TIFF*, int& ppm, fxStr& em) = 0;
    virtual fxBool recvEnd(fxStr& emsg) = 0;
    virtual void recvAbort() = 0;

    /*
     * Polling protocol (for polling a remote site).  This is done
     * in conjunction with a send operation: first, before dialing,
     * call requestToPoll(), then after sending any files, do:
     *
     * if (pollBegin(...)) {
     *    do {
     *	    TIFF* tif = TIFFOpen(..., "w");
     *	    if (recvPhaseB(tif, ..., ppm, ...) deal with received file
     *	  } while (ppm != PPM_EOP);
     *	  recvEnd();
     * }
     *
     * (i.e. it's just like a receive operation.)
     */
    virtual fxBool requestToPoll() = 0;
    virtual fxBool pollBegin(const fxStr& pollID, fxStr& emsg) = 0;
};
#endif /* _FAXMODEM_ */
