# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
#ifndef lint
static char	rcsid[] = "/master/contrib/tex/ktexmf-6.3/detex-2.6/lexout.c,v 1.1.1.1 1995/10/27 01:23:51 bostic Exp";
#endif

/*
 * detex [-e environment-list] [-c] [-l] [-n] [-s] [-t] [-w] [file[.tex]]
 *
 *	This program is used to remove TeX or LaTeX constructs from a text
 *	file.
 *
 * Written by:
 *	Daniel Trinkle
 *	Department of Computer Science
 *	Purdue University
 *
 */

#include "detex.h"
#ifdef HAVE_STRING_H
#include <string.h>
#define	index	strchr
#define	rindex	strrchr
#else
#include <strings.h>
#endif
#ifndef MAXPATHLEN
#include <sys/param.h>
#endif
#ifdef OS2
#include <stdlib.h>
#endif

#define	LaBEGIN		if (fLatex) BEGIN
#define	CITEBEGIN	if (fLatex && !fCite) BEGIN
#define	IGNORE		if (fSpace && !fWord) putchar(' ')
#define	SPACE		if (!fWord) putchar(' ')
#define	NEWLINE		if (!fWord) putchar('\n')

char	*SafeMalloc();
#ifndef NO_MALLOC_DECL
char	*malloc();
#endif
#ifdef OS2
void	yyless(int);
#endif

char	*rgsbEnvIgnore[MAXENVS];	/* list of environments ignored */
char	*rgsbIncList[MAXINCLIST];	/* list of includeonly files */
char	*rgsbInputPaths[MAXINPUTPATHS];	/* list of input paths in order */
char	sbCurrentEnv[CCHMAXENV];	/* current environment being ignored */
char	*sbProgName;			/* name we were invoked with */
FILE	*rgfp[NOFILE+1];		/* stack of input/include files */
int	cfp = 0;			/* count of files in stack */
int	cOpenBrace = 0;			/* count of `{' in <SG> */
int	csbEnvIgnore;			/* count of environments ignored */
int	csbIncList = 0;			/* count of includeonly files */
int	csbInputPaths;			/* count of input paths */
int	fLatex = 0;			/* flag to indicated delatex */
int	fWord = 0;			/* flag for -w option */
int	fFollow = 1;			/* flag to follow input/include */
int	fCite = 0;			/* flag to echo \cite and \ref args */
int	fSpace = 0;			/* flag to replace \cs with space */
int	fForcetex = 0;			/* flag to inhibit latex mode */
# define SJ 2
# define SK 4
# define SL 6
# define SM 8
# define SN 10
# define SO 12
# define SP 14
# define SA 16
# define SB 18
# define SC 20
# define SD 22
# define SE 24
# define SF 26
# define SH 28
# define SG 30
# define SI 32
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	/* ignore comments */	;
break;
case 2:
{fLatex = !fForcetex; IGNORE;}
break;
case 3:
    /* environment start */	{LaBEGIN SA; IGNORE;}
break;
case 4:
	{   if (BeginEnv("verbatim"))
							BEGIN SD;
						    else
							BEGIN SI;
						    IGNORE;
						}
break;
case 5:
/* verbatim mode */
						{BEGIN SO; IGNORE;}
break;
case 6:
				ECHO;
break;
case 7:
				{   if (BeginEnv(yytext))
							BEGIN SD;
						    else
							BEGIN SH;
						    IGNORE;
						}
break;
case 8:
				NEWLINE;
break;
case 9:
				;
break;
case 10:
 /* absorb some environments */	{LaBEGIN SC; IGNORE;}
break;
case 11:
				NEWLINE;
break;
case 12:
				;
break;
case 13:
	 /* end environment */	{   if (EndEnv(yytext))
							BEGIN SO;
						    IGNORE;
						}
break;
case 14:
				{BEGIN SD; IGNORE;}
break;
case 15:
				NEWLINE;
break;
case 16:
				;
break;
case 17:
    /* ignore args  */	{LaBEGIN SG; IGNORE;}
break;
case 18:
   /* of these \cs */	{LaBEGIN SH; IGNORE;}
break;
case 19:
			{LaBEGIN SH; IGNORE;}
break;
case 20:
			{CITEBEGIN SG; IGNORE;}
break;
case 21:
		{LaBEGIN SH; IGNORE;}
break;
case 22:
				{LaBEGIN SH; IGNORE;}
break;
case 23:
			{LaBEGIN SG; SPACE;}
break;
case 24:
			{LaBEGIN SH; IGNORE;}
break;
case 25:
			{CITEBEGIN SH; IGNORE;}
break;
case 26:
			{LaBEGIN SH; IGNORE;}
break;
case 27:
				{CITEBEGIN SH; IGNORE;}
break;
case 28:
			{LaBEGIN SH; IGNORE;}
break;
case 29:
/* ignore \verb<char>...<char> */
						{   if (fLatex) {
						 	char verbchar, c;
						 	verbchar = input();
						 	while ((c = input()) != verbchar)
							    if (c == '\n')
								NEWLINE;
						    }
						    IGNORE;
						}
break;
case 30:
				BEGIN SO;
break;
case 31:
				NEWLINE;
break;
case 32:
				;
break;
case 33:
				{   cOpenBrace++; }
break;
case 34:
				{   cOpenBrace--;
						    if (cOpenBrace == 0)
							BEGIN SO;
						}
break;
case 35:
				NEWLINE;
break;
case 36:
				;
break;
case 37:
	/* ignore def begin */	{BEGIN SJ; IGNORE;}
break;
case 38:
				BEGIN SO;
break;
case 39:
				NEWLINE;
break;
case 40:
				;
break;
case 41:
	/* formula mode */	{LaBEGIN SE; IGNORE;}
break;
case 42:
			BEGIN SO;
break;
case 43:
				NEWLINE;
break;
case 44:
				;
break;
case 45:
	/* display mode */	{LaBEGIN SB; IGNORE;}
break;
case 46:
			BEGIN SO;
break;
case 47:
				NEWLINE;
break;
case 48:
				;
break;
case 49:
	/* display mode */	{BEGIN SK; IGNORE;}
break;
case 50:
				BEGIN SO;
break;
case 51:
				NEWLINE;
break;
case 52:
				;
break;
case 53:
	/* math mode */		{BEGIN SN; IGNORE;}
break;
case 54:
				BEGIN SO;
break;
case 55:
				NEWLINE;
break;
case 56:
				;
break;
case 57:
					;
break;
case 58:
/* process files */	{LaBEGIN SF; IGNORE;}
break;
case 59:
			{   IncludeFile(yytext);
						    BEGIN SO;
						}
break;
case 60:
				NEWLINE;
break;
case 61:
				;
break;
case 62:
			{BEGIN SL; IGNORE;}
break;
case 63:
		AddInclude(yytext);
break;
case 64:
			{   if (csbIncList == 0)
							rgsbIncList[csbIncList++] = '\0';
						    BEGIN SO;
						}
break;
case 65:
			NEWLINE;
break;
case 66:
				;
break;
case 67:
			{BEGIN SM; IGNORE;}
break;
case 68:
			{   InputFile(yytext);
						    BEGIN SO;
						}
break;
case 69:
				NEWLINE;
break;
case 70:
				;
break;
case 71:
/* handle ligatures */
						{(void)printf("%.2s", yytext+1);}
break;
case 72:
	{(void)printf("%.1s", yytext+1);}
break;
case 73:
/* ignore other \cs */	{BEGIN SP; IGNORE;}
break;
case 74:
				SPACE;
break;
case 75:
				IGNORE;
break;
case 76:
			IGNORE;
break;
case 77:
	IGNORE;
break;
case 78:
				{BEGIN SO; NEWLINE;}
break;
case 79:
			{BEGIN SO; IGNORE;}
break;
case 80:
				{yyless(0);BEGIN SO;}
break;
case 81:
/* special characters */	IGNORE;
break;
case 82:
				IGNORE;
break;
case 83:
				SPACE;
break;
case 84:
			{   if (fWord)
							(void)printf("%s\n", yytext);
						    else
							ECHO;
						}
break;
case 85:
				if (!fWord) ECHO;
break;
case 86:
				if (!fWord) ECHO;
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
/******
** main --
**	Set sbProgName to the base of arg 0.
**	Set the input paths.
**	Check for options
**		-c		echo LaTeX \cite, \ref, and \pageref values
**		-e <env-list>	list of LaTeX environments to ignore
**		-l		force latex mode
**		-n		do not follow \input and \include
**		-s		replace control sequences with space
**		-t		force tex mode
**		-w		word only output
**	Set the list of LaTeX environments to ignore.
**	Process each input file.
**	If no input files are specified on the command line, process stdin.
******/

main(cArgs,rgsbArgs)
int	cArgs;
char	*rgsbArgs[];
{
	char	*pch, *sbEnvList = DEFAULTENV, sbBadOpt[2];
	FILE	*TexOpen();
	int	fSawFile = 0, iArgs = 1;
	
	/* get base name and decide what we are doing, detex or delatex */
#ifdef OS2
	char drive[_MAX_DRIVE], dir[_MAX_DIR];
	char fname[_MAX_FNAME], ext[_MAX_EXT];
#ifdef __EMX__
	_wildcard(&cArgs, &rgsbArgs);
	_response(&cArgs, &rgsbArgs);
#endif
	_splitpath (rgsbArgs[0], drive, dir, fname, ext);
	sbProgName = strlwr(fname);
#else
	if ((sbProgName = rindex(rgsbArgs[0], '/')) != NULL)
	    sbProgName++;
	else
	    sbProgName = rgsbArgs[0];
#endif
	if (strcmp("delatex",sbProgName) == 0)
	    fLatex = 1;
	
	/* set rgsbInputPaths for use with TexOpen() */
	SetInputPaths();

	/* process command line options */
	while (iArgs < cArgs && *(pch = rgsbArgs[iArgs]) == CHOPT) {
		while (*++pch)
		    switch (*pch) {
		    case CHCITEOPT:
			fCite = 1;
			break;
		    case CHENVOPT:
			sbEnvList = rgsbArgs[++iArgs];
			break;
		    case CHLATEXOPT:
			fLatex = 1;
			break;
		    case CHNOFOLLOWOPT:
			fFollow = 0;
			break;
		    case CHSPACEOPT:
			fSpace = 1;
			break;
		    case CHTEXOPT:
			fForcetex = 1;
			break;
		    case CHWORDOPT:
			fWord = 1;
			break;
		    default:
#ifdef OS2
			OS2UsageExit();
#else
			sbBadOpt[0] = *pch;
			sbBadOpt[1] = '\0';
			Warning("unknown option ignored -", sbBadOpt);
#endif
		    }
		iArgs++;
	}
	SetEnvIgnore(sbEnvList);

	/* process input files */
	for (; iArgs < cArgs; iArgs++) {
	    fSawFile++;
	    if ((yyin = TexOpen(rgsbArgs[iArgs])) == NULL) {
		Warning("can't open file", rgsbArgs[iArgs]);
		continue;;
	    }
	    BEGIN SO;
	    (void)yylex();
	}

	/* if there were no input files, assume stdin */
	if (!fSawFile) {
	    yyin = stdin;
#ifdef OS2
	    if (isatty(fileno(stdin)))
		OS2UsageExit();
#endif
	    BEGIN SO;
	    (void)yylex();
	}
#ifndef FLEX_SCANNER
	if (YYSTATE != SO)
	    ErrorExit("input contains an unterminated mode or environment");
#endif
	return(0);
}

#ifdef FLEX_SCANNER
#undef yywrap
#endif

/******
** yywrap -- handles EOF for lex.  Check to see if the stack of open files
**	has anything on it.  If it does, set yyin to the to value.  If not
**	return the termination signal for lex.
******/

yywrap()
{
	(void)fclose(yyin);
	if (cfp > 0) {
	    yyin = rgfp[--cfp];
	    return(0);
	}
	return(1);
}

#ifdef OS2

/******
** yyless -- return characters to the input stream.  Some systems don't have
**	a yyless routine
******/

void yyless(n)
int n;
{
	int 	i = strlen(yytext);

	while (i > n) unput(yytext[--i]);
	yytext[yyleng = n] = '\0';
}
#endif

/******
** SetEnvIgnore -- sets rgsbEnvIgnore to the values indicated by the
**	sbEnvList.
******/

SetEnvIgnore(sbEnvList)
char	*sbEnvList;
{
	char *sb;

	sb = SafeMalloc(strlen(sbEnvList) + 1, "malloc for SetEnvIgnore failed");
	(void) strcpy(sb, sbEnvList);
	csbEnvIgnore = SeparateList(sb, rgsbEnvIgnore, CHENVSEP, MAXENVS);
	if (csbEnvIgnore == ERROR)
	    ErrorExit("The environtment list contains too many environments");
}

/******
** BeginEnv -- checks to see if sbEnv is in the list rgsbEnvIgnore.  If it
**	is, sbCurrentEnv is set to sbEnv.
******/

BeginEnv(sbEnv)
char	*sbEnv;
{
	int	i;

	if (!fLatex) return(0);
	for (i = 0; i < csbEnvIgnore; i++)
	    if (strcmp(sbEnv, rgsbEnvIgnore[i]) == 0) {
		(void)strcpy(sbCurrentEnv, sbEnv);
		return(1);
	    }
	return(0);
}

/******
** EndEnv -- checks to see if sbEnv is the current environment being ignored.
******/

EndEnv(sbEnv)
char	*sbEnv;
{
	if (!fLatex) return(0);
	if (strcmp(sbEnv, sbCurrentEnv) == 0)
	    return(1);
	return(0);
}

/******
** InputFile -- push the current yyin and open sbFile.  If the open fails,
**	the sbFile is ignored.
******/

InputFile(sbFile)
char	*sbFile;
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\input file", sbFile);
	    yyin = rgfp[--cfp];
	}
}

/******
** IncludeFile -- if sbFile is not in the rgsbIncList, push current yyin
**	and open sbFile.  If the open fails, the sbFile is ignored.
******/

IncludeFile(sbFile)
char	*sbFile;
{
	FILE	*TexOpen();

	if (!fFollow)
	    return;
	if (!InList(sbFile))
	    return;
	rgfp[cfp++] = yyin;
	if ((yyin = TexOpen(sbFile)) == NULL) {
	    Warning("can't open \\include file", sbFile);
	    yyin = rgfp[--cfp];
	}
}

/******
** AddInclude -- adds sbFile to the rgsbIncList and increments csbIncList.
**	If the include list is too long, sbFile is ignored.
******/

AddInclude(sbFile)
char	*sbFile;
{
	if (!fFollow)
	    return;
	if (csbIncList >= MAXINCLIST)
	    Warning("\\includeonly list is too long, ignoring", sbFile);
	rgsbIncList[csbIncList] = SafeMalloc(strlen(sbFile) + 1, "malloc for AddInclude failed");
	(void)strcpy(rgsbIncList[csbIncList++], sbFile);
}

/******
** InList -- checks to see if sbFile is in the rgsbIncList.  If there is
**	no list, all files are assumed to be "in the list".
******/

InList(sbFile)
char	*sbFile;
{
	char	*pch, sbBase[MAXPATHLEN];
	int	i;

	if (csbIncList == 0)	/* no list */
	    return(1);
	(void)strcpy(sbBase, sbFile);
	if ((pch = rindex(sbBase, '.')) != NULL)
	    *pch = '\0';
	i = 0;
	while ((i < csbIncList) && rgsbIncList[i])
	    if (strcmp(rgsbIncList[i++], sbBase) == 0)
	        return(1);
	return(0);
}

/******
** SetInputPaths -- sets rgsbInputPaths to the values indicated by the
**	TEXINPUTS environment variable if set or else DEFAULTINPUTS.  If
**	the user's TEXINPUTS has a leading ':' prepend the DEFAULTINPUTS
**	to the path, if there is a trailing ':' append the DEFAULTINPUTS.
**	This is consistent with the most recent TeX.  However, this
**	routine does not honor the '//' construct (expand subdirs).
******/

SetInputPaths()
{
	char *sb, *sbPaths, *getenv();
	int cchDefaults, cchPaths;

	cchDefaults = strlen(DEFAULTINPUTS);
#ifdef OS2
	if ((sb = getenv("TEXINPUT")) == NULL)
#endif
	    if ((sb = getenv("TEXINPUTS")) == NULL)
		sb = DEFAULTINPUTS;
	cchPaths = strlen(sb);
	if (sb[0] == CHPATHSEP)
	    cchPaths += cchDefaults;
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    cchPaths += cchDefaults;
	sbPaths = SafeMalloc(cchPaths + 1, "malloc for SetInputPaths failed");
	sbPaths[0] = '\0';
	if (sb[0] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);
	(void)strcat(sbPaths, sb);
	if (sb[strlen(sb) - 1] == CHPATHSEP)
	    (void)strcat(sbPaths, DEFAULTINPUTS);

	csbInputPaths = SeparateList(sbPaths, rgsbInputPaths, CHPATHSEP, MAXINPUTPATHS);
	if (csbInputPaths == ERROR)
#ifdef OS2
	    ErrorExit("TEXINPUT(S) environment variable has too many paths");
#else
	    ErrorExit("TEXINPUTS environment variable has too many paths");
#endif
}

/******
** SeparateList -- takes a chSep separated list sbList, replaces the
**	chSep's with NULLs and sets rgsbList[i] to the beginning of
**	the ith word in sbList.  The number of words is returned.  A
**	ERROR is returned if there are more than csbMax words.
******/

SeparateList(sbList, rgsbList, chSep, csbMax)
char	*sbList, *rgsbList[], chSep;
int	csbMax;
{
	int	csbList = 0;

	while (sbList && *sbList && csbList < csbMax) {
	    rgsbList[csbList++] = sbList;
	    if (sbList = index(sbList, chSep))
		*sbList++ = '\0';
	}
	return(sbList && *sbList ? ERROR : csbList);
}

/******
** TexOpen -- tries to open sbFile in each of the rgsbInputPaths in turn.
**	For each input path the following order is used:
**		file.tex - must be as named, if not there go to the next path
**		file.ext - random extension, try it
**		file     - base name, add .tex and try it
**		file     - try it as is
**	Notice that if file exists in the first path and file.tex exists in
**	one of the other paths, file in the first path is what is opened.
**	If the sbFile begins with a '/', no paths are searched.
******/

FILE *
TexOpen(sbFile)
char	*sbFile;
{
	char	*pch, *sbNew;
	FILE	*fp;
	int	iPath;
	static char	sbFullPath[MAXPATHLEN];

	for (iPath = 0; iPath < csbInputPaths; iPath++) {
#ifdef OS2
	    if (*sbFile == '/' || *sbFile == '\\' || strchr(sbFile, ':')) {	/* absolute path */
#else
	    if (*sbFile == '/') {	/* absolute path */
#endif
		(void)sprintf(sbFullPath, "%s", sbFile);
		iPath = csbInputPaths;	/* only check once */
	    } else
		(void)sprintf(sbFullPath, "%s/%s", rgsbInputPaths[iPath], sbFile);
#ifdef OS2
	    pch = sbFullPath;
	    while (pch = strchr(pch, '\\'))
		*pch = '/';
#endif

	    /* If sbFile ends in .tex then it must be there */
	    if ((pch = rindex(sbFullPath, '.')) != NULL
			&& (strcmp(pch, ".tex") == 0))
		if ((fp = fopen(sbFullPath, "r")) != NULL)
		    return(fp);
		else
		    continue;

	    /* if .<ext> then try to open it.  the '.' represents   */
	    /* the beginning of an extension if it is not the first */
	    /* character and it does not follow a '.' or a '/'      */
	    if (pch != NULL && pch > &(sbFullPath[0])
                    && *(pch - 1) != '.' && *(pch - 1) != '/'
		    && (fp = fopen(sbFullPath, "r")) != NULL)
		return(fp);

	    /* just base name, add .tex to the name */
	    sbNew = SafeMalloc(strlen(sbFullPath) + 5, "malloc for TexOpen failed");
	    (void)strcpy(sbNew, sbFullPath);
	    (void)strcat(sbNew, ".tex");
	    if ((fp = fopen(sbNew, "r")) != NULL)
		return(fp);

	    /* try sbFile regardless */
	    if ((fp = fopen(sbFullPath, "r")) != NULL)
		return(fp);
	}
	return((FILE *)NULL);
}

/******
** SafeMalloc -- wrapper around malloc() to check for failure.
******/

char *
SafeMalloc(cch, sbMessage)
int cch;
char *sbMessage;
{
	char *sb;

	if ((sb = (char *)malloc((unsigned)cch)) == NULL)
	    ErrorExit(sbMessage);
	return(sb);
}

/******
** Warning -- print a warning message preceded by the program name.
******/

Warning(sb1, sb2)
char	*sb1, *sb2;
{
	(void)fprintf(stderr, "%s: warning: %s %s\n", sbProgName, sb1, sb2);
}

/******
** ErrorExit -- print an error message preceded by the program name.
**	Stdout is flushed and detex exits.
******/

ErrorExit(sb1)
char	*sb1;
{
	(void)fflush(stdout);
	(void)fprintf(stderr, "%s: error: %s\n", sbProgName, sb1);
	exit(1);
}
#ifdef OS2

/******
** OS2UsageExit -- print OS/2 usage message and exit.
******/

OS2UsageExit()
{
	(void)printf("\n%s [ -clnstw ] [ -e environment-list ] [ filename[.tex] ... ]\n",
		sbProgName);
	puts("  -c  echo LaTeX \\cite, \\ref, and \\pageref values\n  \
-e  <env-list> list of LaTeX environments to ignore\n  \
-l  force latex mode\n  \
-n  do not follow \\input and \\include\n  \
-s  replace control sequences with space\n  \
-t  force tex mode\n  \
-w  word only output");
	exit(0);
}
#endif
int yyvstop[] = {
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

79,
0,

40,
0,

39,
0,

38,
40,
0,

52,
0,

51,
0,

52,
0,

63,
66,
0,

66,
0,

65,
0,

64,
66,
0,

68,
70,
0,

70,
0,

69,
0,

57,
0,

55,
0,

54,
57,
0,

57,
0,

86,
0,

86,
0,

53,
86,
0,

1,
86,
0,

85,
86,
0,

86,
0,

81,
86,
0,

81,
86,
0,

83,
86,
0,

80,
0,

79,
80,
0,

78,
0,

77,
80,
0,

80,
0,

80,
0,

79,
80,
0,

9,
0,

9,
0,

8,
0,

7,
9,
0,

9,
0,

48,
0,

47,
0,

48,
0,

16,
0,

15,
0,

13,
16,
0,

14,
16,
0,

12,
0,

11,
0,

12,
0,

44,
0,

43,
0,

44,
0,

59,
61,
0,

61,
0,

60,
0,

32,
0,

31,
0,

30,
32,
0,

36,
0,

35,
0,

33,
36,
0,

34,
36,
0,

6,
0,

6,
0,

50,
0,

63,
0,

68,
0,

56,
0,

82,
0,

49,
0,

1,
0,

85,
0,

84,
0,

75,
0,

74,
75,
0,

41,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

45,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

73,
75,
0,

79,
0,

79,
0,

77,
0,

76,
0,

7,
0,

46,
0,

13,
0,

42,
0,

59,
0,

84,
0,

73,
0,

73,
0,

72,
0,

72,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

71,
0,

71,
0,

73,
0,

73,
0,

73,
0,

37,
73,
0,

73,
0,

22,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

27,
73,
0,

73,
0,

73,
0,

10,
0,

73,
0,

73,
0,

73,
0,

73,
0,

20,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

29,
73,
0,

3,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

23,
73,
0,

67,
73,
0,

24,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

17,
73,
0,

73,
0,

73,
0,

73,
0,

58,
73,
0,

25,
73,
0,

73,
0,

73,
0,

73,
0,

19,
73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

73,
0,

26,
73,
0,

73,
0,

4,
0,

73,
0,

73,
0,

73,
0,

28,
73,
0,

73,
0,

73,
0,

62,
73,
0,

18,
73,
0,

73,
0,

21,
73,
0,

5,
0,

2,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	3,35,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	5,38,	3,35,	3,36,	
0,0,	0,0,	0,0,	0,0,	
7,41,	5,38,	5,39,	0,0,	
0,0,	0,0,	34,0,	104,0,	
7,42,	7,43,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	3,35,	0,0,	
0,0,	6,40,	62,128,	0,0,	
3,35,	5,38,	12,50,	0,0,	
5,40,	3,35,	3,35,	5,38,	
7,41,	3,35,	40,98,	51,101,	
5,38,	5,38,	7,41,	54,103,	
5,38,	14,54,	14,55,	7,42,	
7,41,	62,128,	85,140,	7,41,	
0,0,	3,35,	3,35,	72,134,	
72,134,	113,146,	113,147,	0,0,	
5,38,	5,38,	69,133,	69,133,	
0,0,	3,35,	9,45,	7,41,	
7,41,	100,0,	100,0,	0,0,	
5,38,	112,145,	9,46,	9,47,	
0,0,	112,145,	72,134,	7,41,	
113,146,	3,35,	0,0,	114,146,	
114,147,	69,133,	0,0,	0,0,	
5,38,	0,0,	0,0,	0,0,	
100,0,	75,137,	53,102,	7,41,	
0,0,	0,0,	9,45,	116,145,	
0,0,	82,139,	97,142,	116,145,	
9,45,	0,0,	114,146,	11,48,	
124,156,	9,45,	9,45,	118,150,	
3,37,	9,45,	3,35,	11,48,	
11,49,	16,61,	12,48,	5,38,	
20,73,	5,38,	24,80,	26,83,	
34,96,	67,129,	7,42,	117,148,	
7,44,	9,45,	9,45,	117,149,	
120,153,	14,59,	119,151,	14,60,	
125,157,	127,159,	136,160,	11,48,	
62,129,	9,45,	11,50,	114,145,	
119,152,	11,48,	126,158,	139,161,	
142,162,	148,165,	11,48,	11,48,	
99,0,	99,0,	11,48,	149,166,	
150,167,	9,45,	151,168,	13,52,	
126,145,	121,146,	121,147,	152,169,	
72,136,	153,170,	155,174,	13,52,	
13,52,	15,61,	11,48,	11,48,	
156,175,	113,147,	157,176,	99,0,	
69,134,	15,62,	15,63,	158,177,	
159,178,	160,179,	11,48,	100,0,	
121,146,	100,0,	161,180,	99,0,	
9,46,	162,181,	9,46,	13,53,	
122,146,	122,147,	13,54,	13,55,	
165,182,	13,52,	11,51,	114,147,	
167,186,	15,61,	13,52,	13,52,	
154,171,	154,172,	13,56,	15,64,	
169,187,	171,188,	17,68,	166,183,	
15,61,	15,64,	166,184,	122,146,	
15,65,	154,173,	17,69,	17,70,	
172,189,	166,185,	13,52,	13,57,	
130,0,	130,0,	173,190,	174,191,	
175,192,	11,48,	11,48,	11,48,	
15,65,	15,65,	13,57,	141,0,	
141,0,	177,193,	123,146,	123,147,	
178,194,	179,195,	17,68,	182,197,	
15,65,	183,198,	184,199,	130,0,	
17,68,	185,200,	13,58,	187,201,	
188,202,	17,68,	17,68,	189,203,	
19,73,	17,68,	141,0,	190,204,	
15,66,	123,146,	121,154,	191,205,	
19,73,	19,74,	99,0,	193,208,	
99,0,	192,206,	192,207,	195,209,	
198,213,	17,68,	17,71,	181,181,	
181,181,	121,147,	21,76,	199,214,	
122,155,	13,59,	13,59,	13,59,	
13,60,	17,71,	21,76,	21,77,	
19,73,	145,163,	145,164,	15,67,	
15,61,	15,61,	19,73,	200,215,	
201,216,	202,217,	181,181,	19,73,	
19,73,	17,68,	206,218,	19,73,	
207,219,	208,220,	196,196,	196,196,	
122,147,	209,221,	21,76,	210,222,	
145,163,	213,224,	214,225,	215,226,	
21,76,	216,227,	23,80,	19,73,	
19,73,	21,76,	21,76,	212,212,	
212,212,	21,76,	23,80,	23,81,	
25,83,	196,196,	123,145,	19,73,	
17,72,	217,228,	17,68,	218,229,	
25,83,	25,84,	130,0,	219,230,	
220,231,	21,76,	21,78,	221,232,	
146,146,	146,147,	212,212,	19,75,	
222,233,	141,0,	23,80,	141,0,	
223,234,	21,78,	123,147,	225,235,	
23,80,	226,236,	227,237,	228,238,	
25,83,	23,80,	23,80,	163,163,	
163,164,	23,80,	25,83,	146,146,	
230,239,	21,76,	231,240,	25,83,	
25,83,	197,211,	197,211,	25,83,	
232,241,	233,242,	19,73,	19,73,	
19,73,	23,80,	23,80,	234,243,	
235,244,	237,245,	163,163,	238,246,	
239,247,	181,196,	27,86,	25,83,	
25,83,	23,80,	211,211,	211,211,	
197,211,	240,248,	27,87,	27,88,	
21,76,	242,250,	21,79,	25,83,	
243,251,	145,164,	244,252,	245,253,	
246,254,	23,82,	248,255,	250,256,	
241,241,	241,241,	212,223,	196,210,	
251,257,	211,211,	252,258,	25,85,	
253,259,	254,260,	27,86,	256,261,	
257,262,	258,263,	259,264,	261,265,	
27,86,	262,266,	29,89,	264,267,	
266,269,	27,86,	27,86,	241,241,	
0,0,	27,86,	29,89,	29,90,	
23,80,	23,80,	23,80,	0,0,	
265,265,	265,265,	0,0,	0,0,	
269,269,	269,269,	25,83,	25,83,	
25,83,	27,86,	27,86,	0,0,	
0,0,	0,0,	0,0,	0,0,	
146,147,	0,0,	29,89,	0,0,	
0,0,	27,86,	0,0,	265,265,	
29,89,	0,0,	0,0,	269,269,	
0,0,	29,89,	29,89,	31,92,	
0,0,	29,89,	0,0,	163,164,	
0,0,	27,86,	0,0,	31,92,	
31,93,	0,0,	0,0,	197,212,	
0,0,	0,0,	0,0,	0,0,	
0,0,	29,89,	29,89,	56,105,	
56,105,	56,105,	56,105,	56,105,	
56,105,	56,105,	56,105,	56,105,	
56,105,	29,89,	0,0,	31,92,	
211,212,	0,0,	0,0,	0,0,	
27,87,	31,92,	27,87,	33,96,	
0,0,	0,0,	31,92,	31,92,	
0,0,	29,89,	31,92,	33,96,	
33,0,	41,99,	0,0,	0,0,	
241,249,	0,0,	0,0,	0,0,	
0,0,	41,0,	41,0,	0,0,	
0,0,	0,0,	31,92,	31,92,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	33,96,	
0,0,	0,0,	31,92,	0,0,	
29,89,	33,96,	29,91,	0,0,	
41,0,	41,99,	33,96,	33,96,	
265,268,	0,0,	33,96,	41,99,	
269,270,	0,0,	31,92,	0,0,	
41,0,	41,99,	0,0,	0,0,	
41,99,	0,0,	0,0,	0,0,	
0,0,	45,100,	33,96,	33,96,	
0,0,	0,0,	0,0,	0,0,	
0,0,	45,0,	45,0,	55,104,	
41,99,	41,99,	33,96,	0,0,	
0,0,	0,0,	0,0,	55,104,	
55,0,	31,94,	0,0,	31,95,	
41,99,	0,0,	0,0,	0,0,	
0,0,	0,0,	33,97,	0,0,	
45,0,	45,100,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,100,	
41,99,	0,0,	0,0,	55,104,	
45,100,	45,100,	0,0,	0,0,	
45,100,	55,104,	0,0,	0,0,	
0,0,	0,0,	55,104,	55,104,	
0,0,	0,0,	55,104,	0,0,	
0,0,	33,96,	33,96,	33,96,	
45,100,	45,100,	0,0,	0,0,	
0,0,	0,0,	0,0,	41,0,	
0,0,	41,0,	55,104,	55,104,	
45,100,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,104,	0,0,	
0,0,	0,0,	0,0,	0,0,	
45,100,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,104,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	57,106,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,0,	
0,0,	45,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	55,104,	0,0,	55,104,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	57,107,	57,107,	
57,107,	57,107,	58,108,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	58,108,	58,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	58,109,	58,108,	0,0,	
0,0,	0,0,	0,0,	0,0,	
58,108,	58,110,	0,0,	0,0,	
0,0,	58,108,	58,108,	0,0,	
0,0,	58,108,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	58,111,	58,112,	58,111,	
58,111,	58,111,	58,111,	58,111,	
58,111,	58,111,	58,111,	58,111,	
58,111,	58,113,	58,111,	58,111,	
58,114,	58,111,	58,111,	58,111,	
58,111,	58,111,	58,111,	58,111,	
58,111,	58,111,	58,111,	58,111,	
58,115,	58,108,	0,0,	0,0,	
0,0,	0,0,	58,116,	58,117,	
58,118,	58,119,	58,120,	58,111,	
58,111,	58,111,	58,121,	0,0,	
58,111,	58,122,	58,111,	58,111,	
58,123,	58,124,	58,111,	58,125,	
58,126,	58,111,	58,111,	58,127,	
58,111,	58,111,	58,111,	58,111,	
58,108,	64,130,	58,108,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,0,	64,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,0,	64,130,	0,0,	0,0,	
0,0,	0,0,	0,0,	64,130,	
0,0,	0,0,	0,0,	0,0,	
64,130,	64,130,	0,0,	0,0,	
64,130,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,130,	64,130,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,130,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,130,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	64,0,	
0,0,	64,130,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,130,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,130,	65,0,	
65,0,	65,131,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	65,0,	
65,0,	65,0,	0,0,	65,0,	
65,0,	65,131,	65,131,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	65,131,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
65,0,	65,0,	65,0,	65,0,	
65,0,	0,0,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
66,132,	66,132,	66,132,	66,132,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	71,135,	71,135,	
71,135,	71,135,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
78,138,	78,138,	78,138,	78,138,	
86,141,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
86,0,	86,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	86,0,	
86,141,	0,0,	0,0,	0,0,	
0,0,	0,0,	86,141,	0,0,	
0,0,	0,0,	0,0,	86,141,	
86,141,	0,0,	0,0,	86,141,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	86,141,	
86,141,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	86,141,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	86,141,	
0,0,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	0,0,	
0,0,	0,0,	86,0,	0,0,	
86,0,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	106,143,	
106,143,	106,143,	106,143,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	111,144,	111,144,	
111,144,	111,144,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
0,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	0,0,	131,0,	
131,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	131,0,	
131,0,	131,0,	0,0,	131,0,	
131,0,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	0,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	143,143,	
143,143,	143,143,	143,143,	0,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+-1,	0,		yyvstop+5,
yycrank+0,	yysvec+3,	yyvstop+7,
yycrank+-8,	0,		yyvstop+9,
yycrank+-1,	yysvec+5,	yyvstop+11,
yycrank+-15,	0,		yyvstop+13,
yycrank+0,	yysvec+7,	yyvstop+15,
yycrank+-77,	0,		yyvstop+17,
yycrank+0,	yysvec+9,	yyvstop+19,
yycrank+-118,	0,		yyvstop+21,
yycrank+-6,	yysvec+11,	yyvstop+23,
yycrank+-170,	0,		yyvstop+25,
yycrank+-21,	yysvec+13,	yyvstop+27,
yycrank+-180,	0,		yyvstop+29,
yycrank+-5,	yysvec+15,	yyvstop+31,
yycrank+-221,	0,		yyvstop+33,
yycrank+0,	yysvec+17,	yyvstop+35,
yycrank+-267,	0,		yyvstop+37,
yycrank+-8,	yysvec+19,	yyvstop+39,
yycrank+-289,	0,		yyvstop+41,
yycrank+0,	yysvec+21,	yyvstop+43,
yycrank+-329,	0,		yyvstop+45,
yycrank+-10,	yysvec+23,	yyvstop+47,
yycrank+-339,	0,		yyvstop+49,
yycrank+-11,	yysvec+25,	yyvstop+51,
yycrank+-401,	0,		yyvstop+53,
yycrank+0,	yysvec+27,	yyvstop+55,
yycrank+-441,	0,		yyvstop+57,
yycrank+0,	yysvec+29,	yyvstop+59,
yycrank+-486,	0,		yyvstop+61,
yycrank+0,	yysvec+31,	yyvstop+63,
yycrank+-526,	0,		yyvstop+65,
yycrank+-12,	yysvec+33,	yyvstop+67,
yycrank+0,	0,		yyvstop+69,
yycrank+0,	0,		yyvstop+71,
yycrank+0,	0,		yyvstop+73,
yycrank+0,	0,		yyvstop+76,
yycrank+0,	0,		yyvstop+78,
yycrank+14,	0,		yyvstop+80,
yycrank+-536,	0,		yyvstop+82,
yycrank+0,	0,		yyvstop+85,
yycrank+0,	0,		yyvstop+87,
yycrank+0,	0,		yyvstop+89,
yycrank+-588,	0,		yyvstop+92,
yycrank+0,	0,		yyvstop+95,
yycrank+0,	0,		yyvstop+97,
yycrank+0,	0,		yyvstop+99,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+103,
yycrank+15,	0,		yyvstop+106,
yycrank+0,	0,		yyvstop+108,
yycrank+10,	0,		yyvstop+110,
yycrank+19,	0,		yyvstop+112,
yycrank+-598,	0,		yyvstop+115,
yycrank+459,	0,		yyvstop+118,
yycrank+659,	0,		yyvstop+121,
yycrank+-781,	0,		yyvstop+123,
yycrank+0,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+129,
yycrank+0,	0,		yyvstop+132,
yycrank+29,	0,		yyvstop+134,
yycrank+0,	0,		yyvstop+137,
yycrank+-904,	0,		yyvstop+139,
yycrank+-1029,	0,		yyvstop+142,
yycrank+1061,	0,		yyvstop+144,
yycrank+14,	0,		yyvstop+146,
yycrank+0,	0,		yyvstop+149,
yycrank+65,	0,		yyvstop+151,
yycrank+0,	yysvec+69,	yyvstop+153,
yycrank+1119,	0,		yyvstop+155,
yycrank+58,	0,		yyvstop+158,
yycrank+0,	0,		yyvstop+160,
yycrank+0,	0,		yyvstop+162,
yycrank+12,	0,		yyvstop+164,
yycrank+0,	0,		yyvstop+166,
yycrank+0,	0,		yyvstop+168,
yycrank+1177,	0,		yyvstop+170,
yycrank+0,	0,		yyvstop+173,
yycrank+0,	0,		yyvstop+176,
yycrank+0,	0,		yyvstop+178,
yycrank+12,	0,		yyvstop+180,
yycrank+0,	0,		yyvstop+182,
yycrank+0,	0,		yyvstop+184,
yycrank+21,	0,		yyvstop+186,
yycrank+-1299,	0,		yyvstop+188,
yycrank+0,	0,		yyvstop+191,
yycrank+0,	0,		yyvstop+193,
yycrank+0,	0,		yyvstop+195,
yycrank+0,	0,		yyvstop+197,
yycrank+0,	0,		yyvstop+199,
yycrank+0,	0,		yyvstop+202,
yycrank+0,	0,		yyvstop+204,
yycrank+0,	0,		yyvstop+206,
yycrank+0,	0,		yyvstop+209,
yycrank+0,	0,		yyvstop+212,
yycrank+13,	0,		yyvstop+214,
yycrank+0,	0,		yyvstop+216,
yycrank+-155,	yysvec+41,	yyvstop+218,
yycrank+-72,	yysvec+45,	yyvstop+220,
yycrank+0,	0,		yyvstop+222,
yycrank+0,	0,		yyvstop+224,
yycrank+0,	0,		yyvstop+226,
yycrank+-13,	yysvec+55,	yyvstop+228,
yycrank+0,	yysvec+56,	yyvstop+230,
yycrank+1328,	yysvec+57,	0,	
yycrank+0,	yysvec+57,	yyvstop+232,
yycrank+0,	0,		yyvstop+234,
yycrank+0,	0,		yyvstop+236,
yycrank+0,	0,		yyvstop+239,
yycrank+1387,	0,		yyvstop+242,
yycrank+20,	yysvec+111,	yyvstop+245,
yycrank+60,	yysvec+111,	yyvstop+248,
yycrank+86,	yysvec+111,	yyvstop+251,
yycrank+0,	0,		yyvstop+254,
yycrank+14,	yysvec+111,	yyvstop+257,
yycrank+38,	yysvec+111,	yyvstop+260,
yycrank+18,	yysvec+111,	yyvstop+263,
yycrank+45,	yysvec+111,	yyvstop+266,
yycrank+34,	yysvec+111,	yyvstop+269,
yycrank+164,	yysvec+111,	yyvstop+272,
yycrank+195,	yysvec+111,	yyvstop+275,
yycrank+241,	yysvec+111,	yyvstop+278,
yycrank+23,	yysvec+111,	yyvstop+281,
yycrank+47,	yysvec+111,	yyvstop+284,
yycrank+57,	yysvec+111,	yyvstop+287,
yycrank+48,	yysvec+111,	yyvstop+290,
yycrank+0,	yysvec+62,	yyvstop+293,
yycrank+0,	yysvec+67,	yyvstop+295,
yycrank+-227,	yysvec+64,	yyvstop+297,
yycrank+-1509,	yysvec+65,	0,	
yycrank+0,	yysvec+66,	yyvstop+299,
yycrank+0,	yysvec+69,	0,	
yycrank+0,	yysvec+72,	0,	
yycrank+0,	yysvec+71,	yyvstop+301,
yycrank+49,	0,		0,	
yycrank+0,	0,		yyvstop+303,
yycrank+0,	yysvec+78,	yyvstop+305,
yycrank+49,	0,		0,	
yycrank+0,	0,		yyvstop+307,
yycrank+-238,	yysvec+86,	yyvstop+309,
yycrank+50,	0,		0,	
yycrank+1508,	0,		yyvstop+311,
yycrank+0,	yysvec+111,	yyvstop+313,
yycrank+292,	yysvec+111,	yyvstop+315,
yycrank+347,	0,		yyvstop+317,
yycrank+0,	0,		yyvstop+319,
yycrank+58,	yysvec+111,	yyvstop+321,
yycrank+69,	yysvec+111,	yyvstop+323,
yycrank+52,	yysvec+111,	yyvstop+325,
yycrank+68,	yysvec+111,	yyvstop+327,
yycrank+76,	yysvec+111,	yyvstop+329,
yycrank+77,	yysvec+111,	yyvstop+331,
yycrank+117,	yysvec+111,	yyvstop+333,
yycrank+80,	yysvec+111,	yyvstop+335,
yycrank+81,	yysvec+111,	yyvstop+337,
yycrank+84,	yysvec+111,	yyvstop+339,
yycrank+75,	yysvec+111,	yyvstop+341,
yycrank+78,	yysvec+111,	yyvstop+343,
yycrank+79,	0,		0,	
yycrank+98,	0,		0,	
yycrank+101,	0,		0,	
yycrank+366,	0,		yyvstop+345,
yycrank+0,	0,		yyvstop+347,
yycrank+103,	yysvec+111,	yyvstop+349,
yycrank+118,	yysvec+111,	yyvstop+351,
yycrank+111,	yysvec+111,	yyvstop+353,
yycrank+0,	yysvec+111,	yyvstop+355,
yycrank+103,	yysvec+111,	yyvstop+358,
yycrank+0,	yysvec+111,	yyvstop+360,
yycrank+113,	yysvec+111,	yyvstop+363,
yycrank+131,	yysvec+111,	yyvstop+365,
yycrank+121,	yysvec+111,	yyvstop+367,
yycrank+138,	yysvec+111,	yyvstop+369,
yycrank+139,	yysvec+111,	yyvstop+371,
yycrank+0,	yysvec+111,	yyvstop+373,
yycrank+150,	yysvec+111,	yyvstop+376,
yycrank+154,	yysvec+111,	yyvstop+378,
yycrank+155,	0,		0,	
yycrank+0,	0,		yyvstop+380,
yycrank+278,	0,		0,	
yycrank+145,	yysvec+111,	yyvstop+382,
yycrank+141,	yysvec+111,	yyvstop+384,
yycrank+153,	yysvec+111,	yyvstop+386,
yycrank+145,	yysvec+111,	yyvstop+388,
yycrank+0,	yysvec+111,	yyvstop+390,
yycrank+154,	yysvec+111,	yyvstop+393,
yycrank+147,	yysvec+111,	yyvstop+395,
yycrank+147,	yysvec+111,	yyvstop+397,
yycrank+155,	yysvec+111,	yyvstop+399,
yycrank+167,	yysvec+111,	yyvstop+401,
yycrank+167,	yysvec+111,	yyvstop+403,
yycrank+168,	yysvec+111,	yyvstop+405,
yycrank+0,	yysvec+111,	yyvstop+407,
yycrank+186,	0,		0,	
yycrank+309,	0,		0,	
yycrank+376,	yysvec+111,	yyvstop+410,
yycrank+183,	yysvec+111,	yyvstop+413,
yycrank+180,	yysvec+111,	yyvstop+415,
yycrank+186,	yysvec+111,	yyvstop+417,
yycrank+207,	yysvec+111,	yyvstop+419,
yycrank+209,	yysvec+111,	yyvstop+421,
yycrank+0,	yysvec+111,	yyvstop+423,
yycrank+0,	yysvec+111,	yyvstop+426,
yycrank+0,	yysvec+111,	yyvstop+429,
yycrank+213,	yysvec+111,	yyvstop+432,
yycrank+200,	yysvec+111,	yyvstop+434,
yycrank+200,	yysvec+111,	yyvstop+436,
yycrank+205,	0,		0,	
yycrank+222,	0,		0,	
yycrank+397,	0,		0,	
yycrank+326,	0,		0,	
yycrank+216,	yysvec+111,	yyvstop+438,
yycrank+223,	yysvec+111,	yyvstop+440,
yycrank+219,	yysvec+111,	yyvstop+442,
yycrank+219,	yysvec+111,	yyvstop+444,
yycrank+244,	yysvec+111,	yyvstop+446,
yycrank+245,	yysvec+111,	yyvstop+448,
yycrank+230,	yysvec+111,	yyvstop+450,
yycrank+242,	yysvec+111,	yyvstop+452,
yycrank+250,	0,		0,	
yycrank+246,	0,		0,	
yycrank+253,	0,		0,	
yycrank+0,	yysvec+111,	yyvstop+454,
yycrank+253,	yysvec+111,	yyvstop+457,
yycrank+268,	yysvec+111,	yyvstop+459,
yycrank+254,	yysvec+111,	yyvstop+461,
yycrank+260,	yysvec+111,	yyvstop+463,
yycrank+0,	yysvec+111,	yyvstop+466,
yycrank+272,	yysvec+111,	yyvstop+469,
yycrank+266,	yysvec+111,	yyvstop+471,
yycrank+279,	0,		0,	
yycrank+291,	0,		0,	
yycrank+296,	0,		0,	
yycrank+299,	yysvec+111,	yyvstop+473,
yycrank+0,	yysvec+111,	yyvstop+475,
yycrank+282,	yysvec+111,	yyvstop+478,
yycrank+289,	yysvec+111,	yyvstop+480,
yycrank+299,	yysvec+111,	yyvstop+482,
yycrank+308,	yysvec+111,	yyvstop+484,
yycrank+415,	0,		0,	
yycrank+316,	0,		0,	
yycrank+299,	0,		0,	
yycrank+306,	yysvec+111,	yyvstop+486,
yycrank+303,	yysvec+111,	yyvstop+488,
yycrank+312,	yysvec+111,	yyvstop+490,
yycrank+0,	yysvec+111,	yyvstop+492,
yycrank+308,	yysvec+111,	yyvstop+495,
yycrank+0,	0,		yyvstop+497,
yycrank+307,	0,		0,	
yycrank+319,	0,		0,	
yycrank+326,	yysvec+111,	yyvstop+499,
yycrank+311,	yysvec+111,	yyvstop+501,
yycrank+312,	yysvec+111,	yyvstop+503,
yycrank+0,	yysvec+111,	yyvstop+505,
yycrank+330,	0,		0,	
yycrank+335,	0,		0,	
yycrank+316,	yysvec+111,	yyvstop+508,
yycrank+330,	yysvec+111,	yyvstop+510,
yycrank+0,	yysvec+111,	yyvstop+512,
yycrank+330,	0,		0,	
yycrank+331,	0,		0,	
yycrank+0,	yysvec+111,	yyvstop+515,
yycrank+342,	yysvec+111,	yyvstop+518,
yycrank+447,	0,		0,	
yycrank+328,	0,		0,	
yycrank+0,	yysvec+111,	yyvstop+520,
yycrank+0,	0,		yyvstop+523,
yycrank+451,	0,		0,	
yycrank+0,	0,		yyvstop+525,
0,	0,	0};
struct yywork *yytop = yycrank+1636;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,'!' ,01  ,01  ,01  ,01  ,01  ,047 ,
01  ,01  ,01  ,01  ,',' ,'-' ,01  ,01  ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,'-' ,01  ,'!' ,
'@' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'L' ,'A' ,'A' ,'L' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,0134,01  ,01  ,01  ,
'-' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'L' ,'L' ,'A' ,'L' ,'A' ,'A' ,'L' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'{' ,0134,'}' ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
