.\" gcp.man,v1.1.1.11995/12/08 20:13:37
.TH GCP 1C "13 May 1988"
.SH NAME
gcp \- global file copy
.SH SYNOPSIS
.B gcp
file1 file2
.br
.B gcp
[
.B \-r
] file ... directory
.SH DESCRIPTION
.I gcp
works just like rcp(1C) except that you may specify a set of hosts to copy files
from or to.
The host sets are defined in the file /etc/ghosts.
(An individual host name can be used as a set containing one member.)
You can give a command like

	gcp /etc/motd sun:

to copy your /etc/motd file to /etc/motd on all the Suns.
If, on the other hand, you say

	gcp /a/foo /b/bar sun:/tmp

then your files will be copied to /tmp on all the Suns.
The general rule is that if you don't specify the destination directory,
files go to the same directory they are in currently.
.P
You may specify the union of two or more sets by using + as follows:

	gcp /a/foo /b/bar 750+mc:

which will copy /a/foo to /a/foo on all 750's and Masscomps, and then copy
/b/bar to /b/bar on all 750's and Masscomps.
.P
Commonly used sets should be defined in /etc/ghosts.
For example, you could add a line that says

	pep=manny+moe+jack

Another way to do that would be to add the word "pep" after each of the host
entries:

	manny	sun3 pep
.br
	moe		sun3 pep
.br
	jack		sun3 pep

Hosts and sets of host can also be excluded:

	foo=sun-sun2

Any host so excluded will never be included, even if a subsequent set on the
line includes it:

	foo=abc+def
.br
	bar=xyz-abc+foo

comes out to xyz+def.

You can define private host sets by creating .ghosts in your current directory
with entries just like /etc/ghosts.
Also, if there is a file .grem, it defines "rem" to be the remaining hosts
from the last gsh or gcp that didn't succeed everywhere.
.PP
Interrupting with a SIGINT will cause the rcp to the current host to be skipped
and execution resumed with the next host.
To stop completely, send a SIGQUIT.
.SH SEE ALSO
rcp(1C)
.SH BUGS
All the bugs of rcp, since it calls rcp.
