/*
 * syserr.c : Routines for system errors (like perror()). This puts
 *	together an error string based on errno (if the system has
 *	errno) and then calls the interface function alert0() to
 *	display it.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 * 13 May 1993: Use HAVE_SYS_ERRLIST properly and correct comments.
 *
 * Compile-time parameters (config.h)
 *	HAVE_STRERROR:    ANSI function strerror() exists
 *	HAVE_SYS_ERRLIST: char *sys_errlist[] exists
 *	HAVE_ERRNO:       int errno exists (it better!)
 */
#include <stdio.h>
#include "config.h"

#ifdef HAVE_ERRNO
#include <errno.h>
# ifndef MSDOS
  extern int errno;		/* MSDOS doesn't like this, apparently */
# endif /* !MSDOS */
#else /* !NO_ERRNO */
int errno;			/* Make our own, pretty useless */
#endif /* !NO_ERRNO */

#ifdef HAVE_STRERROR
/* This is the same as NeedFunctionPrototypes for an X file */
#if defined(FUNCPROTO) || __STDC__ || defined(__cplusplus) || defined(c_plusplus)
   extern char *strerror(int);
# else
   extern char *strerror();
# endif /* !NeedFunctionPrototypes */
#else /* !HAVE_STRERROR */
# ifdef HAVE_SYS_ERRLIST
   extern char *sys_errlist[];
# endif /* !HAVE_SYS_ERRLIST */
#endif /* !HAVE_STRERROR */

extern void alert0();		/* Function to display the error message */

/*	-	-	-	-	-	-	-	-	*/

void
sysError(str)
char *str;
{
    char buf[256];

#ifdef HAVE_STRERROR
    sprintf(buf,"%s: %s",str,strerror(errno));
#else
#ifdef HAVE_SYS_ERRLIST
    sprintf(buf,"%s: %s",str,sys_errlist[errno]);
#else
#ifdef HAVE_ERRNO
    sprintf(buf,"%s: Errno = %d",str,errno);
#else
    sprintf(buf,"%s: System error.");
#endif /* !HAVE_ERRNO */
#endif /* !HAVE_SYS_ERRLIST */
#endif /* !HAVE_STRERROR */
    alert0(buf);
}
