// fftfun.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FFT_Function is an ArrayFunction subclass which takes an array of doubles
// as input, and produces a Fast Fourier Transform of that array, placing it
// in the Data object 'frame'.  All the underlying functions are static, and
// were converted to C++ from their original C.

#ifndef FFTFUN_H
#ifdef __GNUG__
#pragma interface
#endif
#define FFTFUN_H

#include "localdefs.h"
#include "arrayfunction.h"

class WindowingTable;

class FFT_Function : public ArrayFunction {
	typedef ArrayFunction Super;
public:
	FFT_Function(Data* data, int points, int frameoffset);
	FFT_Function(Data* data) : ArrayFunction(data),
		npoints(0), xreal(nil), ximag(nil), window(nil) {}
	static Modifier* create(class DataEditor*);
	virtual ~FFT_Function();
	redefined const char* message() { return "Running FFT:  "; }
	redefined int operator () (double *input, Data *frame);
protected:
	redefined void initialize();
	redefined boolean setValues(Request& r);
	redefined int maxFrameLength() { return int(10000000); /* arbitr. large */ }
private:
	redefined const QueryInfo *requestInfo();
private:
	static void fft(int, double*, double*);
	static void fftalgorithm(int, int, int, double*, double*);
	static int scramble(int, int, int);
	static void descramble(int, int, int, double*, double*);
private:
	int npoints;
	double* xreal;
	double* ximag;
	WindowingTable* window;
	enum Points { P_64 = 0x1, P_128 = 0x2, P_256 = 0x4, P_512 = 0x8,
				  P_1024 = 0x10, P_2048 = 0x20 };
};

#endif
