// device.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Device is a C++ interface to any UNIX device -- but is designed for use as
// one of the base classes for Converter subclasses which access their device
// via standard read() and write() calls (see conv_device.h).

#ifndef MXV_DEVICE_H
#define MXV_DEVICE_H

#include "InterViews/resource.h"
#include "localdefs.h"

#ifndef __bsdi__
#ifndef sgi
extern "C" int ioctl(int, unsigned long, char*);
#endif
#endif

class Device : virtual public Resource {
public:
	Device() : fd(0) {}
	virtual ~Device() { close(); }
	virtual boolean open(const char* name, int mode);
	inline virtual boolean close();
	virtual int read(void *buffer, int bytes);
	virtual int write(void *buffer, int bytes);
	virtual boolean ioctl(unsigned long req, char *argp);
	
	virtual boolean isOpen() { return fd > 0; }
	virtual int fdesc() { return fd; }
private:
	int fd;
};

inline boolean
Device::close() {
	BUG("Device::close()");
	int stat = isOpen() ? ::close(fd) : 0; fd = 0;
	return (stat >= 0);
}

inline boolean 
Device::open(const char* name, int mode) {
	BUG("Device::open()");
	boolean stat = ((fd = ::open(name, mode)) > 0);
	return stat;
}

inline int
Device::read(void *buffer, int bytes) {
	BUG("Device::read()");
	return ::read(fdesc(), buffer, bytes);
}

inline int
Device::write(void *buffer, int bytes){
	BUG("Device::write()");
	return ::write(fdesc(), buffer, bytes);
}

inline boolean
Device::ioctl(unsigned long req, char *argp) {
	BUG("Device::ioctl()");
	return (::ioctl(fdesc(), req, argp) >= 0);
}

#endif
