// aiff_header.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Header subclass for reading/writing AIF-C style sound file headers.  Two
// complete sets of methods are present, one for the SGI platform, one for all
// other platforms.  One set is always ifdef'ed out.  Method names are the same
// for both, but the SGI version has some additional members as well

#ifndef AIFF_HEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define AIFF_HEADER_H

#define FORM		0x464f524d			/* AIF-C magic number */
#define MROF		0x4d524f46			/* this number byte-reversed */

#ifdef sgi
extern "C" {
#include <audio.h>
#include <audiofile.h>
}
#else
#include "diskstrings.h"
#include "diskstruct.h"
#include "id.h"
#include "ieee_float.h"
#define AIFCVersion1	0xa2805140
#define AF_COMPRESSION_NONE 0
#endif

#include "soundheader.h"

class AIFFSoundHeader : public SoundHeader {
	typedef SoundHeader Super;
	friend class Sound;
public:
	AIFFSoundHeader(DataType format, int rate, int chans, double peak,
		long compression=AF_COMPRESSION_NONE);
	virtual ~AIFFSoundHeader();
	long compressionType() { return compression_type; }
	long frameCount();
protected:
	redefined boolean isMagic();
	redefined boolean magicIsSwapped();
	redefined int checkHeader();
	redefined boolean isValid(DataType t);
	redefined int readInfo(DataFile *);
	redefined int readComment(DataFile *);
	redefined int writeInfo(DataFile *);
	redefined int writeComment(DataFile *);
#ifdef sgi	
	redefined int seekInFile(DataFile*, int);
	long readSound(char** buffer, long frames);
	long writeSound(char* buffer, long frames);
	static void errorHandler(long, const char*, ...);
#endif
protected:
	long compression_type;
private:
#ifdef sgi
	AFfilehandle audioFileHandle;
#else
	class FormChunk : public StandardChunk {
	public:
		FormChunk(long size=0)
			: StandardChunk("FORM", size), formType("AIFC") {}
		redefined boolean isValid();
		redefined int read(DataFile*);
		redefined int write(DataFile*);
		boolean isAIFC() { return formType == "AIFC"; }
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 1 };
	private:
		Id formType;
	};
	class FormatChunk : public StandardChunk {
	public:
		FormatChunk() : StandardChunk("FVER", 4) {}
		redefined boolean isValid() { return isA("FVER") && size() == 4; }
	};
	class FormatVersion : public DiskStruct {
		typedef DiskStruct Super;
	public:
		FormatVersion() : timeStamp(AIFCVersion1) {}
		redefined long readSize() { return sizeof(*this) - Super::readSize(); }
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 1 };
	private:
		unsigned long timeStamp;
	};
	class CommonChunk : public StandardChunk {
	public:
		CommonChunk() : StandardChunk("COMM", 38) {}
		redefined boolean isValid() { return isA("COMM") && size() > 0L; }
	};
	class CommonData : public DiskStruct {
		typedef DiskStruct Super;
	public:
		CommonData(boolean is_AIFC=true, short nchans=0, long nframes=0,
			short sampsize=0, double samprate=0)
				: chans(nchans), frames(nframes), sampleSize(sampsize),
				rate(samprate), compressionType("NONE"), isAIFC(is_AIFC) {}
		redefined long readSize() {
			return sizeof(*this) - Super::readSize() - sizeof(isAIFC);
		}
		int compression() const {
			return (compressionType == "NONE") ? 0 : -1;
		}
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 6 };
	private:
		friend class AIFFSoundHeader;
		short chans;
		long frames;
		short sampleSize;
		IEEE_Float rate;
		Id compressionType;
		CompressionName compressionName;
	private:	// this is not part of the on-disk data
		boolean isAIFC;
	};
	class SoundChunk : public StandardChunk {
	public:
		SoundChunk(long datasize)
			: StandardChunk("SSND", datasize + 8) {}
		redefined boolean isValid() { return isA("SSND") && size() >= 0; }
	};
	class SoundData : public DiskStruct {
		typedef DiskStruct Super;
	public:
		SoundData() : offset(0), blockSize(0) {}
		redefined long readSize() { return sizeof(*this) - Super::readSize(); }
	protected:
		redefined ValueSetterBase** valueSetters();
		enum { NumElements = 2 };
	private:
		friend class AIFFSoundHeader;
		unsigned long offset;
		unsigned long blockSize;
	};
/*	FOR FUTURE REFERENCE 
	struct Markers {
		int id;
		long dataSize;
		unsigned short numMarkers;
	};
	struct UComments {
		int id;
		long dataSize;
		unsigned short numComments;
	};
	struct Comments : public UComments {
		Comments() { id = COMT; numComments = 1; }
	};
*/
	int parseCommonData(const CommonData &);
#endif /* sgi */
};

#endif
