
/*
 * This file is part of the Seyon, Copyright (c) 1992-1993 by Muhammad M.
 * Saggaf. All rights reserved.
 *
 * See the file COPYING (1-COPYING) or the manual page seyon(1) for a full
 * statement of rights and permissions for this program.
*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Viewport.h>

#include "seyon.h"
#include "SeDecl.h"

extern char    *str_parse();

int             ReadParseProtFile();
void            do_transfer(),
                buf_transfer(),
                do_upload(),
                exec_upload(),
                ReReadProtFile(),
                SeTransfer();

struct _protItem {
  char            name[LIT_BUF];
  char            command[REG_BUF];
  Boolean         reqName;
};

struct _protItem *protItems[MAX_ENT];
int             transCurItemIndex;

void
TopTransfer(widget)
     Widget          widget;
{
  Widget          popup, mBox, uBox, lBox,
                  view,
                  list;
  static char     protocolsFile[REG_BUF];
  static String   disItems[MAX_ENT + 1] = {NULL};

  ret_if_up(widget, inhibit_child);

  if (disItems[0] == NULL) {
    strcpy(protocolsFile, qres.protocolsFile);
    if (ReadParseProtFile(protocolsFile, disItems) < 0)
      return;
  }

  popup = AddSimplePopup("transfer", widget);
  mBox = SeAddPaned("mBox", popup);
  uBox = SeAddBox("uBox", mBox);
  lBox = SeAddBox("lBox", mBox);

  view = XtCreateManagedWidget("view", viewportWidgetClass, uBox, NULL, 0);
  list = XtVaCreateManagedWidget("list", listWidgetClass, view,
				 XtNlist, disItems, NULL);
  SeSetViewportDimFromList(view, list, 10);
  XtAddCallback(list, XtNcallback, do_transfer, NULL);

  SeAddButton("dismiss", lBox, DestroyShellCallBack);
  SeAddButtonWithClientData("edit", lBox, EditFile, (XtPointer)protocolsFile);
  SeAddButtonWithClientData("reread", lBox, ReReadProtFile,
			    (XtPointer) disItems);

  PopupCentered(popup, widget);
}

void
ReReadProtFile(widget, disItems)
     Widget          widget;
     XtPointer       disItems[];
{
  DestroyShell(widget);

  FreeList(disItems);
  TopTransfer(XtParent(GetShell(widget)));
}

void
do_transfer(widget, client_data, call_data)
     Widget          widget;
     XtPointer       client_data,
                     call_data;
{
  XawListReturnStruct *item = (XawListReturnStruct *) call_data;

  if ((transCurItemIndex = item->list_index) == XAW_LIST_NONE)
    return;

  if (protItems[transCurItemIndex]->reqName) {
    do_upload(widget);
    return;
  }

  DestroyShell(widget);
  exec_cmd(protItems[transCurItemIndex]->command);
}

char            lastUploadFile[REG_BUF];

void
do_upload(widget, client_data)
     Widget          widget;
     XtPointer       client_data;
{
  SePopupDialogGetStringE("upload", widget, exec_upload, NULL, lastUploadFile,
						  True);
}

void
exec_upload(widget)
     Widget          widget;
{
  Widget          dialog = XtParent(widget);
  static char     cmd[REG_BUF];

  strcpy(lastUploadFile, XawDialogGetValueString(dialog));
  sprintf(cmd, "%s %s", protItems[transCurItemIndex]->command,
	  lastUploadFile);

  DestroyShell(XtParent(GetShell(widget)));
  exec_cmd(cmd);
}

void
upload_acc_ok(widget)
     Widget          widget;
{
  exec_upload(widget);
}

void
ExecShellCmd(w, client_data)
     Widget          w;
     XtPointer       client_data;
{
  Widget          dialog = (Widget)client_data;
  String          command = XawDialogGetValueString(dialog);

  DestroyShell(dialog);
  exec_cmd(command);
}

void
top_shell(w)
     Widget          w;
{
  ret_if_up(w, inhibit_child);
  SePopupDialogGetString("shellCommand", w, ExecShellCmd, NULL);
}

void
shell_acc_ok(widget)
     Widget          widget;
{
  ExecShellCmd(widget, (XtPointer) XtParent(widget));
}

int
ReadParseProtFile(fname, disItems)
     String          fname;
     String          disItems[];
{
  FILE           *fp;
  String          rawItems[MAX_ENT + 1];
  char           *buf,
                  reqName[10];
  int             i,
                  n;

  if ((fp = open_file(fname, qres.defaultDirectory)) == NULL)
    return -1;

  ReadCommentedFile(fp, rawItems);
  fclose(fp);

  FreeList(protItems);
  for (i = 0; (buf = rawItems[i]); i++) {
    /*
	 * allocate the record
	 */
    protItems[i] = XtNew(struct _protItem);
    /*
	 * find the name
	 */
    GetWord(buf, protItems[i]->name);
    /*
	 * find the command
	 */
    GetWord(lptr, protItems[i]->command);
    /*
	 * find other stuff
	 */
    GetWord(lptr, reqName);
    if (reqName[0] == 'y' || reqName[0] == 'Y')
      protItems[i]->reqName = True;
    else
      protItems[i]->reqName = False;
  }
  protItems[i] = (struct _protItem *)NULL;

  FreeList(rawItems);
  FreeList(disItems);

  for (n = 0; n < i; n++)
    disItems[n] = XtNewString(protItems[n]->name);

  disItems[n] = NULL;

  return 0;
}
