/*
 * Copyright (c) 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] =
    "@(#)/master/usr.sbin/tcpdump/tcpdump/print-chdlc.c,v 2.1 1995/12/10 17:32:00 polk Exp (LBL)";
#endif

#ifdef	C_HDLC

#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#include <net/if.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>
#include <net/if_c_hdlc.h>


#include <stdio.h>

#include "interface.h"
#include "addrtoname.h"
#include "pcap.h"

#define	CHDLC_HDRLEN	sizeof (struct cisco_hdr)
#define	CHDLC_SLARP_HDRLEN	SLARP_SIZE

static void
chdlc_slarp_print(const struct cisco_slarp *slp, int length)
{
	const char *slarp = eflag ? "" : "slarp: ";
	if (length < SLARP_SIZE) {
		printf("[|slarp]");
		return;
	}

	switch (ntohl(slp->csl_code)) {
	case SLARP_REQUEST:
		printf("%srequest",
		       slarp);
		break;

	case SLARP_REPLY:
		printf("%sreply %s/%s",
		       slarp,
		       ipaddr_string(&slp->csl_addr),
		       ipaddr_string(&slp->csl_mask));
		break;

	case SLARP_KEEPALIVE:
		printf("%skeepalive myseq 0x%x yourseq 0x%x time %u",
		       slarp,
		       ntohl(slp->csl_myseq),
		       ntohl(slp->csl_yourseq),
		       ntohs(slp->csl_t1) << 16 + ntohs(slp->csl_t0));
		/* XXX - Format time */
		if (ntohs(slp->csl_rel) != 0xffff) {
		    printf("rel 0x%4x ");
		}
		break;

	default:
		printf("slarp code: %d",
		       ntohl(slp->csl_code));
		break;
	}
}

static void
chdlc_print(const struct cisco_hdr *chp)
{
	switch (chp->csh_addr) {
	case CISCO_ADDR_UNICAST:
		printf("unicast ");
		break;

	case CISCO_ADDR_BCAST:
		printf("bcast ");
		break;

	default:
		printf("address: %x ",
		       chp->csh_addr);
		break;
	}

	if (chp->csh_ctl) {
	    printf("control: %x ",
		   chp->csh_ctl);
	}

	switch (ntohs(chp->csh_type)) {
	case CISCO_TYPE_INET:
	        printf("ip: ");
		break;
		
	case CISCO_TYPE_SLARP:
		printf("slarp: ");
		break;

	default:
		printf("type %04x: ",
		       ntohs(chp->csh_type));
		break;
	}
}

void
chdlc_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{
	int length = h->len;
	int caplen = h->caplen;
	const struct ip *ip;
	const struct cisco_hdr *chp;
	const struct cisco_slarp *slp;

	ts_print(&h->ts);

	if (caplen < CHDLC_HDRLEN) {
		printf("[|cisco_hdlc]");
		goto out;
	}
	    
	/*
	 * Some printers want to get back at the link level addresses,
	 * and/or check that they're not walking off the end of the packet.
	 * Rather than pass them all the way down, we set these globals.
	 */
	packetp = p;
	snapend = p + caplen;

	chp = (struct cisco_hdr *) p;
	if (eflag)
		chdlc_print(chp);

	length -= CHDLC_HDRLEN;

	switch (ntohs(chp->csh_type)) {
	case CISCO_TYPE_INET:
		ip = (struct ip *)(p + CHDLC_HDRLEN);
		ip_print((const u_char *) ip, length);
		break;

	case CISCO_TYPE_SLARP:
		slp = (struct cisco_slarp *) (p + CHDLC_HDRLEN);
		chdlc_slarp_print(slp, length);
		break;

	default:
		if (!eflag) {
		    printf("type %04x: ",
			   ntohs(chp->csh_type));
		}
		break;
	}

	if (xflag)
		default_print(p, caplen);

    out:
	putchar('\n');
}
#else
#include <sys/types.h>
#include <sys/time.h>

#include <stdio.h>

#include "interface.h"
void
chdlc_if_print(u_char *user, const struct pcap_pkthdr *h, const u_char *p)
{
	error("not configured for cisco hdlc");
	/* NOTREACHED */
}
#endif
