/*	BSDI openprom.c,v 1.1 1995/06/12 20:22:07 torek Exp	*/

/*-
 * Copyright (c) 1992 The Regents of the University of California.
 * All rights reserved.
 *
 * This software was developed by the Computer Systems Engineering group
 * at Lawrence Berkeley Laboratory under DARPA contract BG 91-66 and
 * contributed to Berkeley.
 *
 * All advertising materials mentioning features or use of this software
 * must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Lawrence Berkeley Laboratory.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#ifndef lint
static char copyright[] =
    "Copyright (c) 1992 Lawrence Berkeley Laboratory\nAll rights reserved.\n";
#endif

/*
 * openprom dump utility
 *
 * usage:
 *
 *	openprom
 */

#include <sys/types.h>
#include <sys/file.h>
#include <sys/ioctl.h>

#include <machine/openpromio.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pathnames.h"

static	char openprom[] = _PATH_OPENPROM;
int	opfd;

void	dumpnode __P((int, int));
void	dumplist __P((int, int));
int	isstr __P((struct opiocdesc *));
void	printbytes __P((char *, int));

/* ARGSUSED */
int
main(argc, argv)
	int argc;
	char **argv;
{
	int node;

	if ((opfd = open(openprom, O_RDONLY, 0)) < 0)
		err(1, "open(%s)", openprom);

	/* next(0) gets the first one */
	node = 0;
	if (ioctl(opfd, OPIOCGETNEXT, &node) < 0)
		err(1, "ioctl(OPIOCGETNEXT)");
	dumplist(node, 0);
	exit(0);
}

/*
 * Dump all the nodes in the list, nesting their children.
 */
void
dumplist(first, depth)
	int first, depth;
{
	int node, child;

	for (node = first; node != 0;) {
		/* dump this one */
		dumpnode(node, depth);

		/* depth-first: dump list of children of this node */
		child = node;
		if (ioctl(opfd, OPIOCGETCHILD, &child) < 0)
			err(1, "ioctl(OPIOCGETCHILD)");
		dumplist(child, depth + 1);

		/* move on to the next entry */
		if (ioctl(opfd, OPIOCGETNEXT, &node) < 0)
			err(1, "ioctl(OPIOCGETNEXT)");
	}
}

/*
 * Dump all the properties of a node.
 */
void
dumpnode(node, depth)
	int node, depth;
{
	register int i;
	register struct opiocdesc *dp;
	struct opiocdesc desc;
	int v;
	static int beenhere;
	char *name, *cp;
	char buf[1024], buf2[sizeof(buf)];

	if (beenhere)
		(void)putchar('\n');
	beenhere = 1;
	for (i = 1; i < depth; i += 2)
		(void)putchar('\t');
	if (i == depth)
		(void)printf("    ");
	printf("node %x:\n", node);
	depth++;

	dp = &desc;
	dp->op_nodeid = node;

	/* Prime the pump with a zero length name */
	dp->op_name = buf;
	dp->op_name[0] = '\0';
	dp->op_namelen = 0;
	dp->op_buf = buf2;
	for (;;) {
		/* Get the next property name */
		dp->op_buflen = sizeof(buf);
		if (ioctl(opfd, OPIOCNEXTPROP, dp) < 0)
			err(1, "ioctl(OPIOCNEXTPROP)");

		/* Zero length name means we're done */
		if (dp->op_buflen <= 0)
			return;

		/* Clever hack, swap buffers */
		cp = dp->op_buf;
		dp->op_buf = dp->op_name;
		dp->op_name = cp;
		dp->op_namelen = dp->op_buflen;

		/* Get the value */
		dp->op_buflen = sizeof(buf);
		if (ioctl(opfd, OPIOCGET, dp) < 0)
			err(1, "ioctl(OPIOCGET) (for \"%.*s\")",
			    dp->op_namelen, dp->op_name);
		for (i = 1; i < depth; i += 2)
			(void)putchar('\t');
		if (i == depth)
			(void)printf("    ");
		(void)printf("%.*s=", dp->op_namelen, dp->op_name);
		if (isstr(dp))
			(void)printf("%.*s", dp->op_buflen, dp->op_buf);
		else if (dp->op_buflen == sizeof(int)) {
			bcopy(dp->op_buf, &v, sizeof v);
			(void)printf("0x%x (%d)", v, v);
		} else
			printbytes(dp->op_buf, dp->op_buflen);
		(void)putchar('\n');
	}
}

/*
 * Decide whether something "is a string".  It is not a string if
 * it contains unprintable characters, excluding a possible final NUL.
 */
int
isstr(dp)
	register struct opiocdesc *dp;
{
	register char *p;
	register int n;

	p = dp->op_buf;
	for (n = dp->op_buflen; --n >= 0; p++)
		if (!isascii(*p) || !isprint(*p))
			if (n > 0 || *p != 0)
				return (0);

	return (1);
}

void
printbytes(cp, n)
	register char *cp;
	register int n;
{
	char *s = "";

	while (--n >= 0) {
		printf("%s%2.2x", s, *(unsigned char *)cp++);
		s = " ";
	}
}
