/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI shlicrt0.sparc.s,v 2.1 1995/11/09 01:13:56 torek Exp
 */

#define	EMPTY	/* conventional for "instruction below is OK in delay slot" */

/*
 * Bootstrap for programs that use fixed-address static shared libraries.
 */
#define LOCORE		/* XXX */

#include <sys/syscall.h>
#include <machine/trap.h>

/*
 * We must duplicate definitions from include files
 * that aren't compatible with cpp/assembly files.
 */

/* #include <fcntl.h> */
#define O_RDONLY	0

/* #include <sys/mman.h> */
#define PROT_READ	0x04
#define PROT_EXEC	0x01

#define MAP_SHARED	0x0010
#define MAP_FIXED	0x0100

/* #include <sys/param.h> */
#define	CLBYTES		8192

	.text
	.globl start
start:
	! sub	%sp, 96, %sp		! unnecessary, no calls to printf below
	save	%sp, -112, %sp		! build stack frame
	mov	%g1, %i2		! save ps_strings pointer

	/* Point to the library table. */
	set	___LIBRARY_TABLE, %l0

	/*
	 * Open the shared library file.
	 */
	ld	[%l0], %o0		! filename
	mov	O_RDONLY, %o1		! flags
	clr	%o2			! mode
	mov	SYS_open, %g1		! open
	t	ST_SYSCALL
	bcs	Ldisaster
	 EMPTY

	mov	%o0, %i4		! save fd

	/*
	 * Call mmap() to map the first page of the loader file.
	 */
	ld	[%l0 + 4], %o0			! addr
	set	CLBYTES, %o1			! len
	mov	PROT_EXEC|PROT_READ, %o2	! prot
	mov	MAP_SHARED|MAP_FIXED, %o3	! flags
	mov	%i4, %o4			! fd
	! clr	%o5				! (unused)
	st	%g0, [%sp + 92]			! offset (64 bits)
	st	%g0, [%sp + 96]
	mov	SYS_mmap, %g1
	t	ST_SYSCALL
	bcs	Ldisaster
	 EMPTY

	mov	%o0, %l1		! save returned addr (same as old %o0)

	/*
	 * Call the loader initialization routine to get started.
	 * The latter will take care of traditional crt0 concerns
	 * like setting up argv/envp/environ and calling main().
	 * It will also clean up after the bootstrap.
	 */
	set	_main, %o0		! entry point
	set	_end, %o1		! start of heap
	mov	%i2, %o2		! ps_strings
	mov	%l0, %o3		! ___LIBRARY_TABLE
	jmp	%l1 + 32		! enter just past header
	 mov	%i4, %o4		! table

	/*
	 * Print '...: not found' if we can't open or map the loader.
	 * The following code roughly doubles the size of the bootstrap!
	 */
Lnotfound:
	.ascii ": not found\n"

Ldisaster:
	ld	[%l0], %o1		! name
	mov	%o1, %o2		! copy

0:					! strlen inlined, more or less
	ldub	[%o2], %o3
	cmp	%o3, 0
	bne,a	0b
	 inc	%o2

	mov	2, %o0			! fd
	! mov	%o1, %o1		! addr (already set)
	sub	%o2, %o1, %o2		! len (end - start)
	mov	SYS_write, %g1
	t	ST_SYSCALL

	mov	2, %o0			! fd
	set	Lnotfound, %o1		! addr
	mov	12, %o2			! len
	! mov	SYS_write, %g1		! (already set)
	t	ST_SYSCALL

	unimp	0			/* get attention -- dump core */
