/*-
 * Copyright (c) 1994,1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI loader.libc.c,v 2.2 1995/07/26 19:25:12 donn Exp
 */

#include <sys/param.h>
#include <sys/exec.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <machine/shlib.h>

ENTRY

/*
 * Initial internal bootstrap for fixed-address static shared libraries.
 * Called from a stub in programs that use static shared libraries.
 * The loader is always presumed to be embedded in the C library.
 */

extern unsigned long _minbrk;
extern unsigned long curbrk asm("curbrk");	/* XXX should fix */

#define	PS_STRINGS1_1	(0xefc00000 - 2 * CLBYTES - sizeof(struct ps_strings))

char **environ = 0;
char *__progname = 0;
struct ps_strings *__ps_strings = 0;

void
loader(int (*main)(int, char **, char **), long heap, struct ps_strings *psp,
    struct ldtab *lp, int f)
{
	struct exec *e = (struct exec *)lp->address;
	void (*fp)(struct ldtab *, int);
	char *p, *s;

	if (__mmap(lp->address + CLBYTES, e->a_text - CLBYTES,
	      PROT_READ|PROT_EXEC, MAP_PRIVATE|MAP_FIXED, f,
	      0, CLBYTES) == (caddr_t)-1 ||
	    __mmap((caddr_t)(DATA_ADDRESS), e->a_data,
	      PROT_READ|PROT_WRITE|PROT_EXEC, MAP_PRIVATE|MAP_FIXED, f,
	      0, e->a_text) == (caddr_t)-1 ||
	    __mmap((caddr_t)(DATA_ADDRESS) + e->a_data, e->a_bss,
	      PROT_READ|PROT_WRITE|PROT_EXEC, MAP_ANON|MAP_FIXED, -1, 0, 0)
	      == (caddr_t)-1)
		__abort();

	close(f);

	/* Note that we have no data segment until the mmap()s finish! */
	_minbrk = curbrk = heap;
	if (psp == 0)
		psp = (struct ps_strings *)PS_STRINGS1_1;
	__ps_strings = psp;
	environ = psp->ps_envp;
	if ((p = *psp->ps_argv) != NULL) {
		s = strrchr(p, '/');
		__progname = s ? s + 1 : p;
	} else
		__progname = "";

	for (++lp; lp->name; ++lp) {
		if ((f = open(lp->name, O_RDONLY)) == -1 ||
		    __mmap(lp->address, CLBYTES, PROT_READ|PROT_EXEC,
		      MAP_PRIVATE|MAP_FIXED, f, 0, 0) == (caddr_t)-1) {
			write(STDERR_FILENO, "can't open `", 12);
			write(STDERR_FILENO, lp->name, strlen(lp->name));
			write(STDERR_FILENO, "'\n", 2);
			__abort();
		}
		fp = (void (*)(struct ldtab *, int))
		    (lp->address + sizeof (struct exec));
		(*fp)(lp, f);
		close(f);
	}

	exit((*main)(psp->ps_argc, psp->ps_argv, psp->ps_envp));
}

LIBRARY

PAD
