/*-
 * Copyright (c) 1994,1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI loader.c,v 2.3 1995/07/26 17:22:40 donn Exp
 */

#include <sys/param.h>
#include <sys/exec.h>
#include <sys/mman.h>

#include <machine/shlib.h>

ENTRY

/*
 * Internal bootstrap for fixed-address static shared libraries.
 * Called from the main bootstrap loader (embedded in the shared C library).
 */

void
loader(struct ldtab *lp, int f)
{
	struct exec *e = (struct exec *)lp->address;

	if (__mmap(lp->address + CLBYTES, e->a_text - CLBYTES,
	      PROT_READ|PROT_EXEC, MAP_PRIVATE|MAP_FIXED, f,
	      0, CLBYTES) == (caddr_t)-1 ||
	    __mmap((caddr_t)(DATA_ADDRESS), e->a_data,
	      PROT_READ|PROT_WRITE|PROT_EXEC, MAP_PRIVATE|MAP_FIXED, f,
	      0, e->a_text) == (caddr_t)-1 ||
	    __mmap((caddr_t)(DATA_ADDRESS) + e->a_data, e->a_bss,
	      PROT_READ|PROT_WRITE|PROT_EXEC, MAP_ANON|MAP_FIXED, -1, 0, 0)
	      == (caddr_t)-1)
		__abort();

	/* library-specific initializations would go here */
}

LIBRARY

PAD
