/*-
//////////////////////////////////////////////////////////////////////////
//									//
//   Copyright (c) 1995 Migration Associates Corp. All Rights Reserved	//
//									//
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF MIGRATION ASSOCIATES	//
//	The copyright notice above does not evidence any   		//
//	actual or intended publication of such source code.		//
//									//
//	Use, duplication, or disclosure by the Government is		//
//	subject to restrictions as set forth in FAR 52.227-19,		//
//	and (for NASA) as supplemented in NASA FAR 18.52.227-19,	//
//	in subparagraph (c) (1) (ii) of Rights in Technical Data	//
//	and Computer Software clause at DFARS 252.227-7013, any		//
//	successor regulations or comparable regulations of other	//
//	Government agencies as appropriate.				//
//									//
//		Migration Associates Corporation			//
//			19935 Hamal Drive				//
//			Monument, CO 80132				//
//									//
//	A license is granted to Berkeley Software Design, Inc. by	//
//	Migration Associates Corporation to redistribute this software	//
//	under the terms and conditions of the software License		//
//	Agreement provided with this distribution.  The Berkeley	//
//	Software Design Inc. software License Agreement specifies the	//
//	terms and conditions for redistribution.			//
//									//
//	UNDER U.S. LAW, THIS SOFTWARE MAY REQUIRE A LICENSE FROM	//
//	THE U.S. COMMERCE DEPARTMENT TO BE EXPORTED.  IT IS YOUR	//
//	REQUIREMENT TO OBTAIN THIS LICENSE PRIOR TO EXPORTATION.	//
//									//
//////////////////////////////////////////////////////////////////////////
*/

/*
 * Structure defining a record for a user.  All fields 
 * stored in ascii to facilitate backup/reconstruction.
 * A null byte is required after the share secret field.
 */

typedef	struct	{
	char	uname[L_cuserid];	/* user login name	*/
	char	secret[16];		/* token shared secret	*/
	unsigned flags;			/* record flags		*/
	unsigned mode;			/* token mode flags	*/
	time_t	lock_time;		/* time of record lock	*/
	char	reserved_char1[8];
	char	reserved_char2[8];
	char	reserved_char3[80];
} CRYPTODB_Rec;

/*
 * Record flag values
 */

#define	CRYPTO_LOCKED	0x1		/* record locked for updating	*/
#define	CRYPTO_ENABLED	0x2		/* user login method enabled	*/
#define	CRYPTO_LOGIN	0x4		/* login in progress lock	*/

/*
 * Function prototypes for routines which manipulate the 
 * database for the token.  These routines have no knowledge
 * of DES or encryption.  However, they will manipulate the
 * flags field of the database record with complete abandon.
 */

extern	int	cryptodb_delrec(char *);
extern	int	cryptodb_getrec(char *, CRYPTODB_Rec *);
extern	int	cryptodb_putrec(char *, CRYPTODB_Rec *);
extern	int	cryptodb_firstrec(int, CRYPTODB_Rec *);
extern	int	cryptodb_nextrec(int, CRYPTODB_Rec *);
extern	int	cryptodb_lockrec(char *, CRYPTODB_Rec *, unsigned);
