#!/usr/bin/perl

#
# Copyright (c) 1994,1995 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI	configure_all.pl,v 2.7 1996/01/12 18:08:45 polk Exp

require '/etc/adm/lib/adm.pl';
require '/etc/adm/lib/v.pl';

# Make sure we're running as root
if ($> != 0) {
	print "$0: this program must be run as root!\n";
	exit 1;
}

$| = 1;  # Make STDOUT unbuffered...

$TITLE="BSD/OS System Configuration";
$TEXT="Welcome to BSD/OS system configuration...

You will be asked general questions necessary for initial 
configuration of the system.  Once you have completed configuration, 
the system will continue booting to multi-user mode.

If you do not wish to follow the normal configuration procedure, 
type <Control>-C and you will be placed in the single-user shell.";
&vquery("Press <Enter> to continue");

# explain the rules...
&vexplain("BSD/OS Configuration");

# Configure netstart
system("$ADMBIN/config_netstart -n");

# Configure IPX if config_ipx exists
system("$ADMBIN/config_ipx -e") if -x "$ADMBIN/config_ipx";

# Set the timezone
&set_timezone;

# Set the root password
if ($> == 0) {
	for (;;) {
		&v_reset();
		print <<ETX;
Please set the super-user (root) password for this machine.  The
password will not be displayed on the screen.

ETX
		last if !system("/usr/bin/passwd -l root");
	}
}
print "\n";

# Set up DNS
$COMMENTS="Name Service Configuration";
$TEXT="If this machine is to be part of a network, you will probably
want to use DNS (Domain Name Service).  If there currently is no
DNS server for your domain you may wish to configure this machine as
a primary server.  If there is already a DNS server available, you
probably should use it as a remote DNS server for this machine.  If
this machine is not attached to a network you probably should choose
to not have a nameserver.

If you choose none, you may always configure DNS later by using the
`config_dns' command.";

$_ = &vquery("Be a primary DNS server, use a remote server, or none?",
	"remote", ("primary", "remote", "none"));

if (/primary/) {
	&v_reset();
	system("$ADMBIN/config_dns -k");
} elsif (/remote/) {
	&config_resolver;
}

# Set up anonymous ftp server XXX

# Set up WWW server
$COMMENTS="Configure WWW service";
if ( -d $WWWHOME ) {
	$TEXT="If you wish to set up a World-Wide-Web (http) server on this 
machine, you may do so now.  If you wish to set it up later or to modify 
the setup, you can always use the `config_www' command.";
	$_ = &vquery("Do you wish to configure a WWW server now?", "no", ("yes", "no"));
	if (/yes/) {
		&v_reset();
		system("$ADMBIN/config_www -k -n");
	}
}

$COMMENTS="Create login for system administrator";
$TEXT="The next configuration step is to create a system administrator
login.  This user will receive root's mail (e.g., daily reports,
mail to postmaster, etc.) and will be added to the wheel group so
that they may use the `su' command to become root.";
$_ = &vquery("Create system administrator login now?", "yes", ("yes", "no"));
&create_admin_login if /yes/;

$TEXT="If you wish to install any of the packages distributed on floppies, 
you may do so at this time.  If you wish to install additional 
packages later, you can always use the `installfloppy' command.";

for (;;) {
	$_ = &vquery("Do you wish to install packages from a floppy now?", 
			"no", ("yes", "no"));
	last if /no/;
	&v_reset();
	system("installfloppy") && print STDERR "$0: installfloppy failed\n";
}

$TEXT="Initial configuration completed successfully.

Login as root and add users with the `adduser' command...";
&vquery("Press <Enter> to continue.");
&v_reset();

exit 0;

sub set_timezone {
	local($_, @TZ_DIRS, @TZ_MISC, @_, @uszones, @allzones);

	$zone="..";
	while ($zone eq "..") {
		@TZ_DIRS=("Misc");
		@TZ_MISC=("..");
		foreach $file (split(/^/, `ls $TZDIR`)) {
			$_=$file;
			chop;
			next if /^[^A-Z]/;
			next if /^SystemV/;
			push(@TZ_DIRS, $_) if (-d "$TZDIR/$_");
			push(@TZ_MISC, $_) if (-f "$TZDIR/$_");
		}
		$INVALID="";
		$COMMENTS="Setting time zone";
		$HELP=
	"Each of the areas listed contains a list of cities and or timezones.
	Select the area that you are in.  The region \"Etc\" contains standard
	timezones and \"Misc\" contains a random assortment of timezones.";
		$TEXT="The following regions are available:\n\n";
		&v_addlist(sort @TZ_DIRS);

		$tregion = "__None__";
		while (grep(/^$tregion/i, @TZ_DIRS) != 1) {
			$tregion = &vquery("Which region is this machine located in?",
				"US");
			$INVALID="Invalid response.  Please choose from the list.";
		}
		$INVALID="";

		foreach $_ (@TZ_DIRS) {
			if ($_ =~ /^$tregion/i) {
				$region=$_;
			}
		}

		if ($region eq "Misc") {
			$region="";
			@TZ_LIST=@TZ_MISC;
		} else {
			@TZ_LIST=("..");
			foreach $file (split(/^/, `ls $TZDIR/$region`)) {
				$_=$file;
				chop;
				push(@TZ_LIST, $_) if -f "$TZDIR/$region/$_";
			}
		}
		$TEXT="The following zones or cities are defined for this region:\n\n";
		$HELP=
	"Please select a city which is in the same timezone as this machine
	is located, or if listed, the actual timezone.

	Select \"..\" to return to the list of regions.";
		&v_addlist(sort @TZ_LIST);

		$tzone = "__None__";
		while (grep(/^$tzone/i, @TZ_LIST) != 1) {
			$tzone = &vquery("Which time zone (\"..\" to return to the list of regions)?");
			$INVALID="Invalid response.  Please choose from the list.";
			last if $tzone eq "..";
		}
		$INVALID="";

		if ($tzone eq "..") {
			$zone="..";
		} else {
			foreach $_ (@TZ_LIST) {
				if ($_ =~ /^$tzone/i) {
					$zone=$_;
				}
			}
			if (system("cp $TZDIR/$region/$zone /etc/localtime")) {
				$HELP="";
				$TEXT=
"Could not copy timezone information into place.  This is not good.
The probable reason is that your root file system is not writable.";
				&vquery("Press <ENTER> to continue anyhow: ");
			}
		}
	}
}

sub config_resolver {
	$COMMENTS="Configure for use of a remote nameserver";
	$TEXT="Enter the IP address of the machine which runs the 
local name service (e.g., 192.0.0.23).

If you do not wish to configure to use a remote nameserver
enter `none'";

	for (;;) {
        	$_ = &vquery("IP address of nameserver machine?");
		return if /none/i;
        	$ipaddr = $_;
        	last if /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
		$INVALID="Invalid entry: $_";
	}
	system("cp $RESOLV $RESOLV.bak >/dev/null 2>&1");
	if (!open (OUT, ">$RESOLV")) {
		$TEXT= "$RESOLV was able to be opened for writing.
Remote nameservice is not configured";
		&vquery("Press <ENTER> to continue: ");
		return;
	}
	print OUT "nameserver $ipaddr\n";
	close (OUT);
}

sub create_admin_login {
	$TEXT=
"Enter the login name of the system administrator for this site.  If 
the account does not already exist, you will be prompted for the 
information necessary to create it.  This account will receive mail
addressed to \"root\", \"postmaster\", and several other system aliases.";
	for (;;) {
		$_ = &vquery("System administrator login?", $login);
		if (!/^[a-zA-Z][a-zA-Z0-9]*$/ || length($_) > 16) {
			$COMMENTS=
"Login names must be 16 characters or fewer, must start with a letter, 
and may contain only letters and digits.";
			next;
		}
		$login = $_;
		$_ = &vquery("Is `$login' the correct name?", "yes", ("no", "yes"));
		last if /yes/;
	}
	&v_reset();
	if (!`grep ^$login: $PASSWD`) {
		# Create the account
		system("$ADMBIN/adduser -S /usr/share/skel.sysadm $login");
		# Put it in the wheel group for su
		&parsegroup;
		$members{"wheel"} .= ",$login";
		&writegroup;
	}
	
	# Update the root alias (if it's still a comment)
	if ($login ne "root") {
		system("cp $ALIASES $ALIASES.bak") && die "$0: couldn't save backup copy of $ALIASES\n";
		open (IN, "$ALIASES.bak") || die "$0: couldn't open copy of $ALIASES for reading\n";
		open (OUT, ">$ALIASES") || die "$0: couldn't open $ALIASES for writing\n";
		while (<IN>) {
			s/^#root:.*/root:\t$login/;
			print OUT $_;
		}
		close(IN);
		close(OUT);
	}
}
