#!/usr/bin/perl

#
# Copyright (c) 1994 Berkeley Software Design, Inc.
# All rights reserved.
# The Berkeley Software Design Inc. software License Agreement specifies
# the terms and conditions for redistribution.
#
#	BSDI	config_netstart.pl,v 2.5 1995/12/26 23:26:55 polk Exp

require '/etc/adm/lib/adm.pl';
require '/etc/adm/lib/v.pl';

$INSTALL="Network Config";
$TITLE="BSD/OS Network Configuration";
# Make sure we're running as root
if ($> != 0) {
        print "$0: this program must be run as root!\n";
	exit 1;
}

$| = 1;  # Make STDOUT unbuffered...

require 'getopts.pl';
&Getopts('n') || die "Usage: $0\n";

# read the current settings for netstart
&readsimple($NETSTART_DEF, 0);
%netstart = %fields;

&querysystem();
if ($found{"network"} eq "") {
	@network = @pocket;
}

# explain the rules...
&vexplain("BSD/OS Network Configuration") if !$opt_n;

# set up a label so we can do it all over again...
restart:

# Host name
for (;;) {
	$TEXT=
"The host name for a machine should be the fully qualified 
name of the machine (e.g., myhost.mydomain.com).  Host names
and domain names can consist of letters, numbers, and `_'.";
	$_ = &vquery("Host name for this machine?", $netstart{"HOST"});
	if (!/\./) {
		$COMMENTS=
"The hostname MUST be the fully qualified name (including the domain part).";
		$INVALID="Invalid entry: $_";
		next;
	}
	last if /^[-A-Za-z0-9_\.]+$/;
}
$host = $_;
$netstart{"HOST"} = $host;

# IP Address
$ipaddr="";
$cip="";


if ($#network >= 0) {
	$TEXT="
Ethernet interfaces enable the machine to talk to remote hosts over
the local ethernet or LAN.";

	$_ = &vquery("Do you wish to configure an ethernet interface?", 
		$tries ? "no" : "yes", ("yes", "no"));
	if (!/^[yY]/) {
		undef $netstart{"ADDR"};
		undef $netstart{"IFACE"};
		undef $netstart{"ITYPE"};
		undef $netstart{"MASK"};
		undef $netstart{"DEFRT"};
	} else {
		$cip="yes";
	}
}
$netstart{"ADDR"} = $ipaddr if $ipaddr ne "";

# Ethernet interface

$iface="";
if ($cip ne "") {
	local($oldiface);

	# Ethernet interface

	if ($#network > 0) {
		$TEXT="One ethernet interface may be automatically configured.
The available ethernet interfaces are:\n\n";

		$oldiface = -1;
		for ($i=0; $i<=$#network; $i++) {
			$network[$i] =~ /(.*)[0-9]/;
			$iface = $1;
			$_ = sprintf("%s) %s (%s)", $i+1, $desc{$iface}, $network[$i]);
			$TEXT.="$_\n";
			$oldiface = $i if $netstart{"IFACE"} eq $network[$i];
		}

		for (;;) {
			$_ = &vquery("Which interface?", $oldiface+1);
			for ($i=0; $i<=$#network; $i++) {
				last if ($network[$i] eq $_);
			}
			last if $i<=$#network;
			next if !/^[0-9]$/;
			next if $_ < 1;
			last if $_ <= $#network+1;
		}
		$iface = $network[$_-1];
	} else {
		$iface = $network[0];
	}
	$COMMENTS="Configuring ethernet interface $iface";
	undef $netstart{"LINK"} if $iface ne $netstart{"IFACE"};
	$netstart{"IFACE"} = $iface;

	# Interface type

	$iface =~ /(.*)[0-9]/;
	$it = $1;
	$checkf = "check_".$it;
	if (defined(&$checkf)) {
		&$checkf($iface);
	}

	$lo = $linkoptions{$it};
	if ($lo =~ /:$/) {
		$lo .= "-";
	} 
	if ($lo ne "") {
		@links = split(/:/, $lo);
		@linkd = split(/:/, $linkdesc{$it});
	} else {
		$#links = -1;
		$#linkd = -1;
	}

	if ($#linkd == 0) {
		$linkarg = $links[0];
		$linktype = $linkd[0];
	} elsif ($#linkd > 0) {
		$TEXT=
"Some models of your ethernet card support several types of interfaces:

        @linkd

In order to configure the driver for your card, you must specify which
interface type you will be using.";

		$deflnk = "";
		$HELP=
"The interface types available are:

";
		for ($i = 0; $i <= $#linkd; ++$i) {
			$HELP.=$desc{$linkd[$i]};
			$HELP.="\n";
			if ($links[$i] eq $netstart{"LINK"}) {
				$deflnk = $linkd[$i];
			}
		}
		$HELP.="
If your card has hardware configuration jumpers to set the 
interface type, you will need to have those configured correctly
as well for the interface to work properly.";
		$_ = &vquery("Which interface type? (@linkd)", $deflnk, @linkd);
		$linktype = $_;
		tr/a-z/A-Z/;
		for ($i = 0; $i <= $#linkd; ++$i) {
			$linkarg = $links[$i] if $linkd[$i] eq $_;
		}
	} else {
		$linkarg = "";
		$linktype = "";
	}
	@lnk = split(/\//, $linkarg);
	$linkarg = $lnk[0];
	if ($linkarg eq "-") {
		$linkarg = "";
	}
	$netstart{"LINK"} = $linkarg;

	# netmask

	$TEXT=
"The IP address which will be assigned to this ethernet adapter
must be specified. (Enter \"help\" for more information)";


	$ipaddr = &vquery_addr("IP address of this machine?", $netstart{"ADDR"});
	$netstart{"ADDR"} = $ipaddr;

	$TEXT=
"If you are using a non-standard netmask, enter the netmask you wish to use
(in standard dotted quad notation: e.g., 255.255.255.0,
or 16 digit hexadecimal: e.g., 0xffffff00)
For most sites (or if you don't know), just accept the default value.

(Enter \"help\" for more information)";

	$mask = &vquery_mask("Netmask for this network?",
		defined($netstart{"MASK"}) ? $netstart{"MASK"} : "default");

	$netstart{"MASK"} = $mask;

	# Default route?
	for (;;) {
		$TEXT=
"A ``default route'' is used to specify the IP address of the host which 
should receive packets destined for machines that aren't on your local 
network.  If you are using a router (e.g., CISCO), you should specify
the IP address of that router.  If you are using this BSD system as the 
router, you should NOT specify a ``default route.''";
		$_ = &vquery("IP address of router (`none' for no default route)?", defined($netstart{"DEFRT"}) ? $netstart{"DEFRT"} : "none");
		last if $_ eq "none";
		last if /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
		$INVALID="Invalid entry: $_";
	}
	if ($_ eq "none") {
		undef $netstart{"DEFRT"};
	}
	else {
		$netstart{"DEFRT"} = $_;
		$defrt = $_;
	}
}

$TEXT=
"You have now answered all the questions necessary for basic network
configuration.  If you didn't make any mistakes while entering your
answers, simply continue and the appropriate configuration files
will be written to your hard disk.

If you wish to exit this program without writing out the configuration
files, type <Control>-C.

Your current answers are:\n\n";
$TEXT.="Host Name: $netstart{\"HOST\"}\n";
$TEXT.=sprintf("IP Address: %s\n", defined($netstart{"ADDR"}) ? $netstart{"ADDR"} : "(none)");
$iface =~ /(.*)[0-9]/;
$TEXT.=sprintf("Ethernet interface: %s%s(%s)%s\n",
	$iface, defined($iface) ? " " : "",
	defined($iface) ? $desc{$1} : "none",
	defined($netstart{"ITYPE"}) ? " ($netstart{\"ITYPE\"})" : "");
$TEXT.=sprintf("Special Netmask: %s\n", defined($netstart{"MASK"}) ? $netstart{"MASK"} : "(none)");
$TEXT.=sprintf("Default Route: %s\n", defined($netstart{"DEFRT"}) ? $netstart{"DEFRT"} : "(none)");
$_ = &vquery("Do you wish to go through the questions again?", 
		$looptries++ ? "no" : "yes", ("yes", "no"));
goto restart if /^[yY]/;

&writesimple($NETSTART_DEF, %netstart);

open (TMP, ">$ETC/netstart.tmp") || 
	die "$0: can't open $ETC/netstart.tmp: $!\n";
print TMP <<ETX;
#
# netstart - configure network daemons, interfaces, and routes
#
# Do not change lines above the `DO NOT DELETE THIS LINE' line.  They
# are generated by the $0 program.  You can change them by re-running
# that program or by placing additional assignments (or other changes)
# after that line.
#
ETX
print TMP "\n";
print TMP "hostname=$host\n";
if ($iface ne "") {
	print TMP "iface=${iface}\n";
}
else {
	print TMP "iface=\n";
}
print TMP "ipaddr=$ipaddr\n";
print TMP "linkarg=\"$linkarg\"\n";
print TMP "netmask=$mask\n";
print TMP "defroute=$defrt\n";
print TMP "\n# DO NOT DELETE THIS LINE -- make local changes below here\n";

$got_netstart=1;
if (open (NETSTART, "$ETC/netstart")) {
	while (<NETSTART>) {
		/^# DO NOT DELETE THIS LINE/ && last;
	}
	if (eof(NETSTART)) {
		$got_netstart = 0;
		$tmp = "$ETC/netstart.bak";
		while (-f $tmp) {
			$tmp .= ".bak";
		}
		$TEXT=
"You appear to have an old-style netstart file (without the 
machine generated part).  A copy of that version of the file 
will be saved in $tmp.";
		&vquery("Press <ENTER> to continue");
		system("/bin/cp $ETC/netstart $tmp") && 
			print STDERR "$0: WARNING: can't save old netstart\n";
	}
	else {
		while (<NETSTART>) {
			print TMP $_;
		}
	}
	close NETSTART;
}
else {
	# No error for now if netstart didn't exist
	# print STDERR "$0: WARNING: can't open $ETC/netstart: $!\n";
	$got_netstart=0;
}

if (!$got_netstart) {
	open (PROTO, "$CONFIGPATH/proto/netstart") ||
		die "$0: can't open $CONFIGPATH/proto/netstart: $!\n";
	while (<PROTO>) {
		print TMP $_;
	}
	close PROTO;
}

close TMP;
rename ("$ETC/netstart.tmp", "$ETC/netstart") || 
	die "$0: can't rename $ETC/netstart.tmp into place: $!\n";

#
# Make sure there's an entry for the local host name in /etc/hosts
#
$ipaddr="127.1" if $ipaddr eq "";
open (TMP, ">$ETC/hosts.tmp") || 
	die "$0: can't open $ETC/hosts.tmp: $!\n";
if (open (HOSTS, "$ETC/hosts")) {
	while (<HOSTS>) {
		/#/ && do { print TMP $_; next; };
		/\s$host\s/ && do { $hostline=$_; next; };
		print TMP $_;
	}
}
close HOSTS;
if ($hostline ne "") {
	$hostline =~ s/[\d\.]+\s/$ipaddr\t/;
}
else {
	$hostline = "$ipaddr\t$host\n";
}
print TMP $hostline;
close TMP;
rename ("$ETC/hosts.tmp", "$ETC/hosts") || 
	die "$0: can't rename $ETC/hosts.tmp into place: $!\n";

&v_reset();
print "$ETC/netstart configuration completed successfully.\n";
if (!$opt_n) {
	print "These changes will take effect at the next reboot.\n";
}
print "\n";

exit 0;
