/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI login_activ.c,v 1.1 1995/10/07 05:53:04 prb Exp
 */
#include <sys/types.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <login_cap.h>

#include "activ.h"

char	*getpass __P((char *));
char	*getepass __P((char *));
void	rip __P((char *));

extern char *__progname;

main(argc, argv)
	int argc;
	char **argv;
{
	FILE *back;
    	char *class = 0;
    	char *username = 0;
	char passbuf[80];
	char *pp;
	int c;
	int ftp = 0;
	char *instance;
	char *uname;		/* copy of username including instance	*/

	struct rlimit cds;

	(void)signal(SIGQUIT, SIG_IGN);
	(void)signal(SIGINT, SIG_IGN);
	(void)setpriority(PRIO_PROCESS, 0, 0);

	openlog("login", LOG_ODELAY, LOG_AUTH);

	cds.rlim_cur = 0;
	cds.rlim_max = 0;
	if (setrlimit(RLIMIT_CORE, &cds) < 0)
		syslog(LOG_ERR, "couldn't set core dump size to 0: %m");

    	while ((c = getopt(argc, argv, "s:")) != EOF)
		switch(c) {
		case 's':	/* service */
			if (strcmp(optarg, "login") == 0)
				ftp = 0;
			else if (strcmp(optarg, "ftp") == 0)
				ftp = 1;
			else {
				syslog(LOG_ERR, "%s: invalid service for %s",
				    optarg, __progname);
				exit(1);
			}
			break;
		default:
			syslog(LOG_ERR, "usage error for %s", __progname);
			exit(1);
		}

	switch(argc - optind) {
	case 2:
		class = argv[optind + 1];
	case 1:
		username = argv[optind];
		break;
	default:
		syslog(LOG_ERR, "usage error for %s", __progname);
		exit(1);
	}


#ifdef DEBUG
	back = stdout;
#else
	if (!ftp && !(back = fdopen(3, "a")))  {
		syslog(LOG_ERR, "reopening back channel for login_activ");
		exit(1);
	}
#endif
	activchallenge("ActivCard");


    	if (ftp) {
		if (fgets(passbuf, sizeof(passbuf), stdin) == NULL)
			exit(1);
		rip(passbuf);
		pp = passbuf;
	} else {
		pp = getpass("ActivCard Response:");
		rip(pp);
		if (strlen(pp) == 0) {
			pp = getepass("ActivCard Response [echo on]: ");
			rip(pp);
		}
    	}

	uname = strdup(username);

	if (instance = strchr(username, '.'))
		*instance = 0;

	if (activverify(uname, pp) == 0) {
		if (!ftp) {
			fprintf(back, BI_AUTH "\n");
			if (instance && (!strcmp(instance, "root")))
				fprintf(back, BI_ROOTOKAY "\n");
			fprintf(back, BI_SECURE "\n");
		}
		exit(0);
	}
	if (!ftp)
                fprintf(back, BI_REJECT "\n");
	exit(1);
}

/*
 * Strip trailing cr/lf from a line of text
 */

void
rip(buf)
char *buf;
{
        char *cp;

        if((cp = strchr(buf,'\r')) != NULL)
                *cp = '\0';

        if((cp = strchr(buf,'\n')) != NULL)
                *cp = '\0';
}

