/*	BSDI size.c,v 2.2 1995/10/01 15:39:00 torek Exp	*/

/*
 * Copyright (c) 1988, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright (c) 1988, 1993\n\
	The Regents of the University of California.  All rights reserved.\n";
#endif /* not lint */

#ifndef lint
static char sccsid[] = "@(#)size.c	8.2 (Berkeley) 12/9/93";
#endif /* not lint */

#include <sys/param.h>
#include <sys/file.h>

#include <a.out.h>
#include <ar.h>
#include <dirent.h>
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <archive.h>

void	display __P((char *, char *, struct exec *, int));
int	size __P((char *, int));
void	usage __P((void));

int
main(argc, argv)
	int argc;
	char *argv[];
{
	int ch, eval;

	while ((ch = getopt(argc, argv, "")) != EOF)
		switch(ch) {
		case '?':
		default:
			usage();
		}
	argc -= optind;
	argv += optind;

	eval = 0;
	if (*argv)
		do {
			if (size(*argv, argc))
				eval = 1;
		} while (*++argv);
	else
		if (size("a.out", 1))
			eval = 1;
	exit(eval);
}

/* Globals required by the ar code we're sharing. */
CHDR chdr;				/* converted header */
char *archive;				/* archive name */
u_int options;				/* UNUSED -- keep open_archive happy */

/*
 * size --
 *	Decide if a file is in archive or a.out format.
 */
int
size(name, count)
	int count;
	char *name;
{
	struct exec head;
	off_t off;
	int fd;
	char buf[SARMAG];

	if ((fd = open(name, O_RDONLY, 0)) < 0) {
		warn("%s", name);
		return (1);
	}

	/* Check for an a.out file. */
	if (read(fd, &head, sizeof(head)) == sizeof(head) && !N_BADMAG(head)) {
		display(name, NULL, &head, count);

		(void)close(fd);
		return (0);
	}

	/* Check for an archive. */
	(void)lseek(fd, 0, SEEK_SET);
	if (read(fd, buf, SARMAG) == SARMAG && !memcmp(buf, ARMAG, SARMAG)) {
		archive = name;
		while (get_arobj(fd)) {
			off = lseek(fd, 0, SEEK_CUR);
			if (read(fd, &head,
			    sizeof(head)) == sizeof(head) && !N_BADMAG(head))
				display(name, chdr.name, &head, 2);
			(void)lseek(fd, off, SEEK_SET);
			skip_arobj(fd);
		}

		(void)close(fd);
		return (0);
	}

	(void)close(fd);
	warnx("%s: not in a.out or archive format", name);
	return (1);
}

/*
 * display --
 *	Display contents of a struct exec.
 */
void
display(name, member, ep, count)
	char *name, *member;
	struct exec *ep;
	int count;
{
	u_long total;
	static int first = 1;

	if (first) {
		first = 0;
		(void)printf("text\tdata\tbss\tdec\thex\n");
	}
	total = ep->a_text + ep->a_data + ep->a_bss;
	(void)printf("%lu\t%lu\t%lu\t%lu\t%lx",
	    ep->a_text, ep->a_data, ep->a_bss, total, total);
	if (count > 1) {
		(void)printf("\t%s", name);
		if (member != NULL)
			(void)printf(":%s", member);
	}
	(void)printf("\n");
}

void
usage()
{
	(void)fprintf(stderr, "usage: size [file ...]\n");
	exit(1);
}
