/* BSDI readsys.c,v 2.5 1995/10/18 08:33:34 prb Exp */

#include <stdlib.h>
#include <string.h>

#include "ppp.h"

char   *AT;     /* Auto call unit type. */
long    BR;     /* Baud rate. */
int     CD;     /* 100th second delays between commands on dialing */
char   *CM;     /* Map of special characters (as in pppconfig) */
char   *CU;     /* Call unit if making a phone call. */
int     DI;     /* Dial-in allowed. */
int     DO;     /* Automatic dial-out allowed. */
long    DT;     /* Dial timeout. */
int     DU;     /* This is a dial-up line */
char   *DV;     /* Device(s) to open to establish a connection. */
char   *E[10];  /* Strings to wait for on nth step of logging in */
                /* (after sending s0-s9) */
char   *F[10];  /* Strings to send if no expected str appeared */
long    ID;     /* Disconnect on idle (n seconds) */
char   *IF;     /* Space-separated list of ifconfig parameters. */
int     IM;     /* Immediate Connection (don't wait to "redial") */
long    IN;     /* Interface number. */
int     KU;     /* Keep the interface marked up. */
char   *LD;     /* Script to run when link goes down. */
char   *LF;     /* Script to run after system logs in but connection fails. */
char   *LI;     /* Script to run when a system logs in. */
char   *LU;     /* Script to run when link comes up. */
long    MC;     /* Max PPP config retries. */
long    MR;     /* PPP MRU. */
char   *MS;     /* Stty-style string defining port setup. */
long    MT;     /* Max PPP terminate retries. */
char   *PF;     /* Comma-separated list of PPP flags (as in pppconfig) */
char   *PN;     /* Telephone number(s) for this host. */
int     SL;     /* Use SLIP instead of PPP */
char *  SO;     /* Script options */
char   *S[10];  /* String to send on nth step of logging in. */
long    T[10];  /* Timeout in seconds for e0-e9 */
long    TO;     /* PPP retrty timeout (1/10 sec). */
long    WT;     /* How long to wait for certain events, such as BOS */

/*
 * Capability types
 */
#define STR     0
#define NUM     1
#define BOOL    2

#define P       (char **)

static struct captab {
	char    *name;
	int     type;
	char    **ptr;
} captab[] = {
	"at",   STR,    &AT,
	"br",   NUM,    P &BR,
	"cd",   NUM,    P &CD,
	"cm",   STR,    &CM,
	"cu",   STR,    &CU,
	"di",   BOOL,   P &DI,
	"do",   BOOL,   P &DO,
	"du",   BOOL,   P &DU,
	"dt",	NUM,	P &DT,
	"dv",   STR,    &DV,
	"e0",   STR,    &E[0],
	"e1",   STR,    &E[1],
	"e2",   STR,    &E[2],
	"e3",   STR,    &E[3],
	"e4",   STR,    &E[4],
	"e5",   STR,    &E[5],
	"e6",   STR,    &E[6],
	"e7",   STR,    &E[7],
	"e8",   STR,    &E[8],
	"e9",   STR,    &E[9],
	"f0",   STR,    &F[0],
	"f1",   STR,    &F[1],
	"f2",   STR,    &F[2],
	"f3",   STR,    &F[3],
	"f4",   STR,    &F[4],
	"f5",   STR,    &F[5],
	"f6",   STR,    &F[6],
	"f7",   STR,    &F[7],
	"f8",   STR,    &F[8],
	"f9",   STR,    &F[9],
	"id",   NUM,    P &ID,
	"if",   STR,    &IF,
	"im",   BOOL,   P &IM,
	"in",   NUM,    P &IN,
	"ku",	BOOL,	P &KU,
	"ld",   STR,    &LD,
	"lf",   STR,    &LF,
	"li",   STR,    &LI,
	"lu",   STR,    &LU,
	"mc",   NUM,    P &MC,
	"mr",   NUM,    P &MR,
	"ms",   STR,    &MS,
	"mt",   NUM,    P &MT,
	"pf",   STR,    &PF,
	"pn",   STR,    &PN,
	"s0",   STR,    &S[0],
	"s1",   STR,    &S[1],
	"s2",   STR,    &S[2],
	"s3",   STR,    &S[3],
	"s4",   STR,    &S[4],
	"s5",   STR,    &S[5],
	"s6",   STR,    &S[6],
	"s7",   STR,    &S[7],
	"s8",   STR,    &S[8],
	"s9",   STR,    &S[9],
    	"sl",	BOOL,	P &SL,
    	"so",	STR,	&SO,
	"t0",   NUM,    P &T[0],
	"t1",   NUM,    P &T[1],
	"t2",   NUM,    P &T[2],
	"t3",   NUM,    P &T[3],
	"t4",   NUM,    P &T[4],
	"t5",   NUM,    P &T[5],
	"t6",   NUM,    P &T[6],
	"t7",   NUM,    P &T[7],
	"t8",   NUM,    P &T[8],
	"t9",   NUM,    P &T[9],
	"to",   NUM,    P &TO,
	"wt",   NUM,    P &WT,
	0,      0,      0
};

char *rgetstr();

void
getsyscap(host, file)
	register char *host;
	char *file;
{
	int stat;
	char *buf;
	char *equal;
	char *capfiles[] = { file, 0 };
	struct captab *t;

	if ((stat = cgetent(&buf, capfiles, host)) != 0) {
		switch (stat) {
		case 1:
			warnx("couldn't resolve 'tc' for %s in %s",
				host, capfiles[0]);
			break;
		case -1:
			warnx("host '%s' unknown in %s", host, capfiles[0]);
			break;
		case -2:
			warn("%s: getting host data in %s", host, capfiles[0]);
			break;
		case -3:
			warnx("'tc' reference loop for %s in %s",
				host, capfiles[0]);
			break;
		default:
			warnx("ppp: unexpected cgetent() error for %s in %s",
				host, capfiles[0]);
			break;
		}		
		exit(1);
	}

	for (t = captab; t->name != 0; t++) {
		switch (t->type) {
		case STR:
			cgetstr(buf, t->name, t->ptr);
			break;
		case NUM:
			if (cgetnum(buf, t->name, (long *)(t->ptr)) == -1)
				*(int *)t->ptr = -1;
			break;
		case BOOL:
			*(int *)t->ptr = (cgetcap(buf, t->name, ':') != NULL);
			break;
		}
	}

	/* error if dialout is set and no device specified */
	if (DO && DV == 0)
		errx(1, "no device specified for %s in %s", host, capfiles[0]);

	/* error if on call-unit but no phone number */
	if (DU && PN == 0)
		errx(1, "missing phone number for %s in %s", host, capfiles[0]);
}
