#!/bin/sh
#	BSDI Dialout.login,v 2.3 1995/10/18 08:31:35 prb Exp
PATH=/sbin:/usr/sbin:/bin:/usr/bin
LINKOPTS=
DEBUGFILE=/var/log/ppp.debug

while [ $# -gt 0 ] ; do
	case $1 in
	-debug)	shift; exec >> $DEBUGFILE 2>&1 ;;
	-trace)	shift; LINKOPTS="$LINKOPTS debug" ;;
	+trace)	shift; LINKOPTS="$LINKOPTS -debug" ;;
        --)	shift; break ;;
        -*|+*)	shift ;;
        *)	break ;;
        esac
done

echo $(date): $0 $*

SYSTEM=$1
INTERFACE=$2

if [ ! X"$LINKOPTS" = X ] ; then
	ifconfig $INTERFACE $LINKOPTS
fi


LOCAL=$(hostname)
REMOTE=

if [ -r /etc/netscripts/addr-map ] ; then
	REMOTE=$(awk -v S=$SYSTEM '$1 == S { $1 = "" ; print ; exit 0; }' \
		< /etc/netscripts/addr-map)
	if [ X"$REMOTE" = X ] ; then
		case $INTERFACE in
		ppp*) exit 0 ;;
		esac
		exit 1
	fi
	eval set - $REMOTE
	REMOTE=$1
	shift
	if [ $REMOTE = DNS ] ; then
	    REMOTE=$(/usr/libexec/ppputil $(echo $SYSTEM | sed -e 's/.//'))
	    if [ -z $REMOTE ] ; then
		echo "Failed to find IP address for $SYSTEM" >&2
		exit 1
	    fi
	fi
	route delete $REMOTE
	echo ifconfig $INTERFACE inet $LOCAL $REMOTE $*
	ifconfig $INTERFACE inet $LOCAL $REMOTE $* && exit 0
fi
case $INTERFACE in
ppp*) exit 0 ;;
esac
exit 1
