/*	BSDI ppcbsdi-nat.c,v 1.1 1995/12/18 20:54:18 donn Exp	*/

/*
 * GDB support code for BSD/386.
 */

#include <sys/param.h>
#include <sys/ptrace.h>
#include <sys/user.h>
#include <machine/frame.h>

#include "defs.h"
#include "inferior.h"

static int reg_map[NUM_REGS];
static int reg_map_valid;

static void
build_reg_map()
{
	struct exception_frame *ef = (struct exception_frame *)(UPAGES*NBPG)-1;
	struct pcb *pcb = 0;
	int i;

	reg_map[PC_REGNUM] = (int)&ef->ef_srr0;
	reg_map[PS_REGNUM] = (int)&ef->ef_srr1;
	reg_map[CR_REGNUM] = (int)&ef->ef_cr;
	reg_map[LR_REGNUM] = (int)&ef->ef_lr;
	reg_map[CTR_REGNUM] = (int)&ef->ef_ctr;
	reg_map[XER_REGNUM] = (int)&ef->ef_xer;
	reg_map[MQ_REGNUM] = (int)&pcb->pcb_fpscr;	/* XXX */

	for (i = 0; i < 32; ++i)
		reg_map[GP0_REGNUM + i] = (int)&ef->ef_gpr[i];

	for (i = 0; i < 32; ++i)
		reg_map[FP0_REGNUM + i] = (int)&pcb->pcb_fpr[i];

	reg_map_valid = 1;
}

void
fetch_inferior_registers(int regno)
{
	int i, j;

	if (!reg_map_valid)
		build_reg_map();

	if (regno >= 0) {
		for (j = 0; j < REGISTER_RAW_SIZE(regno); j += sizeof (int))
			*(int *)&registers[REGISTER_BYTE(regno) + j] =
			    ptrace(PT_READ_U, inferior_pid,
			    (caddr_t)reg_map[regno] + j, 0);
		register_valid[regno] = 1;
		return;
	}

	for (i = 0; i < NUM_REGS; ++i)
		for (j = 0; j < REGISTER_RAW_SIZE(i); j += sizeof (int))
			*(int *)&registers[REGISTER_BYTE(i) + j] =
			    ptrace(PT_READ_U, inferior_pid,
			    (caddr_t)reg_map[i] + j, 0);

	registers_fetched();
}

void
store_inferior_registers(int regno)
{
	int i, j;

	if (!reg_map_valid)
		build_reg_map();

	if (regno >= 0) {
		for (j = 0; j < REGISTER_RAW_SIZE(regno); j += sizeof (int))
			ptrace(PT_WRITE_U, inferior_pid,
			    (caddr_t)reg_map[regno] + j,
			    *(int *)&registers[REGISTER_BYTE(regno) + j]);
		register_valid[regno] = 1;
		return;
	}

	for (i = 0; i < NUM_REGS; ++i)
		for (j = 0; j < REGISTER_RAW_SIZE(i); j += sizeof (int))
			ptrace(PT_WRITE_U, inferior_pid,
			    (caddr_t)reg_map[i] + j,
			    *(int *)&registers[REGISTER_BYTE(i) + j]);
}

void
fetch_core_registers(char *upage, unsigned size, int which, unsigned reg_addr)
{
	int i, j;

	if (which)
		return;

	if (!reg_map_valid)
		build_reg_map();

	for (i = 0; i < NUM_REGS; ++i)
		for (j = 0; j < REGISTER_RAW_SIZE(i); j += sizeof (int))
			*(int *)&registers[REGISTER_BYTE(i) + j] =
			    upage[reg_map[i] + j];
}

/*
 * Function version of FRAME_FIND_SAVED_REGS from rs6000.h.
 */
void
ppc_frame_find_saved_regs(struct frame_info *frame_info,
    struct frame_saved_regs *frame_saved_regs)
{
  int ii;
  CORE_ADDR frame_addr, func_start;
  struct rs6000_framedata fdata;

  /* find the start of the function and collect info about its frame. */

  func_start = get_pc_function_start (frame_info->pc) + FUNCTION_START_OFFSET;
  (void) skip_prologue (func_start, &fdata);
  memset (frame_saved_regs, '\0', sizeof *frame_saved_regs);

  /* if there were any saved registers, figure out parent's stack pointer. */
  /* the following is true only if the frame doesn't have a call to alloca(),
      FIXME. */
  if (fdata.saved_fpr == 0 && fdata.saved_gpr == 0 &&
      fdata.lr_offset == 0 && fdata.cr_offset == 0) {
    frame_addr = 0;

  } else if (frame_info->prev && frame_info->prev->frame) {
    frame_addr = frame_info->prev->frame;

  } else {
    frame_addr = read_memory_integer (frame_info->frame, 4);
  }

  /* if != -1, fdata.saved_fpr is the smallest number of saved_fpr. All
     fpr's from saved_fpr to f31 are saved. */
  if (fdata.saved_fpr >= 0) {
    int fpr_offset = frame_addr + fdata.fpr_offset;
    for (ii = fdata.saved_fpr; ii < 32; ii++) {
      frame_saved_regs->regs [FP0_REGNUM + ii] = fpr_offset;
      fpr_offset += 8;
    }
  }

  /* if != -1, fdata.saved_gpr is the smallest number of saved_gpr. All
     gpr's from saved_gpr to r31 are saved. */
  if (fdata.saved_gpr >= 0) {
    int gpr_offset = frame_addr + fdata.gpr_offset;
    for (ii = fdata.saved_gpr; ii < 32; ii++) {
      frame_saved_regs->regs [ii] = gpr_offset;
      gpr_offset += 4;
    }
  }

  /* If != 0, fdata.cr_offset is the offset from the frame that holds
     the CR */
  if (fdata.cr_offset != 0) {
    frame_saved_regs->regs [CR_REGNUM] = frame_addr + fdata.cr_offset;
  }

  /* If != 0, fdata.cr_offset is the offset from the frame that holds
     the LR */
  if (fdata.lr_offset != 0) {
    frame_saved_regs->regs [LR_REGNUM] = frame_addr + fdata.lr_offset;
  }
}
