/*	BSDI tm-bsdi.h,v 1.1 1995/12/18 20:54:23 donn Exp	*/

/* Macro definitions for Power PC running BSD/OS.
   Copyright 1995 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Cheerfully stolen from tm-ppc-eabi.h */

#ifndef TM_PPC_BSDI_H
#define TM_PPC_BSDI_H

#include "config/tm-bsdi.h"

/* Use generic RS6000 definitions. */
#include "rs6000/tm-rs6000.h"

#undef	DEFAULT_LR_SAVE
#define	DEFAULT_LR_SAVE 4	/* eabi saves LR at 4 off of SP */

#define GDB_TARGET_POWERPC

#undef PC_LOAD_SEGMENT
#undef PROCESS_LINENUMBER_HOOK
#undef CHILD_SPECIAL_WAITSTATUS
#undef CONVERT_FROM_FUNC_PTR_ADDR
#undef NO_SINGLE_STEP

#undef TEXT_SEGMENT_BASE
#define TEXT_SEGMENT_BASE	0x00010000

#undef STACK_END_ADDR
#define	STACK_END_ADDR		0xe0000000

#ifdef KERNELDEBUG

/* XXX NEEDS WORK!!! */

#define	MEM_DEVICE			2

extern int kernel_debugging;
extern int inside_kernel();

#undef FRAME_CHAIN
#define FRAME_CHAIN(thisframe) \
	(!kernel_debugging || inside_kernel((thisframe)->pc) ? \
	    rs6000_frame_chain(thisframe) : 0)

extern int kernel_xfer_memory();
#define	KERNEL_XFER_MEMORY		1

#undef FRAME_SAVED_PC
struct frame_info;
extern CORE_ADDR kernel_translate_saved_pc PARAMS((struct frame_info *));
#define	FRAME_SAVED_PC(FRAME) \
	(kernel_debugging ? \
	    kernel_translate_saved_pc(FRAME) : frame_saved_pc(FRAME))

#undef FRAME_FIND_SAVED_REGS
struct frame_saved_regs;
extern void kernel_frame_find_saved_regs PARAMS((struct frame_info *,
    struct frame_saved_regs *));
extern void ppc_frame_find_saved_regs PARAMS((struct frame_info *,
    struct frame_saved_regs *));
#define	FRAME_FIND_SAVED_REGS(fi, fregs) \
{ \
	if (kernel_debugging) \
		kernel_frame_find_saved_regs((fi), &(fregs)); \
	else \
		ppc_frame_find_saved_regs((fi), &(fregs)); \
}

#endif

#undef SIG_FRAME_PC_OFFSET
#define	SIG_FRAME_PC_OFFSET	36
#undef SIG_FRAME_FP_OFFSET
#define	SIG_FRAME_FP_OFFSET	24

#endif /* TM_PPC_BSDI_H */
