/*	BSDI tm-bsdi.h,v 1.2 1995/11/28 19:16:24 donn Exp	*/

#define	START_INFERIOR_TRAPS_EXPECTED	2

#include "config/tm-bsdi.h"
#include "config/i386/tm-i386v.h"

#undef	FRAME_NUM_ARGS
#define	FRAME_NUM_ARGS(val, fi)		(val = -1)

#undef	COFF_NO_LONG_FILE_NAMES
#define	NAMES_HAVE_UNDERSCORE		1
#define	NEED_TEXT_START_END		1

#if 0
extern int stop_stack_dummy;
extern void
i386_pop_dummy_frame PARAMS ((void));
#undef POP_FRAME
#define	POP_FRAME \
	(stop_stack_dummy ? i386_pop_dummy_frame() : i386_pop_frame())
#endif

#define	nounderscore			1	/* for cplus_dem.c */

#ifdef KERNELDEBUG
#define	MEM_DEVICE			2

extern int kernel_debugging;
extern int inside_kernel();

#undef FRAME_CHAIN
#define FRAME_CHAIN(thisframe) \
	((kernel_debugging ? \
	    inside_kernel((thisframe)->pc) : \
	    thisframe->signal_handler_caller ? \
		thisframe->frame : \
		!inside_entry_file((thisframe)->pc)) \
	? \
	    read_memory_integer ((thisframe)->frame, 4) : \
	    0)

#undef FRAME_CHAIN_VALID
#define FRAME_CHAIN_VALID(chain, thisframe) \
	(chain != 0 && \
	    (kernel_debugging ? \
		 inside_kernstack(chain) : \
	    !inside_entry_file(FRAME_SAVED_PC(thisframe))))

extern int kernel_xfer_memory();
#define	KERNEL_XFER_MEMORY		1

#undef FRAME_SAVED_PC
struct frame_info;
extern CORE_ADDR kernel_translate_saved_pc PARAMS((struct frame_info *));
#define	FRAME_SAVED_PC(FRAME) \
	(kernel_debugging ? \
	    kernel_translate_saved_pc(FRAME) : \
	(FRAME)->signal_handler_caller ? \
	    sigtramp_saved_pc(FRAME) : \
	read_memory_integer((FRAME)->frame + 4, 4))

#undef FRAME_FIND_SAVED_REGS
extern void kernel_frame_find_saved_regs PARAMS((struct frame_info *,
    struct frame_saved_regs *));
#define	FRAME_FIND_SAVED_REGS(fi, fregs) \
	{ \
		if (kernel_debugging) \
			kernel_frame_find_saved_regs((fi), &(fregs)); \
		else \
			i386_frame_find_saved_regs((fi), &(fregs)); \
	}

#endif

/*
 * We use absolute numbers to facilitate cross-debugging.
 */
#undef SIGTRAMP_START
#define	SIGTRAMP_START	0xefbfdfd8
#undef SIGTRAMP_END
#define	SIGTRAMP_END	0xefbfdff0

#define	SIGCONTEXT_PC_OFFSET	20
