;; Machine description for IBM RISC System 6000 (POWER) for GNU C compiler
;; Copyright (C) 1990, 91, 92, 93, 94, 1995 Free Software Foundation, Inc.
;; Contributed by Richard Kenner (kenner@vlsi1.ultra.nyu.edu)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;; Define an insn type attribute.  This is used in function unit delay
;; computations.
(define_attr "type" "integer,load,fpload,imul,idiv,branch,compare,delayed_compare,fpcompare,mtjmpr,fp,dmul,sdiv,ddiv,ssqrt,dsqrt,jmpreg"
  (const_string "integer"))

;; Length (in bytes).
(define_attr "length" ""
  (if_then_else (eq_attr "type" "branch")
		(if_then_else (and (ge (minus (pc) (match_dup 0))
				       (const_int -32768))
				   (lt (minus (pc) (match_dup 0))
				       (const_int 32767)))
			      (const_int 8)
			      (const_int 12))
		(const_int 4)))

;; Processor type -- this attribute must exactly match the processor_type
;; enumeration in rs6000.h.

(define_attr "cpu" "rios1,rios2,ppc403,ppc601,ppc603,ppc604,ppc620"
  (const (symbol_ref "rs6000_cpu_attr")))

; (define_function_unit NAME MULTIPLICITY SIMULTANEITY
;			TEST READY-DELAY ISSUE-DELAY [CONFLICT-LIST])

; Load/Store Unit -- POWER/2 and pure PowerPC only
; (POWER and 601 use Integer Unit)
(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "load")
       (eq_attr "cpu" "rios2,ppc603,ppc604,ppc620"))
  2 0)

(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "rios2,ppc603,ppc604,ppc620"))
  2 0)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "load")
       (eq_attr "cpu" "rios1,ppc403,ppc601"))
  2 0)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "rios1,ppc601"))
  3 0)

; Integer Unit (RIOS1, PPC601, PPC603)
; Trivial operations take one cycle which need not be listed here.
(define_function_unit "iu" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "rios1"))
  3 3)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc403"))
  4 4)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc601,ppc603"))
  5 5)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rios1"))
  19 19)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc403"))
  33 33)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc601"))
  36 36)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc603"))
  37 36)

; RIOS2 has two integer units: a primary one which can perform all
; operations and a secondary one which is fed in lock step with the first
; and can perform "simple" integer operations.
(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "rios2"))
  1 0
  [(eq_attr "type" "imul,idiv")])

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "rios2"))
  2 2
  [(eq_attr "type" "integer")])

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rios2"))
  13 13
  [(eq_attr "type" "integer")])

; PPC604 has three integer units: one primary and two secondary.
(define_function_unit "iu3" 3 0
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "ppc604,ppc620"))
  1 0
  [(eq_attr "type" "imul,idiv")])

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc604,ppc620"))
  4 2
  [(eq_attr "type" "integer")])

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc604,ppc620"))
  20 19
  [(eq_attr "type" "integer")])

; Branch Processing Unit
(define_function_unit "bpu" 1 0
  (eq_attr "type" "compare")
  4 0)

(define_function_unit "bpu" 1 0
  (eq_attr "type" "delayed_compare")
  5 0)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "rios1,rios2"))
  8 0)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc601,ppc603,ppc604,ppc620"))
  4 0)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "rios1,rios2"))
  5 0)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "ppc403,ppc601,ppc603,ppc604,ppc620"))
  4 0)

; Floating Point Unit (RIOS1, PPC601, PPC603, PPC604).
(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp,dmul")
       (eq_attr "cpu" "rios1"))
  2 0)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppc601"))
  4 0)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppc603,ppc604,ppc620"))
  3 0)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc601"))
  5 5)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc603"))
  4 2)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc604,ppc620"))
  3 0)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv,ddiv")
       (eq_attr "cpu" "rios1"))
  19 19)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc601"))
  17 17)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc603,ppc604,ppc620"))
  18 18)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc601,ppc604,ppc620"))
  31 31)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc603"))
  33 33)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ssqrt")
       (eq_attr "cpu" "ppc620"))
  31 31)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dsqrt")
       (eq_attr "cpu" "ppc620"))
  31 31)

; RIOS2 has two symmetric FPUs.
(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "rios2"))
  2 0)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "rios2"))
  2 0)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "sdiv,ddiv")
       (eq_attr "cpu" "rios2"))
  17 17)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "ssqrt,dsqrt")
       (eq_attr "cpu" "rios2"))
  26 26)

;; Start with fixed-point load and store insns.  Here we put only the more
;; complex forms.  Basic data transfer is done later.

(define_expand "zero_extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lbz%U1%X1 %0,%1
   rldicl %0,%1,0,56"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,56"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,56"
  [(set_attr "type" "compare")])

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lhz%U1%X1 %0,%1
   rldicl %0,%1,0,48"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,48"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,48"
  [(set_attr "type" "compare")])

(define_expand "extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lha%U1%X1 %0,%1
   extsh %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsh. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsh. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:SI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwz%U1%X1 %0,%1
   rldicl %0,%1,0,32"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,32"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,32"
  [(set_attr "type" "compare")])

(define_expand "extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:SI 1 "lwa_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwa%U1%X1 %0,%1
   extsw %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsw. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsw. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xff"
  [(set_attr "type" "compare")])

(define_expand "extendqisi2"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqisi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqisi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqisi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqisi2_ppc"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  "TARGET_POWERPC"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_dup 1)))]
  "TARGET_POWERPC"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "extendqisi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqisi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "gpc_reg_operand" "")
	(zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:HI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(zero_extend:HI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xff"
  [(set_attr "type" "compare")])

(define_expand "extendqihi2"
  [(use (match_operand:HI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqihi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqihi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqihi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqihi2_ppc"
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r"))]
  "TARGET_POWERPC"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(sign_extend:HI (match_dup 1)))]
  "TARGET_POWERPC"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "extendqihi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:HI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqihi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:HI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lhz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xffff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xffff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xffff"
  [(set_attr "type" "compare")])

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lha%U1%X1 %0,%1
   {exts|extsh} %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{exts.|extsh.} %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_dup 1)))]
  ""
  "{exts.|extsh.} %0,%1"
  [(set_attr "type" "compare")])

;; Fixed-point arithmetic insns.

;; Discourage ai/addic because of carry but provide it in an alternative
;; allowing register zero as source.
(define_insn "addsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,?r,r")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,b,r,b")
		 (match_operand:SI 2 "add_operand" "r,I,I,J")))]
  ""
  "@
   {cax|add} %0,%1,%2
   {cal %0,%2(%1)|addi %0,%1,%2}
   {ai|addic} %0,%1,%2
   {cau|addis} %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {cax.|add.} %3,%1,%2
   {ai.|addic.} %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {cax.|add.} %0,%1,%2
   {ai.|addic.} %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "non_add_cint_operand" "")))]
  ""
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 4)))]
"
{
  int low = INTVAL (operands[2]) & 0xffff;
  int high = (unsigned) INTVAL (operands[2]) >> 16;

  if (low & 0x8000)
    high++, low |= 0xffff0000;

  operands[3] = gen_rtx (CONST_INT, VOIDmode, high << 16);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, low);
}")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "nor %0,%1,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "nor. %2,%1,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_dup 1)))]
  ""
  "nor. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "rI")
		  (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "! TARGET_POWERPC"
  "{sf%I1|subf%I1c} %0,%2,%1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "r,I")
		  (match_operand:SI 2 "gpc_reg_operand" "r,r")))]
  "TARGET_POWERPC"
  "@
   subf %0,%2,%1
   subfic %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWERPC"
  "{sf.|subfc.} %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWERPC"
  "subf. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWERPC"
  "{sf.|subfc.} %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC"
  "subf. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_expand "subsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "")
		  (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_addsi3 (operands[0], operands[1],
			     negate_rtx (SImode, operands[2])));
      DONE;
    }
}")

;; For SMIN, SMAX, UMIN, and UMAX, we use DEFINE_EXPAND's that involve a doz[i]
;; instruction and some auxiliary computations.  Then we just have a single
;; DEFINE_INSN for doz[i] and the define_splits to make them if made by
;; combine.

(define_expand "sminsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER"
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smin:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 3)))]
  "")

(define_expand "smaxsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER"
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smax:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (plus:SI (match_dup 3) (match_dup 1)))]
  "")

(define_expand "uminsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER"
  "
{
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_expand "umaxsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER"
  "
{
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2. %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "doz%I2. %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; We don't need abs with condition code because such comparisons should
;; never be done.
(define_expand "abssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "")))]
  ""
  "
{
  if (!TARGET_POWER)
    {
      emit_insn (gen_abssi2_nopower (operands[0], operands[1]));
      DONE;
    }
}")

(define_insn "abssi2_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "abs %0,%1")

(define_insn "abssi2_nopower"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER"
  "*
{
  return (TARGET_POWERPC)
    ? \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;subf %0,%2,%0\"
    : \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;{sf|subfc} %0,%2,%0\";
}"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER && reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "nabs %0,%1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER"
  "*
{
  return (TARGET_POWERPC)
    ? \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;subf %0,%0,%2\"
    : \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;{sf|subfc} %0,%0,%2\";
}"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER && reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 0) (match_dup 2)))]
  "")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "neg. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_dup 1)))]
  ""
  "neg. %0,%1"
  [(set_attr "type" "compare")])

(define_insn "ffssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(ffs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1\;and %0,%0,%1\;{cntlz|cntlzw} %0,%0\;{sfi|subfic} %0,%0,32"
  [(set_attr "length" "16")])

(define_expand "mulsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_short_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_mulsi3_mq (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_mulsi3_no_mq (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "mulsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
   (clobber (match_scratch:SI 3 "=q,q"))]
  "TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn "mulsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))]
  "! TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))
   (clobber (match_scratch:SI 4 "=q"))]
  "TARGET_POWER"
  "{muls.|mullw.} %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{muls.|mullw.} %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q"))]
  "TARGET_POWER"
  "{muls.|mullw.} %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mult:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{muls.|mullw.} %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; Operand 1 is divided by operand 2; quotient goes to operand
;; 0 and remainder to operand 3.
;; ??? At some point, see what, if anything, we can do about if (x % y == 0).

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (div:SI (match_operand:SI 1 "gpc_reg_operand" "")
			   (match_operand:SI 2 "gpc_reg_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (mod:SI (match_dup 1) (match_dup 2)))])]
  "TARGET_POWER || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
      emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
      emit_insn (gen_divss_call ());
      emit_move_insn (operands[0], gen_rtx (REG, SImode, 3));
      emit_move_insn (operands[3], gen_rtx (REG, SImode, 4));
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (set (match_operand:SI 3 "gpc_reg_operand" "=q")
	(mod:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "divs %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "divw %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_expand "udivsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
                 (match_operand:SI 2 "gpc_reg_operand" "")))]
  "TARGET_POWERPC || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
      emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
      emit_insn (gen_quous_call ());
      emit_move_insn (operands[0], gen_rtx (REG, SImode, 3));
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                 (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "divwu %0,%1,%2"
  [(set_attr "type" "idiv")])

;; For powers of two we can do srai/aze for divide and then adjust for
;; modulus.  If it isn't a power of two, FAIL on POWER so divmodsi4 will be
;; used; for PowerPC, force operands into register and do a normal divide;
;; for AIX common-mode, use quoss call on register operands.
(define_expand "divsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && exact_log2 (INTVAL (operands[2])) >= 0)
    ;
  else if (TARGET_POWER && ! TARGET_POWERPC)
    FAIL;
  else
    operands[2] = force_reg (SImode, operands[2]);

  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
      emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
      emit_insn (gen_quoss_call ());
      emit_move_insn (operands[0], gen_rtx (REG, SImode, 3));
      DONE;
    }
}")

(define_expand "modsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  int i = exact_log2 (INTVAL (operands[2]));
  rtx temp1;
  rtx temp2;

  if (GET_CODE (operands[2]) != CONST_INT || i < 0)
    FAIL;

  temp1 = gen_reg_rtx (SImode);
  temp2 = gen_reg_rtx (SImode);

  emit_insn (gen_divsi3 (temp1, operands[1], operands[2]));
  emit_insn (gen_ashlsi3 (temp2, temp1, GEN_INT (i)));
  emit_insn (gen_subsi3 (operands[0], operands[1], temp2));
  DONE;
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "const_int_operand" "N")))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %0,%1,%p2\;{aze|addze} %0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %3,%1,%p2\;{aze.|addze.} %3,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_dup 1) (match_dup 2)))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %0,%1,%p2\;{aze.|addze.} %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(udiv:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 32))
		  (zero_extend:DI (match_operand:SI 4 "register_operand" "2")))
	 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (set (match_operand:SI 2 "register_operand" "=*q")
	(umod:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_dup 1)) (const_int 32))
		  (zero_extend:DI (match_dup 4)))
	 (match_dup 3)))]
  "TARGET_POWER"
  "div %0,%1,%3"
  [(set_attr "type" "idiv")])

;; To do unsigned divide we handle the cases of the divisor looking like a
;; negative number.  If it is a constant that is less than 2**31, we don't
;; have to worry about the branches.  So make a few subroutines here.
;;
;; First comes the normal case.
(define_expand "udivmodsi4_normal"
  [(set (match_dup 4) (const_int 0))
   (parallel [(set (match_operand:SI 0 "" "")
		   (udiv:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_operand:SI 1 "" "")))
			    (match_operand:SI 2 "" "")))
	      (set (match_operand:SI 3 "" "")
		   (umod:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_dup 1)))
			    (match_dup 2)))])]
  "TARGET_POWER"
  "
{ operands[4] = gen_reg_rtx (SImode); }")

;; This handles the branches.
(define_expand "udivmodsi4_tests"
  [(set (match_operand:SI 0 "" "") (const_int 0))
   (set (match_operand:SI 3 "" "") (match_operand:SI 1 "" ""))
   (set (match_dup 5) (compare:CCUNS (match_dup 1) (match_operand:SI 2 "" "")))
   (set (pc) (if_then_else (ltu (match_dup 5) (const_int 0))
			   (label_ref (match_operand:SI 4 "" "")) (pc)))
   (set (match_dup 0) (const_int 1))
   (set (match_dup 3) (minus:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 6) (compare:CC (match_dup 2) (const_int 0)))
   (set (pc) (if_then_else (lt (match_dup 6) (const_int 0))
			   (label_ref (match_dup 4)) (pc)))]
  "TARGET_POWER"
  "
{ operands[5] = gen_reg_rtx (CCUNSmode);
  operands[6] = gen_reg_rtx (CCmode);
}")

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "reg_or_cint_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (umod:SI (match_dup 1) (match_dup 2)))])]
  ""
  "
{
  rtx label = 0;

  if (! TARGET_POWER)
    if (! TARGET_POWERPC)
      {
	emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
	emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
	emit_insn (gen_divus_call ());
	emit_move_insn (operands[0], gen_rtx (REG, SImode, 3));
	emit_move_insn (operands[3], gen_rtx (REG, SImode, 4));
	DONE;
      }
    else
      FAIL;

  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) < 0)
    {
      operands[2] = force_reg (SImode, operands[2]);
      label = gen_label_rtx ();
      emit (gen_udivmodsi4_tests (operands[0], operands[1], operands[2],
				  operands[3], label));
    }
  else
    operands[2] = force_reg (SImode, operands[2]);

  emit (gen_udivmodsi4_normal (operands[0], operands[1], operands[2],
			       operands[3]));
  if (label)
    emit_label (label);

  DONE;
}")

;; AIX architecture-independent common-mode multiply (DImode),
;; divide/modulus, and quotient subroutine calls.  Input operands in R3 and
;; R4; results in R3 and sometimes R4; link register always clobbered by bla
;; instruction; R0 sometimes clobbered; also, MQ sometimes clobbered but
;; assumed unused if generating common-mode, so ignore.
(define_insn "mulh_call"
  [(set (reg:SI 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (reg:SI 3))
			       (sign_extend:DI (reg:SI 4)))
		      (const_int 32))))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mulh")

(define_insn "mull_call"
  [(set (reg:DI 3)
	(mult:DI (sign_extend:DI (reg:SI 3))
		 (sign_extend:DI (reg:SI 4))))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mull")

(define_insn "divss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(mod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divss")

(define_insn "divus_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(umod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divus")

(define_insn "quoss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quoss")

(define_insn "quous_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quous")

(define_insn "andsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
		(match_operand:SI 2 "and_operand" "?r,L,K,J")))
   (clobber (match_scratch:CC 3 "=X,X,x,x"))]
  ""
  "@
   and %0,%1,%2
   {rlinm|rlwinm} %0,%1,0,%m2,%M2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))]
  ""
  "@
   and. %3,%1,%2
   {andil.|andi.} %3,%1,%b2
   {andiu.|andis.} %3,%1,%u2
   {rlinm.|rlwinm.} %3,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   and. %0,%1,%2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2
   {rlinm.|rlwinm.} %0,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

;; Take a AND with a constant that cannot be done in a single insn and try to
;; split it into two insns.  This does not verify that the insns are valid
;; since this need not be done as combine will do it.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_and_cint_operand" "")))]
  ""
  [(set (match_dup 0) (and:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (and:SI (match_dup 0) (match_dup 4)))]
  "
{
  int maskval = INTVAL (operands[2]);
  int i, transitions, last_bit_value;
  int orig = maskval, first_c = maskval, second_c;

  /* We know that MASKVAL must have more than 2 bit-transitions.  Start at
     the low-order bit and count for the third transition.  When we get there,
     make a first mask that has everything to the left of that position
     a one.  Then make the second mask to turn off whatever else is needed.  */

  for (i = 1, transitions = 0, last_bit_value = maskval & 1; i < 32; i++)
    {
      if (((maskval >>= 1) & 1) != last_bit_value)
	last_bit_value ^= 1, transitions++;

      if (transitions > 2)
	{
	  first_c |= (~0) << i;
	  break;
	}
    }

  second_c = orig | ~ first_c;

  operands[3] = gen_rtx (CONST_INT, VOIDmode, first_c);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, second_c);
}")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   or %0,%1,%2
   {oril|ori} %0,%1,%b2
   {oriu|oris} %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "or. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (match_dup 1) (match_dup 2)))]
  ""
  "or. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an IOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (ior:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (ior:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[2]) & 0xffff0000);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[2]) & 0xffff);
}")

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   xor %0,%1,%2
   {xoril|xori} %0,%1,%b2
   {xoriu|xoris} %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "xor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(xor:SI (match_dup 1) (match_dup 2)))]
  ""
  "xor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an XOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (xor:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (xor:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[2]) & 0xffff0000);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[2]) & 0xffff);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))))]
   ""
   "eqv %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
   ""
   "eqv. %3,%1,%2"
   [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_dup 1) (match_dup 2))))]
   ""
   "eqv. %0,%1,%2"
   [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "andc %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "andc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "andc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "orc %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "orc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "orc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nand %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nand. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nand. %0,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nor %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; maskir insn.  We need four forms because things might be in arbitrary
;; orders.  Don't define forms that only set CR fields because these
;; would modify an input register.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_dup 2)
			(match_operand:SI 3 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_dup 2))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			(match_operand:SI 3 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_dup 2)
			 (match_operand:SI 3 "gpc_reg_operand" "r")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_dup 2)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (match_operand:SI 3 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

;; Rotate and shift insns, in all their variants.  These support shifts,
;; field inserts and extracts, and various combinations thereof.
(define_expand "insv"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "*
{
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, 32 - start - size);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashift:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		   (match_operand:SI 4 "const_int_operand" "i")))]
  ""
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, (shift - start - size) & 31);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  ""
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, (32 - shift - start - size) & 31);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(lshiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  ""
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, (32 - shift - start - size) & 31);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(zero_extract:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 4 "const_int_operand" "i")
			 (match_operand:SI 5 "const_int_operand" "i")))]
  "INTVAL (operands[4]) >= INTVAL (operands[1])"
  "*
{
  int extract_start = INTVAL (operands[5]) & 31;
  int extract_size = INTVAL (operands[4]) & 31;
  int insert_start = INTVAL (operands[2]) & 31;
  int insert_size = INTVAL (operands[1]) & 31;

/* Align extract field with insert field */
  operands[5] = gen_rtx (CONST_INT, VOIDmode,
			 (extract_start + extract_size - insert_start - insert_size) & 31);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, insert_start + insert_size - 1);
  return \"{rlimi|rlwimi} %0,%3,%5,%h2,%h1\";
}")

(define_expand "extzv"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"{rlinm|rlwinm} %0,%1,%3,%s2,31\";
}")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  /* If the bitfield being tested fits in the upper or lower half of a
     word, it is possible to use andiu. or andil. to test it.  This is
     useful because the condition register set-use delay is smaller for
     andi[ul]. than for rlinm.  This doesn't work when the starting bit
     position is 0 because the LT and GT bits may be set wrong.  */

  if ((start > 0 && start + size <= 16) || start >= 16)
    {
      operands[3] = gen_rtx (CONST_INT, VOIDmode,
			     ((1 << (16 - (start & 15)))
			      - (1 << (16 - (start & 15) - size))));
      if (start < 16)
	return \"{andiu.|andis.} %4,%1,%3\";
      else
	return \"{andil.|andi.} %4,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"{rlinm.|rlwinm.} %4,%1,%3,%s2,31\";
}"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start >= 16 && start + size == 32)
    {
      operands[3] = gen_rtx (CONST_INT, VOIDmode, (1 << (32 - start)) - 1);
      return \"{andil.|andi.} %0,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"{rlinm.|rlwinm.} %0,%1,%3,%s2,31\";
}"
  [(set_attr "type" "delayed_compare")])

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffffffff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffffffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_dup 1) (match_dup 2)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffffffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		(match_operand:SI 3 "mask_operand" "L")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %4,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffff"
  [(set_attr "type" "delayed_compare")])

;; Note that we use "sle." instead of "sl." so that we can set
;; SHIFT_COUNT_TRUNCATED.

(define_expand "ashlsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashlsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashlsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashlsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   sle %0,%1,%2
   {sli|slwi} %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn "ashlsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sl|slw}%I2 %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   sle. %3,%1,%2
   {sli.|slwi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{sl|slw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   sle. %0,%1,%2
   {sli.|slwi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{sl|slw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %4,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %0,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

;; The AIX assembler mis-handles "sri x,x,0", so write that case as
;; "sli x,x,0".
(define_expand "lshrsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_lshrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_lshrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "lshrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
  sre %0,%1,%2
  {s%A2i|s%A2wi} %0,%1,%h2")

(define_insn "lshrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sr|srw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
  sre. %3,%1,%2
  {s%A2i.|s%A2wi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{sr|srw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
  sre. %0,%1,%2
  {s%A2i.|s%A2wi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{sr|srw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%s2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %4,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %0,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "{rlinm|rlwinm} %0,%1,%s2,0xff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "{rlinm.|rlwinm.} %3,%1,%s2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "{rlinm.|rlwinm.} %0,%1,%s2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "{rlinm|rlwinm} %0,%1,%s2,0xffff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "{rlinm.|rlwinm.} %3,%1,%s2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "{rlinm.|rlwinm.} %0,%1,%s2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(ashiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(lshiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(zero_extract:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (const_int 1)
			 (const_int 0)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   srea %0,%1,%2
   {srai|srawi} %0,%1,%h2")

(define_insn "ashrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sra|sraw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   srea. %3,%1,%2
   {srai.|srawi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{sra|sraw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   srea. %0,%1,%2
   {srai.|srawi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{sra|sraw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

;; Floating-point insns, excluding normal data motion.
;;
;; PowerPC has a full set of single-precision floating point instructions.
;;
;; For the POWER architecture, we pretend that we have both SFmode and
;; DFmode insns, while, in fact, all fp insns are actually done in double.
;; The only conversions we will do will be when storing to memory.  In that
;; case, we will use the "frsp" instruction before storing.
;;
;; Note that when we store into a single-precision memory location, we need to
;; use the frsp insn first.  If the register being stored isn't dead, we
;; need a scratch register for the frsp.  But this is difficult when the store
;; is done by reload.  It is not incorrect to do the frsp on the register in
;; this case, we just lose precision that we would have otherwise gotten but
;; is not guaranteed.  Perhaps this should be tightened up at some point.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float_extend:DF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"fmr %0,%1\";
}"
  [(set_attr "type" "fp")])

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(float_truncate:SF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_insn "aux_truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(unspec:SF [(match_operand:SF 1 "gpc_reg_operand" "f")] 0))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (abs:SF (match_operand:SF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_expand "addsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fadds %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "subsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		  (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fsubs %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "mulsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fmuls %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "divsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "")
		(match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fdivs %0,%1,%2"
  [(set_attr "type" "sdiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "sdiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fnmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fnmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_expand "sqrtsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GPOPT && TARGET_HARD_FLOAT"
  "fsqrts %0,%1"
  [(set_attr "type" "ssqrt")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWER2 && TARGET_HARD_FLOAT"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; For MIN, MAX, and conditional move, we use DEFINE_EXPAND's that involve a
;; fsel instruction and some auxiliary computations.  Then we just have a
;; single DEFINE_INSN for fsel and the define_splits to make them if made by
;; combine.
(define_expand "maxsf3"
  [(set (match_dup 3)
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		  (match_operand:SF 2 "gpc_reg_operand" "")))
   (set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (SFmode); }")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(smax:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:SF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:SF (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "minsf3"
  [(set (match_dup 3)
	(minus:SF (match_operand:SF 2 "gpc_reg_operand" "")
		  (match_operand:SF 1 "gpc_reg_operand" "")))
   (set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (SFmode); }")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(smin:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:SF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:SF (match_dup 2) (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "movsfcc"
   [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	 (if_then_else:SF (match_operand 1 "comparison_operator" "")
			  (match_operand:SF 2 "gpc_reg_operand" "f")
			  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{
  rtx temp, op0, op1;
  enum rtx_code code = GET_CODE (operands[1]);
  if (! rs6000_compare_fp_p)
    FAIL;
  switch (code)
    {
    case GE: case EQ: case NE:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      break;
    case GT:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    case LE:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      break;
    case LT:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    default:
      FAIL;
    }
  if (GET_MODE (rs6000_compare_op0) == DFmode)
    {
      temp = gen_reg_rtx (DFmode);
      emit_insn (gen_subdf3 (temp, op0, op1));
      emit_insn (gen_fseldfsf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfsf4 (operands[0], temp, operands[0], operands[3]));
	}
      if (code == NE)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfsf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  else
    {
      temp = gen_reg_rtx (SFmode);
      emit_insn (gen_subsf3 (temp, op0, op1));
      emit_insn (gen_fselsfsf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfsf4 (operands[0], temp, operands[0], operands[3]));
	}
      if (code == NE)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfsf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  DONE;
}")

(define_insn "fselsfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "fseldfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "absdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(abs:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (abs:DF (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn "adddf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "subdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		  (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "dmul")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(div:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		(match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "ddiv")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			  (match_operand:DF 2 "gpc_reg_operand" "f"))
		 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			   (match_operand:DF 2 "gpc_reg_operand" "f"))
		  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				  (match_operand:DF 2 "gpc_reg_operand" "f"))
			 (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				   (match_operand:DF 2 "gpc_reg_operand" "f"))
			  (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn "sqrtdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(sqrt:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; For MIN, MAX, and conditional move, we use DEFINE_EXPAND's that involve a
;; fsel instruction and some auxiliary computations.  Then we just have a
;; single DEFINE_INSN for fsel and the define_splits to make them if made by
;; combine.

(define_expand "maxdf3"
  [(set (match_dup 3)
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "")
		  (match_operand:DF 2 "gpc_reg_operand" "")))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (DFmode); }")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(smax:DF (match_operand:DF 1 "gpc_reg_operand" "")
		 (match_operand:DF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:DF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:DF (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "mindf3"
  [(set (match_dup 3)
	(minus:DF (match_operand:DF 2 "gpc_reg_operand" "")
		  (match_operand:DF 1 "gpc_reg_operand" "")))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (DFmode); }")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(smin:DF (match_operand:DF 1 "gpc_reg_operand" "")
		 (match_operand:DF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:DF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:DF (match_dup 2) (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "movdfcc"
   [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	 (if_then_else:DF (match_operand 1 "comparison_operator" "")
			  (match_operand:DF 2 "gpc_reg_operand" "f")
			  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{
  rtx temp, op0, op1;
  enum rtx_code code = GET_CODE (operands[1]);
  if (! rs6000_compare_fp_p)
    FAIL;
  switch (code)
    {
    case GE: case EQ: case NE:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      break;
    case GT:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    case LE:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      break;
    case LT:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    default:
      FAIL;
    }
  if (GET_MODE (rs6000_compare_op0) == DFmode)
    {
      temp = gen_reg_rtx (DFmode);
      emit_insn (gen_subdf3 (temp, op0, op1));
      emit_insn (gen_fseldfdf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfdf4 (operands[0], temp, operands[0], operands[3]));
	}
      if (code == NE)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfdf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  else
    {
      temp = gen_reg_rtx (SFmode);
      emit_insn (gen_subsf3 (temp, op0, op1));
      emit_insn (gen_fselsfdf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfdf4 (operands[0], temp, operands[0], operands[3]));
	}
      if (code == NE)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfdf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  DONE;
}")

(define_insn "fseldfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "fselsfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

;; Conversions to and from floating-point.
(define_expand "floatsidf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "")))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "
{
  if (operands[0])
    {				/* prevent unused warning messages */
      rtx high   = force_reg (SImode, GEN_INT (0x43300000));
      rtx low    = gen_reg_rtx (SImode);
      rtx df     = gen_reg_rtx (DFmode);
      rtx adjust = force_reg (DFmode, rs6000_float_const (\"4503601774854144\", DFmode));

      emit_insn (gen_xorsi3 (low, operands[1], GEN_INT (0x80000000)));
      emit_insn (gen_move_to_float (df, low, high));
      emit_insn (gen_subdf3 (operands[0], df, adjust));
      DONE;
    }
}")

(define_expand "floatunssidf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "
{
  if (operands[0])
    {				/* prevent unused warning messages */
      rtx high   = force_reg (SImode, GEN_INT (0x43300000));
      rtx df     = gen_reg_rtx (DFmode);
      rtx adjust = force_reg (DFmode, rs6000_float_const (\"4503599627370496\", DFmode));

      emit_insn (gen_move_to_float (df, operands[1], high));
      emit_insn (gen_subdf3 (operands[0], df, adjust));
      DONE;
    }
}")

(define_expand "move_to_float"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unspec [(match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "gpc_reg_operand" "")
		 (match_dup 3)] 2))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "
{
  operands[3] = XEXP (rs6000_stack_temp (DFmode, 8, 1), 0);
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unspec [(match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "gpc_reg_operand" "")
		 (match_operand:SI 3 "offsettable_addr_operand" "")] 2))]
  "reload_completed"
  [(set (match_dup 4) (match_dup 1))
   (set (match_dup 5) (match_dup 2))
   (set (match_dup 0) (mem:DF (match_dup 3)))]
  "
{
  rtx word1 = gen_rtx (MEM, SImode, operands[3]);
  rtx word2 = gen_rtx (MEM, SImode, plus_constant (operands[3], 4));

  MEM_IN_STRUCT_P (word1) = 1;
  MEM_IN_STRUCT_P (word2) = 1;

  if (WORDS_BIG_ENDIAN)
    {
      operands[4] = word2;
      operands[5] = word1;
    }
  else
    {
      operands[4] = word1;
      operands[5] = word2;
    }
}")

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(unspec [(match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "gpc_reg_operand" "r")
		 (match_operand:SI 3 "offsettable_addr_operand" "p")] 2))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "#"
  [(set_attr "length" "12")])

(define_expand "fix_truncdfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  if (TARGET_POWER2 || TARGET_POWERPC)
    {
      int endian = (WORDS_BIG_ENDIAN == 0);
      rtx stack_slot = rs6000_stack_temp (DImode, 8, 1);
      rtx temp = gen_reg_rtx (DImode);

      emit_insn (gen_fpcvtsi (temp, operands[1]));
      emit_move_insn (stack_slot, temp);
      emit_move_insn (operands[0],
		      operand_subword (stack_slot, 1 - endian, 0, DImode));
      DONE;
    }
  else
    {
      emit_insn (gen_trunc_call (operands[0], operands[1],
				 gen_rtx (SYMBOL_REF, Pmode, RS6000_ITRUNC)));
      DONE;
    }
}")

(define_insn "fpcvtsi"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=f")
	(sign_extend:DI
	 (fix:SI (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT"
  "{fcirz|fctiwz} %0,%1"
  [(set_attr "type" "fp")])

(define_expand "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unsigned_fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))]
  "! TARGET_POWER2 && ! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "
{
  emit_insn (gen_trunc_call (operands[0], operands[1],
			     gen_rtx (SYMBOL_REF, Pmode, RS6000_UITRUNC)));
  DONE;
}")

(define_expand "trunc_call"
  [(parallel [(set (match_operand:SI 0 "" "")
		   (fix:SI (match_operand:DF 1 "" "")))
	      (use (match_operand:SI 2 "" ""))])]
  "TARGET_HARD_FLOAT"
  "
{
  rtx insns = gen_trunc_call_rtl (operands[0], operands[1], operands[2]);
  rtx first = XVECEXP (insns, 0, 0);
  rtx last = XVECEXP (insns, 0, XVECLEN (insns, 0) - 1);

  REG_NOTES (first) = gen_rtx (INSN_LIST, REG_LIBCALL, last,
			       REG_NOTES (first));
  REG_NOTES (last) = gen_rtx (INSN_LIST, REG_RETVAL, first, REG_NOTES (last));

  emit_insn (insns);
  DONE;
}")

(define_expand "trunc_call_rtl"
  [(set (reg:DF 33) (match_operand:DF 1 "gpc_reg_operand" ""))
   (use (reg:DF 33))
   (parallel [(set (reg:SI 3)
		   (call (mem:SI (match_operand 2 "" "")) (const_int 0)))
	      (use (const_int 0))
	      (clobber (scratch:SI))])
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(reg:SI 3))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_trunc_used = 1;
}")

(define_insn "floatdidf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float:DF (match_operand:DI 1 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "fcfid %0,%1"
  [(set_attr "type" "fp")])

(define_insn "fix_truncdfdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=f")
	(fix:DI (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "fctidz %0,%1"
  [(set_attr "type" "fp")])

;; Define the DImode operations that can be done in a small number
;; of instructions.  The & constraints are to prevent the register
;; allocator from allocating registers that overlap with the inputs
;; (for example, having an input in 7,8 and an output in 6,7).  We
;; also allow for the the output being the same as one of the inputs.

(define_expand "adddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_short_operand" "")))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC64
      && short_cint_operand (operands[2], DImode))
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,0,0")
		 (match_operand:DI 2 "reg_or_short_operand" "r,I,r,I")))]
  "TARGET_POWER && ! TARGET_POWERPC64"
  "@
   {a|addc} %L0,%L1,%L2\;{ae|adde} %0,%1,%2
   {ai|addic} %L0,%L1,%2\;{a%G2e|add%G2e} %0,%1
   {a|addc} %L0,%L1,%L2\;{ae|adde} %0,%1,%2
   {ai|addic} %L0,%L1,%2\;{a%G2e|add%G2e} %0,%1"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,0")
		 (match_operand:DI 2 "gpc_reg_operand" "r,r")))]
  "! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
  ? \"addc %L0,%L1,%L2\;adde %0,%1,%2\"
  : \"addc %0,%1,%2\;adde %L0,%L1,%L2\";
}"
  [(set_attr "length" "8")])

(define_expand "subdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "")
		  (match_operand:DI 2 "gpc_reg_operand" "")))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC64
      && short_cint_operand (operands[1], DImode))
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r,r")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "r,I,0,r,I")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r,r,0,0")))]
  "TARGET_POWER && ! TARGET_POWERPC64"
  "@
   {sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1
   {sfi|subfic} %L0,%L2,%1\;{sf%G1e|subf%G1e} %0,%2
   {sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1
   {sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1
   {sfi|subfic} %L0,%L2,%1\;{sf%G1e|subf%G1e} %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r,r")
	(minus:DI (match_operand:DI 1 "gpc_reg_operand" "r,0,r")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r,0")))]
  "! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"{sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1\"
    : \"{sf|subfc} %0,%2,%1\;{sfe|subfe} %L0,%L2,%L1\";
}"
  [(set_attr "length" "8")])

(define_expand "negdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))]
  "! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"{sfi|subfic} %L0,%L1,0\;{sfze|subfze} %0,%1\"
    : \"{sfi|subfic} %0,%1,0\;{sfze|subfze} %L0,%L1\";
}"
  [(set_attr "length" "8")])

(define_expand "mulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      int endian = (WORDS_BIG_ENDIAN == 0);
      emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
      emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
      emit_insn (gen_mull_call ());
      emit_move_insn (operand_subword (operands[0], endian, 0, DImode),
		      gen_rtx (REG, SImode, 3));
      emit_move_insn (operand_subword (operands[0], 1 - endian, 0, DImode),
		      gen_rtx (REG, SImode, 4));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_mulsidi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "mulsidi3_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2\;mfmq %L0"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhw %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhw %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_expand "smulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx (REG, SImode, 3), operands[1]);
      emit_move_insn (gen_rtx (REG, SImode, 4), operands[2]);
      emit_insn (gen_mulh_call ());
      emit_move_insn (operands[0], gen_rtx (REG, SImode, 3));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_smulsi3_highpart_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "smulsi3_highpart_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC"
  "mulhw %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "umulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC"
  "mulhwu %0,%1,%2"
  [(set_attr "type" "imul")])

;; If operands 0 and 2 are in the same register, we have a problem.  But
;; operands 0 and 1 (the usual case) can be in the same register.  That's
;; why we have the strange constraints below.
(define_insn "ashldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {sli|slwi} %0,%L1,%h2\;{cal %L0,0(0)|li %L0,0}
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r,r,&r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {cal %0,0(0)|li %0,0}\;{s%A2i|s%A2wi} %L0,%1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2"
  [(set_attr "length" "8")])

;; Shift by a variable amount is too complex to be worth open-coding.  We
;; just handle shifts by constants.

(define_expand "ashrdi3"
  [(parallel [(set (match_operand:DI 0 "gpc_reg_operand" "")
		   (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "general_operand" "")))
	      (clobber (match_scratch:SI 3 ""))])]
  "TARGET_POWER"
  "
{ if (GET_CODE (operands[2]) != CONST_INT)
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "const_int_operand" "M,i")))
   (clobber (match_scratch:SI 3 "=X,q"))]
  "TARGET_POWER"
  "@
   {srai|srawi} %0,%1,31\;{srai|srawi} %L0,%1,%h2
   sraiq %0,%1,%h2\;srliq %L0,%L1,%h2"
  [(set_attr "length" "8")])

;; PowerPC64 DImode operations.

(define_insn "ffsdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(ffs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "neg %0,%1\;and %0,%0,%1\;cntlzd %0,%0\;subfic %0,%0,64"
  [(set_attr "length" "16")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
		 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "mulld %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn "smuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (sign_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhd %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "umuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (zero_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhdu %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "divdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divd %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "udivdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (udiv:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divdu %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		   (match_operand:DI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%h2,0")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2cl. %3,%1,%h2,0"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(rotate:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "rld%I2cl. %0,%1,%h2,0"
  [(set_attr "type" "delayed_compare")])

;; Now define ways of moving data around.

;; Elf specific ways of loading addresses for non-PIC code.
;; The output of this could be r0, but we limit it to base
;; registers, since almost all uses of this will need it
;; in a base register shortly.
(define_insn "elf_high"
  [(set (match_operand:SI 0 "register_operand" "=b")
	(high:SI (match_operand 1 "" "")))]
  "TARGET_ELF && !TARGET_64BIT"
  "{cau|addis} %0,0,%1@ha")

(define_insn "elf_low"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(lo_sum:SI (match_operand:SI 1 "register_operand" "b")
		   (match_operand 2 "" "")))]
   "TARGET_ELF && !TARGET_64BIT"
   "{cal %0,%a2@l(%1)|addi %0,%1,%2@l}")

;; For SI, we special-case integers that can't be loaded in one insn.  We
;; do the load 16-bits at a time.  We could do this by loading from memory,
;; and this is even supposed to be faster, but it is simpler not to get
;; integers in the TOC.
(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (SImode, operands[1]);

  /* Convert a move of a CONST_DOUBLE into a CONST_INT */
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));

  if (TARGET_ELF && TARGET_NO_TOC && !TARGET_64BIT
      && CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != HIGH
      && GET_CODE (operands[1]) != CONST_INT)
    {
      rtx target = (reload_completed || reload_in_progress)
			? operands[0] : gen_reg_rtx (SImode);

      emit_insn (gen_elf_high (target, operands[1]));
      emit_insn (gen_elf_low (operands[0], target, operands[1]));
      DONE;
    }

  if (CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != HIGH
      && ! LEGITIMATE_CONSTANT_POOL_ADDRESS_P (operands[1]))
    {
      /* If we are to limit the number of things we put in the TOC and
	 this is a symbol plus a constant we can add in one insn,
	 just put the symbol in the TOC and add the constant.  Don't do
	 this if reload is in progress.  */
      if (GET_CODE (operands[1]) == CONST
	  && TARGET_NO_SUM_IN_TOC && ! reload_in_progress
	  && GET_CODE (XEXP (operands[1], 0)) == PLUS
	  && add_operand (XEXP (XEXP (operands[1], 0), 1), SImode)
	  && (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF
	      || GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == SYMBOL_REF)
	  && ! side_effects_p (operands[0]))
	{
	  rtx sym = force_const_mem (SImode, XEXP (XEXP (operands[1], 0), 0));
	  rtx other = XEXP (XEXP (operands[1], 0), 1);

	  emit_insn (gen_addsi3 (operands[0], force_reg (SImode, sym), other));
	  DONE;
	}

      operands[1] = force_const_mem (SImode, operands[1]);
      if (! memory_address_p (SImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], SImode,
				      XEXP (operands[1], 0));
    }

  if (GET_CODE (operands[1]) == CONST_INT
      && (unsigned) (INTVAL (operands[1]) + 0x8000) >= 0x10000
      && (INTVAL (operands[1]) & 0xffff) != 0)
    {
      emit_move_insn (operands[0],
		      gen_rtx (CONST_INT, VOIDmode,
			       INTVAL (operands[1]) & 0xffff0000));
      emit_insn (gen_iorsi3 (operands[0], operands[0],
			     gen_rtx (CONST_INT, VOIDmode,
				      INTVAL (operands[1]) & 0xffff)));
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,r,m,r,r,r,r,*q,*c*l,*h")
	(match_operand:SI 1 "input_operand" "r,m,r,I,J,R,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], SImode)
   || gpc_reg_operand (operands[1], SImode)"
  "@
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%u1
   {cal|la} %0,%1(%*)
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,*,*,*,*,*,*,mtjmpr,*")])

;; Split a load of a large constant into the appropriate two-insn
;; sequence.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_operand:SI 1 "const_int_operand" ""))]
  "(unsigned) (INTVAL (operands[1]) + 0x8000) >= 0x10000
   && (INTVAL (operands[1]) & 0xffff) != 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:SI (match_dup 0)
		(match_dup 3)))]
  "
{
  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[1]) & 0xffff0000);
  operands[3] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[1]) & 0xffff);
}")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r") (match_dup 1))]
  ""
  "mr. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (HImode, operands[1]);

  if (CONSTANT_P (operands[1]) && GET_CODE (operands[1]) != CONST_INT)
    {
      operands[1] = force_const_mem (HImode, operands[1]);
      if (! memory_address_p (HImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], HImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:HI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], HImode)
   || gpc_reg_operand (operands[1], HImode)"
  "@
   mr %0,%1
   lhz%U1%X1 %0,%1
   sth%U0%X0 %1,%0
   {lil|li} %0,%w1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,*,*,*,*,mtjmpr,*")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (QImode, operands[1]);

  if (CONSTANT_P (operands[1]) && GET_CODE (operands[1]) != CONST_INT)
    {
      operands[1] = force_const_mem (QImode, operands[1]);
      if (! memory_address_p (QImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], QImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:QI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], QImode)
   || gpc_reg_operand (operands[1], QImode)"
  "@
   mr %0,%1
   lbz%U1%X1 %0,%1
   stb%U0%X0 %1,%0
   {lil|li} %0,%1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,*,*,*,*,mtjmpr,*")])

;; Here is how to move condition codes around.  When we store CC data in
;; an integer register or memory, we store just the high-order 4 bits.
;; This lets us not shift in the most common case of CR0.
(define_expand "movcc"
  [(set (match_operand:CC 0 "nonimmediate_operand" "")
	(match_operand:CC 1 "nonimmediate_operand" ""))]
  ""
  "")

(define_insn ""
  [(set (match_operand:CC 0 "nonimmediate_operand" "=y,x,y,r,r,r,r,m")
	(match_operand:CC 1 "nonimmediate_operand" "y,r,r,x,y,r,m,r"))]
  "register_operand (operands[0], CCmode)
   || register_operand (operands[1], CCmode)"
  "@
   mcrf %0,%1
   mtcrf 128,%1
   {rlinm|rlwinm} %1,%1,%F0,0xffffffff\;mtcrf %R0,%1\;{rlinm|rlwinm} %1,%1,%f0,0xffffffff
   mfcr %0
   mfcr %0\;{rlinm|rlwinm} %0,%0,%f1,0xf0000000
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%U1|stw%U0%U1} %1,%0"
  [(set_attr "type" "*,*,*,compare,*,*,load,*")
   (set_attr "length" "*,*,12,*,8,*,*,*")])

;; For floating-point, we normally deal with the floating-point registers
;; unless -msoft-float is used.  The sole exception is that parameter passing
;; can produce floating-point values in fixed-point registers.  Unless the
;; value is a simple constant or already in memory, we deal with this by
;; allocating memory and copying the value explicitly via that memory location.
(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "any_operand" ""))]
  ""
  "
{
  /* If we are called from reload, we might be getting a SUBREG of a hard
     reg.  So expand it.  */
  if (GET_CODE (operands[0]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[0])) == REG
      && REGNO (SUBREG_REG (operands[0])) < FIRST_PSEUDO_REGISTER)
    operands[0] = alter_subreg (operands[0]);
  if (GET_CODE (operands[1]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[1])) == REG
      && REGNO (SUBREG_REG (operands[1])) < FIRST_PSEUDO_REGISTER)
    operands[1] = alter_subreg (operands[1]);

  if (TARGET_SOFT_FLOAT && GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (SFmode, operands[1]);

  else if (TARGET_HARD_FLOAT)
    {
      if (GET_CODE (operands[1]) == REG && REGNO (operands[1]) < 32)
	{
	  /* If this is a store to memory or another integer register do the
	     move directly.  Otherwise store to a temporary stack slot and
	     load from there into a floating point register.  */

	  if (GET_CODE (operands[0]) == MEM
	      || (GET_CODE (operands[0]) == REG
		  && (REGNO (operands[0]) < 32
		      || (reload_in_progress
			  && REGNO (operands[0]) >= FIRST_PSEUDO_REGISTER))))
	    {
	      emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			      operand_subword (operands[1], 0, 0, SFmode));
	      DONE;
	    }
	  else
	    {
	      rtx stack_slot = assign_stack_temp (SFmode, 4, 0);

	      emit_move_insn (stack_slot, operands[1]);
	      emit_move_insn (operands[0], stack_slot);
	      DONE;
	    }
	}

      if (GET_CODE (operands[0]) == MEM)
	{
	  /* If operands[1] is a register, it may have double-precision data
	     in it, so truncate it to single precision.  We need not do
	     this for POWERPC.  */
	  if (! TARGET_POWERPC && TARGET_HARD_FLOAT
	      && GET_CODE (operands[1]) == REG)
	    {
	      rtx newreg
		= reload_in_progress ? operands[1] : gen_reg_rtx (SFmode);
	      emit_insn (gen_aux_truncdfsf2 (newreg, operands[1]));
	      operands[1] = newreg;
	    }

	  operands[1] = force_reg (SFmode, operands[1]);
	}

      if (GET_CODE (operands[0]) == REG && REGNO (operands[0]) < 32)
	{
	  if (GET_CODE (operands[1]) == MEM
#if HOST_FLOAT_FORMAT == TARGET_FLOAT_FORMAT && ! defined(REAL_IS_NOT_DOUBLE)
	      || GET_CODE (operands[1]) == CONST_DOUBLE
#endif
	      || (GET_CODE (operands[1]) == REG
		  && (REGNO (operands[1]) < 32
		      || (reload_in_progress
			  && REGNO (operands[1]) >= FIRST_PSEUDO_REGISTER))))
	    {
	      emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			      operand_subword (operands[1], 0, 0, SFmode));
	      DONE;
	    }
	  else
	    {
	      rtx stack_slot = assign_stack_temp (SFmode, 4, 0);

	      emit_move_insn (stack_slot, operands[1]);
	      emit_move_insn (operands[0], stack_slot);
	      DONE;
	    }
	}
    }

  if (CONSTANT_P (operands[1]))
    {
      operands[1] = force_const_mem (SFmode, operands[1]);
      if (! memory_address_p (SFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], SFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operand:SF 1 "easy_fp_constant" ""))]
  "reload_completed && REGNO (operands[0]) <= 31"
  [(set (match_dup 2) (match_dup 3))]
  "
{ operands[2] = operand_subword (operands[0], 0, 0, SFmode);
  operands[3] = operand_subword (operands[1], 0, 0, SFmode); }")

(define_insn ""
  [(set (match_operand:SF 0 "fp_reg_or_mem_operand" "=f,f,m")
	(match_operand:SF 1 "input_operand" "f,m,f"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode)) && TARGET_HARD_FLOAT"
  "@
   fmr %0,%1
   lfs%U1%X1 %0,%1
   stfs%U0%X0 %1,%0"
  [(set_attr "type" "fp,fpload,*")])

(define_insn ""
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,r,m,r,r,r")
	(match_operand:SF 1 "input_operand" "r,m,r,I,J,R"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode)) && TARGET_SOFT_FLOAT"
  "@
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%u1
   {cal|la} %0,%1(%*)"
  [(set_attr "type" "*,load,*,*,*,*")])


(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) == MEM && GET_CODE (operands[1]) == MEM)
    {
      emit_move_insn (operand_subword (operands[0], 1, 1, DFmode),
		      operand_subword_force (operands[1], 1, DFmode));
      emit_move_insn (operand_subword (operands[0], 0, 1, DFmode),
		      operand_subword_force (operands[1], 0, DFmode));
      DONE;
    }

  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (DFmode, operands[1]);

  if (CONSTANT_P (operands[1]) && ! easy_fp_constant (operands[1], DFmode))
    {
      operands[1] = force_const_mem (DFmode, operands[1]);
      if (! memory_address_p (DFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], DFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "easy_fp_constant" ""))]
  "reload_completed && REGNO (operands[0]) <= 31"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{ operands[2] = operand_subword (operands[0], 0, 0, DFmode);
  operands[3] = operand_subword (operands[1], 0, 0, DFmode);
  operands[4] = operand_subword (operands[0], 1, 0, DFmode);
  operands[5] = operand_subword (operands[1], 1, 0, DFmode); }")

;; Don't have reload use general registers to load a constant.  First,
;; it might not work if the output operand has is the equivalent of
;; a non-offsettable memref, but also it is less efficient than loading
;; the constant into an FP register, since it will probably be used there.
;; The "??" is a kludge until we can figure out a more reasonable way
;; of handling these non-offsettable values.
(define_insn ""
  [(set (match_operand:DF 0 "nonimmediate_operand" "=!r,??r,o,!r,f,f,m")
	(match_operand:DF 1 "input_operand" "r,o,r,G,f,m,f"))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
      return \"#\";
    case 4:
      return \"fmr %0,%1\";
    case 5:
      return \"lfd%U1%X1 %0,%1\";
    case 6:
      return \"stfd%U0%X0 %1,%0\";
    }
}"
  [(set_attr "type" "*,load,*,*,fp,fpload,*")
   (set_attr "length" "8,8,8,8,*,*,*")])

(define_insn ""
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,r,o,r")
	(match_operand:DF 1 "input_operand" "r,o,r,G"))]
  "! TARGET_POWERPC64 && TARGET_SOFT_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,*,*")
   (set_attr "length" "8,8,8,8")])

(define_insn ""
  [(set (match_operand:DF 0 "nonimmediate_operand" "=!r,??r,o,!r,f,f,m")
	(match_operand:DF 1 "input_operand" "r,o,r,G,f,m,f"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   sd%U0%X0 %1,%0
   #
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0"
  [(set_attr "type" "*,load,*,*,fp,fpload,*")])

(define_insn ""
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,r,o,r")
	(match_operand:DF 1 "input_operand" "r,o,r,G"))]
  "TARGET_POWERPC64 && TARGET_SOFT_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   sd%U0%X0 %1,%0
   #"
  [(set_attr "type" "*,load,*,*")])

;; Next come the multi-word integer load and store and the load and store
;; multiple insns.
(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (DImode, operands[1]);

  if (GET_CODE (operands[1]) == CONST_DOUBLE
      || GET_CODE (operands[1]) == CONST_INT)
    {
      HOST_WIDE_INT low;
      HOST_WIDE_INT high;

      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  low = CONST_DOUBLE_LOW (operands[1]);
	  high = CONST_DOUBLE_HIGH (operands[1]);
	}
      else
	{
	  low = INTVAL (operands[1]);
	  high = (low < 0) ? ~0 : 0;
	}

      emit_move_insn (gen_rtx (SUBREG, SImode, operands[0], WORDS_BIG_ENDIAN),
		      GEN_INT (low));

      emit_move_insn (gen_rtx (SUBREG, SImode, operands[0], !WORDS_BIG_ENDIAN),
		      GEN_INT (high));
      DONE;
    }

      /* Stores between FPR and any non-FPR registers must go through a
         temporary stack slot.  */

  if (GET_CODE (operands[0]) == REG && GET_CODE (operands[1]) == REG
      && ((FP_REGNO_P (REGNO (operands[0]))
	   && ! FP_REGNO_P (REGNO (operands[1])))
	  || (FP_REGNO_P (REGNO (operands[1]))
	      && ! FP_REGNO_P (REGNO (operands[0])))))
    {
      rtx stack_slot = assign_stack_temp (DImode, 8, 0);

      emit_move_insn (stack_slot, operands[1]);
      emit_move_insn (operands[0], stack_slot);
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m,f,f,m")
	(match_operand:DI 1 "input_operand" "r,m,r,f,m,f"))]
  "! TARGET_POWERPC64 && (gpc_reg_operand (operands[0], DImode)
   || gpc_reg_operand (operands[1], DImode))"
  "*
{
  switch (which_alternative)
    {
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
      return \"fmr %0,%1\";
    case 4:
      return \"lfd%U1%X1 %0,%1\";
    case 5:
      return \"stfd%U0%X0 %1,%0\";
    }
}"
  [(set_attr "type" "*,load,*,fp,fpload,*")
   (set_attr "length" "8,8,8,*,*,*")])

(define_insn ""
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m,r,r,r,f,f,m,r,*h")
	(match_operand:DI 1 "input_operand" "r,m,r,I,J,R,f,m,f,*h,r"))]
  "TARGET_POWERPC64 && (gpc_reg_operand (operands[0], DImode)
   || gpc_reg_operand (operands[1], DImode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   sd%U0%X0 %1,%0
   li %0,%1
   lis %0,%u1
   {cal|la} %0,%1(%*)
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0
   mf%1 %0
   mt%0 %1"
  [(set_attr "type" "*,load,*,*,*,*,fp,fpload,*,*,mtjmpr")])

;; TImode is similar, except that we usually want to compute the address into
;; a register and use lsi/stsi (the exception is during reload).  MQ is also
;; clobbered in stsi for POWER, so we need a SCRATCH for it.
(define_expand "movti"
  [(parallel [(set (match_operand:TI 0 "general_operand" "")
		   (match_operand:TI 1 "general_operand" ""))
	      (clobber (scratch:SI))])]
  "TARGET_STRING || TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (TImode, operands[1]);

  if (GET_CODE (operands[0]) == MEM
      && GET_CODE (XEXP (operands[0], 0)) != REG
      && ! reload_in_progress)
    operands[0] = change_address (operands[0], TImode,
				  copy_addr_to_reg (XEXP (operands[0], 0)));

  if (GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) != REG
      && ! reload_in_progress)
    operands[1] = change_address (operands[1], TImode,
				  copy_addr_to_reg (XEXP (operands[1], 0)));
}")

;; We say that MQ is clobbered in the last alternative because the first
;; alternative would never get used otherwise since it would need a reload
;; while the 2nd alternative would not.  We put memory cases first so they
;; are preferred.  Otherwise, we'd try to reload the output instead of
;; giving the SCRATCH mq.
(define_insn ""
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=Q,m,????r,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,r,Q,m"))
   (clobber (match_scratch:SI 2 "=q,q#X,X,X,X"))]
  "TARGET_STRING && TARGET_POWER && ! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();

    case 0:
      return \"{stsi|stswi} %1,%P0,16\";

    case 1:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\;{st|stw} %Y1,%Y0\;{st|stw} %Z1,%Z0\";

    case 2:
      /* Normally copy registers with lowest numbered register copied first.
	 But copy in the other order if the first register of the output
	 is the second, third, or fourth register in the input.  */
      if (REGNO (operands[0]) >= REGNO (operands[1]) + 1
	  && REGNO (operands[0]) <= REGNO (operands[1]) + 3)
	return \"mr %Z0,%Z1\;mr %Y0,%Y1\;mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\;mr %Y0,%Y1\;mr %Z0,%Z1\";
    case 3:
      /* If the address is not used in the output, we can use lsi.  Otherwise,
	 fall through to generating four loads.  */
      if (! reg_overlap_mentioned_p (operands[0], operands[1]))
	return \"{lsi|lswi} %0,%P1,16\";
      /* ... fall through ... */
    case 4:
      /* If the address register is the same as the register for the lowest-
	 addressed word, load it last.  Similarly for the next two words.
	 Otherwise load lowest address to highest.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %0,%1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 1,
				  REGNO (operands[0]) + 2, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %L0,%L1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 2,
				  REGNO (operands[0]) + 3, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Z0,%Z1\;{l|lwz} %Y0,%Y1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\";
    }
}"
  [(set_attr "type" "*,load,load,*,*")
   (set_attr "length" "*,16,16,*,16")])

(define_insn ""
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=m,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,m"))
   (clobber (match_scratch:SI 2 "=X,X,X"))]
  "TARGET_STRING && !TARGET_POWER && ! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();

    case 0:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\;{st|stw} %Y1,%Y0\;{st|stw} %Z1,%Z0\";

    case 1:
      /* Normally copy registers with lowest numbered register copied first.
	 But copy in the other order if the first register of the output
	 is the second, third, or fourth register in the input.  */
      if (REGNO (operands[0]) >= REGNO (operands[1]) + 1
	  && REGNO (operands[0]) <= REGNO (operands[1]) + 3)
	return \"mr %Z0,%Z1\;mr %Y0,%Y1\;mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\;mr %Y0,%Y1\;mr %Z0,%Z1\";
    case 2:
      /* If the address register is the same as the register for the lowest-
	 addressed word, load it last.  Similarly for the next two words.
	 Otherwise load lowest address to highest.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %0,%1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 1,
				  REGNO (operands[0]) + 2, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %L0,%L1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 2,
				  REGNO (operands[0]) + 3, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Z0,%Z1\;{l|lwz} %Y0,%Y1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\";
    }
}"
  [(set_attr "type" "load,*,*")
   (set_attr "length" "16,16,16")])

(define_insn ""
  [(set (match_operand:TI 0 "nonimmediate_operand" "=r,r,m")
	(match_operand:TI 1 "input_operand" "r,m,r"))]
  "TARGET_POWERPC64 && (gpc_reg_operand (operands[0], TImode)
   || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"ld %L0,%L1\;ld %0,%1\";
      else
	return \"ld%U1 %0,%1\;ld %L0,%L1\";
    case 2:
      return \"std%U0 %1,%0\;std %L1,%L0\";
    }
}"
  [(set_attr "type" "*,load,*")
   (set_attr "length" "8,8,8")])

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING"
  "
{
  int regno;
  int count;
  rtx from;
  int i;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);

  operands[3] = gen_rtx (PARALLEL, VOIDmode, rtvec_alloc (count));
  from = force_reg (SImode, XEXP (operands[1], 0));

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx (SET, VOIDmode, gen_rtx (REG, SImode, regno + i),
		 gen_rtx (MEM, SImode, plus_constant (from, i * 4)));
}")

(define_insn ""
  [(match_parallel 0 "load_multiple_operation"
		   [(set (match_operand:SI 1 "gpc_reg_operand" "=r")
			 (mem:SI (match_operand:SI 2 "register_operand" "b")))])]
  "TARGET_STRING"
  "*
{
  /* We have to handle the case where the pseudo used to contain the address
     is assigned to one of the output registers.  */
  int i, j;
  int words = XVECLEN (operands[0], 0);
  rtx xop[10];

  if (XVECLEN (operands[0], 0) == 1)
    return \"{l|lwz} %1,0(%2)\";

  for (i = 0; i < words; i++)
    if (refers_to_regno_p (REGNO (operands[1]) + i,
			   REGNO (operands[1]) + i + 1, operands[2], 0))
      {
	if (i == words-1)
	  {
	    xop[0] = operands[1];
	    xop[1] = operands[2];
	    xop[2] = GEN_INT (4 * (words-1));
	    output_asm_insn (\"{lsi|lswi} %0,%1,%2\;{l|lwz} %1,%2(%1)\", xop);
	    return \"\";
	  }
	else if (i == 0)
	  {
	    xop[0] = operands[1];
	    xop[1] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
	    xop[2] = GEN_INT (4 * (words-1));
	    output_asm_insn (\"{cal %0,4(%0)|addi %0,%0,4}\;{lsi|lswi} %1,%0,%2\;{l|lwz} %0,-4(%0)\", xop);
	    return \"\";
	  }
	else
	  {
	    for (j = 0; j < words; j++)
	      if (j != i)
		{
		  xop[0] = gen_rtx (REG, SImode, REGNO (operands[1]) + j);
		  xop[1] = operands[2];
		  xop[2] = GEN_INT (j * 4);
		  output_asm_insn (\"{l|lwz} %0,%2(%1)\", xop);
		}
	    xop[0] = operands[2];
	    xop[1] = GEN_INT (i * 4);
	    output_asm_insn (\"{l|lwz} %0,%1(%0)\", xop);
	    return \"\";
	  }
      }

  return \"{lsi|lswi} %1,%2,%N0\";
}"
  [(set_attr "type" "load")
   (set_attr "length" "32")])


(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (clobber (scratch:SI))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING"
  "
{
  int regno;
  int count;
  rtx to;
  int i;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);

  operands[3] = gen_rtx (PARALLEL, VOIDmode, rtvec_alloc (count + 1));
  to = force_reg (SImode, XEXP (operands[0], 0));

  XVECEXP (operands[3], 0, 0)
    = gen_rtx (SET, VOIDmode, gen_rtx (MEM, SImode, to), operands[1]);
  XVECEXP (operands[3], 0, 1) = gen_rtx (CLOBBER, VOIDmode,
						  gen_rtx (SCRATCH, SImode));

  for (i = 1; i < count; i++)
    XVECEXP (operands[3], 0, i + 1)
      = gen_rtx (SET, VOIDmode,
		 gen_rtx (MEM, SImode, plus_constant (to, i * 4)),
		 gen_rtx (REG, SImode, regno + i));
}")

(define_insn ""
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:SI 1 "indirect_operand" "=Q")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "=q"))])]
  "TARGET_STRING && TARGET_POWER"
  "{stsi|stswi} %2,%P1,%O0")

(define_insn ""
  [(match_parallel 0 "store_multiple_operation"
		   [(set (mem:SI (match_operand:SI 1 "register_operand" "b"))
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "X"))])]
  "TARGET_STRING && !TARGET_POWER"
  "{stsi|stswi} %2,%1,%O0")


;; String/block move insn.
;; Argument 0 is the destination
;; Argument 1 is the source
;; Argument 2 is the length
;; Argument 3 is the alignment

(define_expand "movstrsi"
  [(parallel [(set (match_operand:BLK 0 "memory_operand" "")
		   (match_operand:BLK 1 "memory_operand" ""))
	      (use (match_operand:SI 2 "general_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))])]
  ""
  "
{
  if (expand_block_move (operands))
    DONE;
  else
    FAIL;
}")

;; Move up to 32 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 8 word registers
(define_expand "movstrsi_8reg"
  [(parallel [(set (mem:BLK (match_operand:SI 0 "register_operand" ""))
		   (mem:BLK (match_operand:SI 1 "register_operand" "")))
	      (use (match_operand:SI 2 "immediate_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (reg:SI  5))
	      (clobber (reg:SI  6))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32) || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32) || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

;; Move up to 24 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 6 word registers
(define_expand "movstrsi_6reg"
  [(parallel [(set (mem:BLK (match_operand:SI 0 "register_operand" ""))
		   (mem:BLK (match_operand:SI 1 "register_operand" "")))
	      (use (match_operand:SI 2 "immediate_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 24
   && (REGNO (operands[0]) < 7 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 7 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 7"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 32
   && (REGNO (operands[0]) < 7 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 7 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 7"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

;; Move up to 16 bytes at a time, using 4 fixed registers to avoid spill problems
;; with TImode
(define_expand "movstrsi_4reg"
  [(parallel [(set (mem:BLK (match_operand:SI 0 "register_operand" ""))
		   (mem:BLK (match_operand:SI 1 "register_operand" "")))
	      (use (match_operand:SI 2 "immediate_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 9 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 9 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 9"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 9 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 9 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 9"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

;; Move up to 8 bytes at a time.
(define_expand "movstrsi_2reg"
  [(parallel [(set (mem:BLK (match_operand:SI 0 "register_operand" ""))
		   (mem:BLK (match_operand:SI 1 "register_operand" "")))
	      (use (match_operand:SI 2 "immediate_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (match_scratch:DI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING && !TARGET_64BIT"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER && !TARGET_64BIT
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER && !TARGET_64BIT
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

;; Move up to 4 bytes at a time.
(define_expand "movstrsi_1reg"
  [(parallel [(set (mem:BLK (match_operand:SI 0 "register_operand" ""))
		   (mem:BLK (match_operand:SI 1 "register_operand" "")))
	      (use (match_operand:SI 2 "immediate_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (match_scratch:SI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "length" "8")])


;; Define insns that do load or store with update.  Some of these we can
;; get by using pre-decrement or pre-increment, but the hardware can also
;; do cases where the increment is not the size of the object.
;;
;; In all these cases, we use operands 0 and 1 for the register being
;; incremented because those are the operands that local-alloc will
;; tie and these are the pair most likely to be tieable (and the ones
;; that will benefit the most).

(define_insn ""
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r,r")
	(mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "@
   ldux %3,%0,%2
   ldu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r")
	(sign_extend:DI
	 (mem:SI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0")
			  (match_operand:DI 2 "gpc_reg_operand" "r")))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "lwaux %3,%0,%2"
  [(set_attr "type" "load")])

(define_insn "movdi_update"
  [(set (mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "@
   stdux %3,%0,%2
   stdu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {lux|lwzux} %3,%0,%2
   {lu|lwzu} %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "movsi_update"
  [(set (mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {stux|stwux} %3,%0,%2
   {stu|stwu} %3,%2(%0)")

(define_insn ""
  [(set (match_operand:HI 3 "gpc_reg_operand" "=r,r")
	(mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(sign_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhaux %3,%0,%2
   lhau %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:HI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   sthux %3,%0,%2
   sthu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:QI 3 "gpc_reg_operand" "=r,r")
	(mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn ""
  [(set (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:QI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   stbux %3,%0,%2
   stbu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:SF 3 "gpc_reg_operand" "=f,f")
	(mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT"
  "@
   lfsux %3,%0,%2
   lfsu %3,%2(%0)"
  [(set_attr "type" "fpload")])

(define_insn ""
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT"
  "@
   stfsux %3,%0,%2
   stfsu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:DF 3 "gpc_reg_operand" "=f,f")
	(mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT"
  "@
   lfdux %3,%0,%2
   lfdu %3,%2(%0)"
  [(set_attr "type" "fpload")])

(define_insn ""
  [(set (mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT"
  "@
   stfdux %3,%0,%2
   stfdu %3,%2(%0)")

;; Peephole to convert two consecutive FP loads or stores into lfq/stfq.

(define_peephole
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(match_operand:DF 1 "memory_operand" ""))
   (set (match_operand:DF 2 "gpc_reg_operand" "=f")
	(match_operand:DF 3 "memory_operand" ""))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT
   && registers_ok_for_quad_peep (operands[0], operands[2])
   && ! MEM_VOLATILE_P (operands[1]) && ! MEM_VOLATILE_P (operands[3])
   && addrs_ok_for_quad_peep (XEXP (operands[1], 0), XEXP (operands[3], 0))"
  "lfq%U1%X1 %0,%1")

(define_peephole
  [(set (match_operand:DF 0 "memory_operand" "")
	(match_operand:DF 1 "gpc_reg_operand" "f"))
   (set (match_operand:DF 2 "memory_operand" "")
	(match_operand:DF 3 "gpc_reg_operand" "f"))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT
   && registers_ok_for_quad_peep (operands[1], operands[3])
   && ! MEM_VOLATILE_P (operands[0]) && ! MEM_VOLATILE_P (operands[2])
   && addrs_ok_for_quad_peep (XEXP (operands[0], 0), XEXP (operands[2], 0))"
  "stfq%U0%X0 %1,%0")

;; Next come insns related to the calling sequence.
;;
;; First, an insn to allocate new stack space for dynamic use (e.g., alloca).
;; We move the back-chain and decrement the stack pointer.

(define_expand "allocate_stack"
  [(set (reg:SI 1)
	(minus:SI (reg:SI 1) (match_operand:SI 0 "reg_or_short_operand" "")))]
  ""
  "
{ rtx chain = gen_reg_rtx (Pmode);
  rtx stack_bot = gen_rtx (MEM, Pmode, stack_pointer_rtx);
  rtx neg_op0;

  emit_move_insn (chain, stack_bot);

  if (GET_CODE (operands[0]) != CONST_INT
      || INTVAL (operands[0]) < -32767
      || INTVAL (operands[0]) > 32768)
    {
      neg_op0 = gen_reg_rtx (Pmode);
      if (TARGET_POWERPC64)
	emit_insn (gen_negdi2 (neg_op0, operands[0]));
      else
	emit_insn (gen_negsi2 (neg_op0, operands[0]));
    }
  else
    neg_op0 = GEN_INT (- INTVAL (operands[0]));

  if (TARGET_POWERPC64)
    emit_insn (gen_movdi_update (stack_pointer_rtx, stack_pointer_rtx, neg_op0, chain));
  else
    emit_insn (gen_movsi_update (stack_pointer_rtx, stack_pointer_rtx, neg_op0, chain));

  DONE;
}")

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_block"
  [(set (match_dup 2) (mem:SI (match_operand:SI 0 "register_operand" "")))
   (set (match_dup 0) (match_operand:SI 1 "register_operand" ""))
   (set (mem:SI (match_dup 0)) (match_dup 2))]
  ""
  "
{ operands[2] = gen_reg_rtx (SImode); }")

(define_expand "save_stack_nonlocal"
  [(match_operand:DI 0 "memory_operand" "")
   (match_operand:SI 1 "register_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (SImode);

  /* Copy the backchain to the first word, sp to the second.  */
  emit_move_insn (temp, gen_rtx (MEM, SImode, operands[1]));
  emit_move_insn (operand_subword (operands[0], 0, 0, DImode), temp);
  emit_move_insn (operand_subword (operands[0], 1, 0, DImode), operands[1]);
  DONE;
}")

(define_expand "restore_stack_nonlocal"
  [(match_operand:SI 0 "register_operand" "")
   (match_operand:DI 1 "memory_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (SImode);

  /* Restore the backchain from the first word, sp from the second.  */
  emit_move_insn (temp, operand_subword (operands[1], 0, 0, DImode));
  emit_move_insn (operands[0], operand_subword (operands[1], 1, 0, DImode));
  emit_move_insn (gen_rtx (MEM, SImode, operands[0]), temp);
  DONE;
}")

;; A function pointer is a pointer to a data area whose first word contains
;; the actual address of the function, whose second word contains a pointer
;; to its TOC, and whose third word contains a value to place in the static
;; chain register (r11).  Note that if we load the static chain, our
;; "trampoline" need not have any executable code.
;;
;; operands[0] is an SImode pseudo in which we place the address of the
;; 	       function.
;; operands[1] is the address of data area of the function to call

(define_expand "call_via_ptr"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(mem:SI (match_operand:SI 1 "gpc_reg_operand" "")))
   (set (mem:SI (plus:SI (reg:SI 1) (const_int 20)))
	(reg:SI 2))
   (set (reg:SI 2)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 4))))
   (set (reg:SI 11)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 8))))
   (use (reg:SI 2))
   (use (reg:SI 11))]
  ""
  "")

(define_expand "call"
  [(parallel [(call (mem:SI (match_operand:SI 0 "address_operand" ""))
		    (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != CONST_INT)
    abort ();

  operands[0] = XEXP (operands[0], 0);
  if (GET_CODE (operands[0]) != SYMBOL_REF)
    {
#ifndef USING_SVR4_H
      /* AIX function pointers are really pointers to a three word area */
      rtx temp = gen_reg_rtx (SImode);

      emit_insn (gen_call_via_ptr (temp, force_reg (SImode, operands[0])));
      operands[0] = temp;
#endif	/* !USING_SVR4_H */
    }
}")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_operand:SI 1 "address_operand" ""))
			 (match_operand 2 "" "")))
	      (use (match_operand 3 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != CONST_INT)
    abort ();

  operands[1] = XEXP (operands[1], 0);
  if (GET_CODE (operands[1]) != SYMBOL_REF)
    {
#ifndef USING_SVR4_H
      /* AIX function pointers are really pointers to a three word area */
      rtx temp = gen_reg_rtx (SImode);

      emit_insn (gen_call_via_ptr (temp, force_reg (SImode, operands[1])));
      operands[1] = temp;
#endif	/* !USING_SVR4_H */
    }
}")

;; Call to function in current module.  No TOC pointer reload needed.
;; Operand2 is non-zero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn ""
  [(call (mem:SI (match_operand:SI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  ""
  "*
{
  if (INTVAL (operands[2]) > 0)
    return \"creqv 6,6,6\;bl %z0\";

  else if (INTVAL (operands[2]) < 0)
    return \"crxor 6,6,6\;bl %z0\";

  return \"bl %z0\";
}"
  [(set_attr "length" "4,8")])

;; Call to function which may be in another module.  Restore the TOC
;; pointer (r2) after the call unless this is System V.
;; Operand2 is non-zero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn ""
  [(call (mem:SI (match_operand:SI 0 "call_operand" "l,s,l,s"))
	 (match_operand 1 "" "fg,fg,fg,fg"))
   (use (match_operand:SI 2 "immediate_operand" "O,O,n,n"))
   (clobber (match_scratch:SI 3 "=l,l,l,l"))]
  ""
  "*
{
  if (INTVAL (operands[2]) > 0)
    output_asm_insn (\"creqv 6,6,6\", operands);

  else if (INTVAL (operands[2]) < 0)
    output_asm_insn (\"crxor 6,6,6\", operands);

#ifndef USING_SVR4_H
  if (GET_CODE (operands[0]) == REG)
    return \"{brl|blrl}\;{l|lwz} 2,20(1)\";

  return \"bl %z0\;%.\";

#else
  if (GET_CODE (operands[0]) == REG)
    return \"{brl|blrl}\";

  return \"bl %z0\";
#endif
}"
  [(set_attr "length" "8,8,12,12")])

(define_insn ""
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  ""
  "*
{
  if (INTVAL (operands[3]) > 0)
    return \"creqv 6,6,6\;bl %z1\";

  else if (INTVAL (operands[3]) < 0)
    return \"crxor 6,6,6\;bl %z1\";

  return \"bl %z1\";
}"
  [(set_attr "length" "4,8")])

(define_insn ""
  [(set (match_operand 0 "" "=fg,fg,fg,fg")
	(call (mem:SI (match_operand:SI 1 "call_operand" "l,s,l,s"))
	      (match_operand 2 "" "fg,fg,fg,fg")))
   (use (match_operand:SI 3 "immediate_operand" "O,O,n,n"))
   (clobber (match_scratch:SI 4 "=l,l,l,l"))]
  ""
  "*
{
  if (INTVAL (operands[3]) > 0)
    output_asm_insn (\"creqv 6,6,6\", operands);

  else if (INTVAL (operands[3]) < 0)
    output_asm_insn (\"crxor 6,6,6\", operands);

#ifndef USING_SVR4_H
  if (GET_CODE (operands[1]) == REG)
    return \"{brl|blrl}\;{l|lwz} 2,20(1)\";

  return \"bl %z1\;%.\";

#else
  if (GET_CODE (operands[1]) == REG)
    return \"{brl|blrl}\";

  return \"bl %z1\";
#endif
}"
  [(set_attr "length" "8,8,12,12")])

;; Call subroutine returning any type.

(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  ""
  "
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx, const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
}")

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] 0)]
  ""
  "")

;; Synchronize instruction/data caches for V.4 trampolines
(define_insn "sync_isync"
  [(unspec [(match_operand 0 "memory_operand" "=m")] 1)]
  ""
  "{dcs|sync}\;{ics|isync}"
  [(set_attr "length" "8")])


;; Compare insns are next.  Note that the RS/6000 has two types of compares,
;; signed & unsigned, and one type of branch.
;;
;; Start with the DEFINE_EXPANDs to generate the rtl for compares, scc
;; insns, and branches.  We store the operands of compares until we see
;; how it is used.
(define_expand "cmpsi"
  [(set (cc0)
        (compare (match_operand:SI 0 "gpc_reg_operand" "")
  		 (match_operand:SI 1 "reg_or_short_operand" "")))]
  ""
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (SImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpsf"
  [(set (cc0) (compare (match_operand:SF 0 "gpc_reg_operand" "")
		       (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "cmpdf"
  [(set (cc0) (compare (match_operand:DF 0 "gpc_reg_operand" "")
		       (match_operand:DF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "beq"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (eq (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bne"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ne (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "blt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (lt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "ble"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (le (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bge"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ge (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gtu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bltu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ltu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (geu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bleu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (leu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; For SNE, we would prefer that the xor/abs sequence be used for integers.
;; For SEQ, likewise, except that comparisons with zero should be done
;; with an scc insns.  However, due to the order that combine see the
;; resulting insns, we must, in fact, allow SEQ for integers.  Fail in
;; the cases we don't want to handle.
(define_expand "seq"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(eq:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sne"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ne:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ if (! rs6000_compare_fp_p)
    FAIL;

  operands[1] = gen_rtx (COMPARE, CCFPmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCFPmode);
}")

;; A > 0 is best done using the portable sequence, so fail in that case.
(define_expand "sgt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A < 0 is best done in the portable way for A an integer.
(define_expand "slt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sge"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ge:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A <= 0 is best done the portable way for A an integer.
(define_expand "sle"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(le:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gtu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sltu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ltu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(geu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sleu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(leu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; Here are the actual compare insns.
(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{cmp%I2|cmpw%I2} %0,%1,%2"
  [(set_attr "type" "compare")])

;; If we are comparing a register for equality with a large constant,
;; we can do this with an XOR followed by a compare.  But we need a scratch
;; register for the result of the XOR.

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "non_short_cint_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "find_single_use (operands[0], insn, 0)
   && (GET_CODE (*find_single_use (operands[0], insn, 0)) == EQ
       || GET_CODE (*find_single_use (operands[0], insn, 0)) == NE)"
  [(set (match_dup 3) (xor:SI (match_dup 1) (match_dup 4)))
   (set (match_dup 0) (compare:CC (match_dup 3) (match_dup 5)))]
  "
{
  /* Get the constant we are comparing against, C,  and see what it looks like
     sign-extended to 16 bits.  Then see what constant could be XOR'ed
     with C to get the sign-extended value.  */

  int c = INTVAL (operands[2]);
  int sextc = (c << 16) >> 16;
  int xorv = c ^ sextc;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, xorv);
  operands[5] = gen_rtx (CONST_INT, VOIDmode, sextc);
}")

(define_insn ""
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_u_short_operand" "rI")))]
  ""
  "{cmpl%I2|cmplw%I2} %0,%1,%W2"
  [(set_attr "type" "compare")])

;; The following two insns don't exist as single insns, but if we provide
;; them, we can swap an add and compare, which will enable us to overlap more
;; of the required delay between a compare and branch.  We generate code for
;; them by splitting.

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "u_short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CC (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_split
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "")
		       (match_operand:SI 2 "u_short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CCUNS (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:SF 1 "gpc_reg_operand" "f")
		      (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:DF 1 "gpc_reg_operand" "f")
		      (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

;; Now we have the scc insns.  We can do some combinations because of the
;; way the machine works.
;;
;; Note that this is probably faster if we can put an insn between the
;; mfcr and rlinm, but this is tricky.  Let's leave it for now.  In most
;; cases the insns below which don't use an intermediate CR field will
;; be used instead.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))]
  ""
  "%D1mfcr %0\;{rlinm|rlwinm} %0,%0,%J1,1"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (const_int 0)))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))]
  ""
  "%D1mfcr %3\;{rlinm.|rlwinm.} %3,%3,%J1,1"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				      [(match_operand 2 "cc_reg_operand" "y")
				       (const_int 0)])
		   (match_operand:SI 3 "const_int_operand" "n")))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[4] = gen_rtx (CONST_INT, VOIDmode, count);
  operands[5] = gen_rtx (CONST_INT, VOIDmode, put_bit);

  return \"%D1mfcr %0\;{rlinm|rlwinm} %0,%0,%4,%5,%5\";
}"
 [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (match_operand:SI 3 "const_int_operand" "n"))
	 (const_int 0)))
   (set (match_operand:SI 4 "gpc_reg_operand" "=r")
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[5] = gen_rtx (CONST_INT, VOIDmode, count);
  operands[6] = gen_rtx (CONST_INT, VOIDmode, put_bit);

  return \"%D1mfcr %4\;{rlinm.|rlwinm.} %4,%4,%5,%6,%6\";
}"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

;; If we are comparing the result of two comparisons, this can be done
;; using creqv or crxor.

(define_insn ""
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y")
	(compare:CCEQ (match_operator 1 "scc_comparison_operator"
			      [(match_operand 2 "cc_reg_operand" "y")
			       (const_int 0)])
		      (match_operator 3 "scc_comparison_operator"
			      [(match_operand 4 "cc_reg_operand" "y")
			       (const_int 0)])))]
  "REGNO (operands[2]) != REGNO (operands[4])"
  "*
{
  enum rtx_code code1, code2;

  code1 = GET_CODE (operands[1]);
  code2 = GET_CODE (operands[3]);

  if ((code1 == EQ || code1 == LT || code1 == GT
       || code1 == LTU || code1 == GTU
       || (code1 != NE && GET_MODE (operands[2]) == CCFPmode))
      !=
      (code2 == EQ || code2 == LT || code2 == GT
       || code2 == LTU || code2 == GTU
       || (code2 != NE && GET_MODE (operands[4]) == CCFPmode)))
    return \"%C1%C3crxor %E0,%j1,%j3\";
  else
    return \"%C1%C3creqv %E0,%j1,%j3\";
}"
  [(set_attr "length" "12")])

;; There is a 3 cycle delay between consecutive mfcr instructions
;; so it is useful to combine 2 scc instructions to use only one mfcr.

(define_peephole
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_operator:SI 4 "scc_comparison_operator"
			   [(match_operand 5 "cc_reg_operand" "y")
			    (const_int 0)]))]
   "REGNO (operands[2]) != REGNO (operands[5])"
   "%D1%D4mfcr %3\;{rlinm|rlwinm} %0,%3,%J1,1\;{rlinm|rlwinm} %3,%3,%J4,1"
   [(set_attr "length" "20")])

;; There are some scc insns that can be done directly, without a compare.
;; These are faster because they don't involve the communications between
;; the FXU and branch units.   In fact, we will be replacing all of the
;; integer scc insns here or in the portable methods in emit_store_flag.
;;
;; Also support (neg (scc ..)) since that construct is used to replace
;; branches, (plus (scc ..) ..) since that construct is common and
;; takes no more insns than scc, and (and (neg (scc ..)) ..) in the
;; cases where it is no more expensive than (neg (scc ..)).

;; Have reload force a constant into a register for the simple insns that
;; otherwise won't accept constants.  We do this because it is faster than
;; the cmp/mfcr sequence we would otherwise generate.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I")))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae|adde} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae.|adde.} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

;; We have insns of the form shown by the first define_insn below.  If
;; there is something inside the comparison operation, we must split it.
(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operator 1 "comparison_operator"
				 [(match_operand:SI 2 "" "")
				  (match_operand:SI 3
						    "reg_or_cint_operand" "")])
		 (match_operand:SI 4 "gpc_reg_operand" "")))
   (clobber (match_operand:SI 5 "register_operand" ""))]
  "! gpc_reg_operand (operands[2], SImode)"
  [(set (match_dup 5) (match_dup 2))
   (set (match_dup 2) (plus:SI (match_op_dup 1 [(match_dup 2) (match_dup 3)])
			       (match_dup 4)))])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
			(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {sfi|subfic} %4,%1,0\;{aze|addze} %0,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,0\;{aze.|addze.} %0,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %4,%1,0\;{aze.|addze.} %4,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(neg:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))))]
  ""
  "@
   xor %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{sfe|subfe} %0,%0,%0
   {xoril|xori} %0,%1,%b2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {xoriu|xoris} %0,%1,%u2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {sfi|subfic} %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
   [(set_attr "length" "12,8,12,12,12")])

;; Simplify (ne X (const_int 0)) on the PowerPC.  No need to on the Power,
;; since it nabs/sr is just as fast.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lshiftrt:SI (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		     (const_int 31)))
   (clobber (match_scratch:SI 2 "=&r"))]
  "!TARGET_POWER"
  "{ai|addic} %2,%1,-1\;{sfe|subfe} %0,%2,%1"
  [(set_attr "length" "8")])

;; This is what (plus (ne X (const_int 0)) Y) looks like.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI
		  (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		  (const_int 31))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze|addze} %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze.|addze.} %3,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze.|addze.} %0,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
	       (match_operand:SI 2 "reg_or_short_operand" "r,O")))
   (clobber (match_scratch:SI 3 "=r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x")
	(compare:CC
	 (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "r,O"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "compare,delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,O"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		       (match_operand:SI 2 "reg_or_short_operand" "r,O"))))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_dup 1) (match_dup 2)))]
   ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI")))
		(match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{sri|srwi} %0,%0,31"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg. %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,r,P,P"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,I,r,I")))
   (clobber (match_scratch:SI 4 "=&r,r,&r,r"))]
  ""
  "@
  {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3"
 [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

;; This is (and (neg (ge X (const_int 0))) Y).
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (lshiftrt:SI
		  (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		  (const_int 31)))
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc %0,%2,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc. %3,%2,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (lshiftrt:SI (not:SI (match_dup 1))
				     (const_int 31)))
		(match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc. %0,%2,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze|addze} %0,%3
   {ai|addic} %4,%1,%n2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze.|addze.} %4,%3
   {ai|addic} %4,%1,%n2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze.|addze.} %0,%3
   {ai|addic} %4,%1,%n2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,I"))))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0
   {sfi|subfic} %0,%1,-1\;{a%I2|add%I2c} %0,%0,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI
		 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		(match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (const_int 0)))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (const_int 0)))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "r")))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(const_int 0))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze|addze} %0,%2"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze.|addze.} %0,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze.|addze.} %3,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "r"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (const_int 0))))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "r"))))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_dup 1) (match_dup 2)))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "I,r,rI"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,r,I")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze|addze} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3"
  [(set_attr "length" "8,12,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze.|addze.} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze.|addze.} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

;; Define both directions of branch and return.  If we need a reload
;; register, we'd rather use CR0 since it is much easier to copy a
;; register CC value to there.

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  if (get_attr_length (insn) == 8)
    return \"%C1bc %t1,%j1,%l0\";
  else
    return \"%C1bc %T1,%j1,$+8\;b %l0\";
}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (return)
		      (pc)))]
  "direct_return ()"
  "{%C0bcr|%C0bclr} %t0,%j0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  if (get_attr_length (insn) == 8)
    return \"%C1bc %T1,%j1,%l0\";
  else
    return \"%C1bc %t1,%j1,$+8\;b %l0\";
}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (return)))]
  "direct_return ()"
  "{%C0bcr|%C0bclr} %T0,%j0"
  [(set_attr "length" "8")])

;; Unconditional branch and return.

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "b %l0")

(define_insn "return"
  [(return)]
  "direct_return ()"
  "{br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "c,l"))]
  ""
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

;; Table jump for switch statements:
(define_expand "tablejump"
  [(set (match_dup 3)
	(plus:SI (match_operand:SI 0 "" "")
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  ""
  "
{ operands[0] = force_reg (SImode, operands[0]);
  operands[2] = force_reg (SImode, gen_rtx (LABEL_REF, VOIDmode, operands[1]));
  operands[3] = gen_reg_rtx (SImode);
}")

(define_insn ""
  [(set (pc)
	(match_operand:SI 0 "register_operand" "c,l"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "{cror 0,0,0|nop}")

;; Define the subtract-one-and-jump insns, starting with the template
;; so loop.c knows what to generate.

(define_expand "decrement_and_branchsi"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (plus:SI (match_dup 0)
			    (const_int -1)))
	      (set (pc) (if_then_else (ne (match_dup 0)
					  (const_int 1))
				      (label_ref (match_operand 1 "" ""))
				      (pc)))
	      (clobber (match_scratch:CC 2 ""))
	      (clobber (match_scratch:SI 3 ""))])]
  ""
  "")

;; We need to be able to do this for any operand, including MEM, or we
;; will cause reload to blow up since we don't allow output reloads on
;; JUMP_INSNs.
;; In order that the length attribute is calculated correctly, the
;; label MUST be operand 0.

(define_insn ""
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

;; Similar, but we can use GE since we have a REG_NONNEG.
(define_insn ""
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&X"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  "find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&X"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  "find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 0)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "general_operand" "")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed && ! gpc_reg_operand (operands[0], SImode)"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 4)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (match_dup 0)
	(match_dup 4))
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")
