/*-
 * Copyright (c) 1992, 1993, 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: vm_unix.c,v 2.1 1995/02/03 08:54:05 polk Exp $
 */

/*
 * Copyright (c) 1988 University of Utah.
 * Copyright (c) 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * the Systems Programming Group of the University of Utah Computer
 * Science Department.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: Utah Hdr: vm_unix.c 1.1 89/11/07
 *
 *	@(#)vm_unix.c	8.1 (Berkeley) 6/11/93
 */

/*
 * Traditional sbrk/grow interface to VM
 */
#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/resourcevar.h>

#include <vm/vm.h>

struct obreak_args {
	char	*nsiz;
};
/* ARGSUSED */
int
obreak(p, uap, retval)
	struct proc *p;
	struct obreak_args *uap;
	int *retval;
{
	register struct vmspace *vm = p->p_vmspace;
	vm_offset_t new, old;
	int rv;
	register int diff;

	old = (vm_offset_t)vm->vm_daddr;
	new = round_page(uap->nsiz);
	if ((int)(new - old) > p->p_rlimit[RLIMIT_DATA].rlim_cur)
		return(ENOMEM);
	old = round_page(old + ctob(vm->vm_dsize));
	diff = new - old;
	if (diff > 0) {
		if (rv = vm_reserve(p, diff))
			return (rv);
		rv = vm_allocate(&vm->vm_map, &old, diff, FALSE);
		if (rv != KERN_SUCCESS) {
			uprintf("sbrk: grow failed, return = %d\n", rv);
			return(ENOMEM);
		}
		vm->vm_dsize += btoc(diff);
	} else if (diff < 0) {
		diff = -diff;
		rv = vm_deallocate(&vm->vm_map, new, diff);
		if (rv != KERN_SUCCESS) {
			uprintf("sbrk: shrink failed, return = %d\n", rv);
			return(ENOMEM);
		}
		vm->vm_dsize -= btoc(diff);
	}
	return(0);
}

/*
 * Enlarge the "stack segment" to include the specified
 * stack pointer for the process.
 *
 * XXX This routine should probably be changed to return `void'.
 * Callers cannot use the success/fail return value for anything,
 * because users can explicitly mmap() in the stack area.
 *
 * XXX This routine is grossly biased for downward-growing stacks...
 */
int
grow(p, sp)
	struct proc *p;
	unsigned sp;
{
	register struct vmspace *vm = p->p_vmspace;
	vm_offset_t v;
	vm_size_t ssize;
	vm_size_t newssize, extend;
	int error;

	/*
	 * For user defined stacks (from sendsig).
	 */
	if (sp < (unsigned)vm->vm_maxsaddr)
		return (1);
	/*
	 * For common case of already allocated (from trap).
	 */
	ssize = ctob(vm->vm_ssize);
	if (sp >= USRSTACK - ssize)
		return (1);
	/*
	 * Really need to check vs limit and increment stack size if ok.
	 */
	newssize = roundup(USRSTACK - sp, CLBYTES);
	if (newssize > p->p_rlimit[RLIMIT_STACK].rlim_cur)
		return (0);
	/*
	 * Do we need more virtual space?
	 * Grow more VM in units of STACKINCR.
	 */
	newssize = roundup(newssize, STACKINCR);
	if (ssize < newssize) {
		v = max(USRSTACK - newssize, (u_long)vm->vm_maxsaddr);
		extend = (USRSTACK - v) - ssize;
		if (error = vm_reserve(p, extend))
			return (0);
		if (vm_allocate(&vm->vm_map, &v, extend, 0) != KERN_SUCCESS)
			return (0);
		vm->vm_ssize = btoc(USRSTACK - v);
	}
	return (1);
}

struct ovadvise_args {
	int	anom;
};
/* ARGSUSED */
int
ovadvise(p, uap, retval)
	struct proc *p;
	struct ovadvise_args *uap;
	int *retval;
{

	return (EINVAL);
}
