/*	BSDI $Id: dmap.h,v 2.1 1995/02/03 08:38:31 polk Exp $	*/

/*-
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)dmap.h	8.2 (Berkeley) 1/4/94
 */

#ifndef _SYS_DMAP_H_
#define	_SYS_DMAP_H_

/*
 * Definitions for the mapping of vitual swap space to the physical swap
 * area - the disk map.
 */
#define	NDMAP	38		/* size of the swap area map */

struct dmap {
	swblk_t dm_size;	/* current size used by process */
	swblk_t dm_alloc;	/* amount of physical swap space allocated */
	swblk_t dm_map[NDMAP];	/* first disk block number in each chunk */
};
#ifdef KERNEL
struct dmap zdmap;
int dmmin, dmmax, dmtext;
#endif

/* The following structure is that ``returned'' from a call to vstodb(). */
struct dblock {
	swblk_t db_base;	/* base of physical contig drum block */
	swblk_t db_size;	/* size of block */
};
#endif	/* !_SYS_DMAP_H_ */
