/*	BSDI $Id: tcp.h,v 2.4 1995/10/25 04:40:40 karels Exp $	*/

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tcp.h	8.1 (Berkeley) 6/10/93
 */

typedef	u_long	tcp_seq;
/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
	u_short	th_sport;		/* source port */
	u_short	th_dport;		/* destination port */
	tcp_seq	th_seq;			/* sequence number */
	tcp_seq	th_ack;			/* acknowledgement number */
#if BYTE_ORDER == LITTLE_ENDIAN 
	u_char	th_x2:4,		/* (unused) */
		th_off:4;		/* data offset */
#endif
#if BYTE_ORDER == BIG_ENDIAN 
	u_char	th_off:4,		/* data offset */
		th_x2:4;		/* (unused) */
#endif
	u_char	th_flags;
#define	TH_FIN	0x01
#define	TH_SYN	0x02
#define	TH_RST	0x04
#define	TH_PUSH	0x08
#define	TH_ACK	0x10
#define	TH_URG	0x20
	u_short	th_win;			/* window */
	u_short	th_sum;			/* checksum */
	u_short	th_urp;			/* urgent pointer */
};

#define	TCPOPT_EOL		0
#define	TCPOPT_NOP		1
#define	TCPOPT_MAXSEG		2
#define    TCPOLEN_MAXSEG		4
#define TCPOPT_WINDOW		3
#define    TCPOLEN_WINDOW		3
#define TCPOPT_SACK_PERMITTED	4		/* Experimental */
#define    TCPOLEN_SACK_PERMITTED	2
#define TCPOPT_SACK		5		/* Experimental */
#define TCPOPT_TIMESTAMP	8
#define    TCPOLEN_TIMESTAMP		10
#define    TCPOLEN_TSTAMP_APPA		(TCPOLEN_TIMESTAMP+2) /* appendix A */

#define TCPOPT_TSTAMP_HDR	\
    (TCPOPT_NOP<<24|TCPOPT_NOP<<16|TCPOPT_TIMESTAMP<<8|TCPOLEN_TIMESTAMP)

/*
 * Default maximum segment size for TCP.
 * With an IP MSS of 576, this is 536,
 * but 512 bytes of data is probably more convenient.
 * However, we must leave space for timestamp options (12 bytes).
 */
#define	TCP_MSS	536

#define	TCP_MAXWIN	65535	/* largest value for (unscaled) window */

#define TCP_MAX_WINSHIFT	14	/* maximum window shift */

/*
 * User-settable options (used with setsockopt).
 */
#define	TCP_NODELAY	0x01	/* don't delay send to coalesce packets */
#define	TCP_MAXSEG	0x02	/* set maximum segment size */

/* parameters that can be set with sysctl */
int	tcp_sendspace;
int	tcp_recvspace;
int 	tcp_mssdflt;
int 	tcp_rttdflt;
int	tcp_do_rfc1323;
int	tcp_keepidle;		/* time before probing idle */
int	tcp_keepintvl;		/* interval betwn idle probes */
int	tcp_keepcnt;		/* max idle probes */
int	tcp_maxpersistidle;	/* max idle time in persist */
int	tcp_conntimeo;		/* initial connection timeout */

/*
 * Names for TCP sysctl objects
 */
#define	TCPCTL_MSSDFLT		1	/* default seg size */
#define	TCPCTL_DO_RFC1323	2	/* use RFC1323 options */
#define	TCPCTL_KEEPIDLE		3	/* time before probing idle */
#define	TCPCTL_KEEPINTVL	4	/* interval betwn idle probes */
#define	TCPCTL_KEEPCNT		5	/* max idle probes */
#define	TCPCTL_MAXPERSISTIDLE	6	/* max idle time in persist */
#define	TCPCTL_SENDSPACE	7	/* default send buffer */
#define	TCPCTL_RECVSPACE	8	/* default recv buffer */
#define	TCPCTL_CONNTIMEO	9	/* default recv buffer */
#define	TCPCTL_MAXID		10

#define	TCPCTL_NAMES { \
	{ 0, 0 }, \
	{ "mssdflt", CTLTYPE_INT }, \
	{ "do_rfc1323", CTLTYPE_INT }, \
	{ "keepidle", CTLTYPE_INT }, \
	{ "keepinterval", CTLTYPE_INT }, \
	{ "keepcount", CTLTYPE_INT }, \
	{ "maxpersistidle", CTLTYPE_INT }, \
	{ "sendspace", CTLTYPE_INT }, \
	{ "recvspace", CTLTYPE_INT }, \
	{ "conntimeo", CTLTYPE_INT }, \
}

#define	TCPCTL_VARS { \
	0, \
	&tcp_mssdflt, \
	&tcp_do_rfc1323, \
	&tcp_keepidle, \
	&tcp_keepintvl, \
	&tcp_keepcnt, \
	&tcp_maxpersistidle, \
	&tcp_sendspace, \
	&tcp_recvspace, \
	&tcp_conntimeo, \
}
