/*-
 * Copyright (c) 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: pppvar.h,v 2.4 1995/12/05 20:45:21 prb Exp $
 *	Urner Id: pppvar.h,v 1.2 1994/12/03 00:25:26 dlu Exp
 */

/*
 * The software state of a PPP link
 */

/*
 * Undefine PPP_DEBUG if no debugging code is needed;
 * define it as 0 if debugging should off on default,
 * or as 1 if debugging is default.
 */
#ifndef PPP_DEBUG
#define	PPP_DEBUG 0
#endif

#include <net/pppioctl.h>

/*
 * PPP finite state machine definitions
 */
struct ppp_fsm {
	u_char  fsm_state;	/* Control protocol state */
	u_char  fsm_id;		/* Control protocol id */
	u_short fsm_rej;	/* Rejected options */
	u_short fsm_rc;		/* Restart counter */
};

struct ppp_sc {
	struct	ppp_ioctl ppp_dflt;	/* default link parameters */
	struct	ppp_ioctl ppp_params;	/* negotiated link parameters */
	u_long	ppp_txcmap;		/* active TX chars map */

	/* Timer parameters */
	u_short	ppp_ticks;		/* timeout in ticks */
	u_short	ppp_idlecnt;		/* idle time counter */

	/* LCP state */
	struct	ppp_fsm ppp_lcp;	/* line control protocol state */
	u_long	ppp_magic;		/* our magic number */
	u_char	ppp_badmagic;		/* number of retries with magic */
	u_char	ppp_ncps;		/* the number of active NCPs */
	u_char	ppp_txflags;		/* TX modes accepted by peer */
	u_char	ppp_wdrop;		/* Someone's waiting for dropped */

	/* IPCP state */
	struct	ppp_fsm ppp_ipcp;	/* internet control protocol state */
	struct	slcompress *ppp_ctcp;	/* compressed tcp state */
	struct	ifqueue ppp_ipdefq;	/* queue for deferred outgoing IP */
	u_short	ppp_ipwbos;		/* someone's awaits tlu from IPCP */

	/* ppp_hdr state for input packets */
	struct	mbuf *ppp_opack;	/* current mbuf being filled in */
	vjc_t	ppp_vjc;
};

/* FSM id numbers */
#define	FSM_LCP		0
#define	FSM_IPCP	1
#define	FSM_PAP		2

/* Option parsing result */
#define	OPT_OK		0
#define	OPT_REJ		1
#define	OPT_NAK		2
#define	OPT_FATAL	3

/*
 * Shorthand macros
 */
#define	Ppp_cmap	ppp_params.ppp_cmap
#define	Ppp_mru		ppp_params.ppp_mru
#define	Ppp_idletime	ppp_dflt.ppp_idletime
#define	Ppp_flags	ppp_params.ppp_flags
#define	Ppp_maxconf	ppp_dflt.ppp_maxconf
#define	Ppp_maxterm	ppp_dflt.ppp_maxterm
#define	Ppp_timeout	ppp_dflt.ppp_timeout
#define	Ppp_rxcmap	ppp_dflt.ppp_cmap

#define PPPMTU 1500		/* MTU for sync lines */

/*
 * Function prototypes
 * should be defined only in ppp_*.c!
 */
#if defined(KERNEL) && defined(PPP_ADDRESS)
#ifdef __STDC__
struct p2pcom;
#endif

/* ppp_frame.c */
extern int ppp_output __P((struct ifnet *, struct mbuf *, struct sockaddr *, struct rtentry *));
extern int ppp_input __P((struct p2pcom *, struct mbuf *));
extern void ppp_idlepoll __P((void *));
extern int ppp_hdr __P((struct p2pcom *, u_char *, int));

/* ppp_fsm.c */
extern struct mbuf *ppp_addopt __P((struct mbuf *, struct ppp_option *));
extern struct mbuf *ppp_cp_prepend __P((struct mbuf *, int, int, int, int));
extern void ppp_cp_in __P((struct p2pcom *, struct mbuf *, int));
extern void ppp_cp_timeout __P((struct p2pcom *, int));
extern void ppp_cp_up __P((struct p2pcom *, int));
extern void ppp_cp_down __P((struct p2pcom *, int));
extern void ppp_cp_close __P((struct p2pcom *, int));

/* ppp_lcp.c */
extern int ppp_ioctl __P((struct p2pcom *, int, caddr_t));
extern int ppp_init __P((struct p2pcom *));
extern void ppp_shutdown __P((struct p2pcom *));
extern void ppp_lcp_tlu __P((struct p2pcom *));
extern void ppp_lcp_tld __P((struct p2pcom *));
extern void ppp_lcp_timeout __P((void *));
extern struct mbuf *ppp_lcp_xcode __P((struct p2pcom *, struct mbuf *,
					struct ppp_cp_hdr *));
extern struct mbuf *ppp_lcp_creq __P((struct p2pcom *));
extern void ppp_lcp_optrej __P((struct p2pcom *, struct ppp_option *));
extern void ppp_lcp_optnak __P((struct p2pcom *, struct ppp_option *));
extern int ppp_lcp_opt __P((struct p2pcom *, struct ppp_option *));
extern void ppp_lcp_tlf __P((struct p2pcom *));
extern int ppp_modem __P((struct p2pcom *, int));
extern u_long ppp_lcp_magic __P((void));

/* ppp_ipcp.c */
extern void ppp_ipcp_timeout __P((void *));
extern void ppp_ipcp_tlf __P((struct p2pcom *));
extern void ppp_ipcp_tlu __P((struct p2pcom *));
extern struct mbuf *ppp_ipcp_creq __P((struct p2pcom *));
extern void ppp_ipcp_optrej __P((struct p2pcom *, struct ppp_option *));
extern void ppp_ipcp_optnak __P((struct p2pcom *, struct ppp_option *));
extern int ppp_ipcp_opt __P((struct p2pcom *, struct ppp_option *));

#ifdef PPP_DEBUG
#define	dprintf(x)	if (pp->p2p_if.if_flags & IFF_DEBUG) printf x
#else
#define	dprintf(x)
#endif /* !PPP_DEBUG */

#endif /* KERNEL */
