/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: if_tokensubr.c,v 2.1 1995/09/21 15:19:50 karels Exp $
 */

/*
 * Based on code from Roger Florkowski, which in turn
 * was based on net/if_ethersubr.c.
 */

/*
 * Copyright (c) 1982, 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <sys/mbuf.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <sys/syslog.h>

#include <machine/cpu.h>

#include <net/if.h>
#include <net/netisr.h>
#include <net/route.h>
#include <net/if_llc.h>
#include <net/if_dl.h>
#include <net/if_types.h>

#ifdef INET
#include <netinet/in.h>
#include <netinet/in_var.h>
#endif
#include <netinet/if_ether.h>
#include <net/if_token.h>

#ifdef NS
#include <netns/ns.h>
#include <netns/ns_if.h>
#endif

#ifdef ISO
#include <netiso/argo_debug.h>
#include <netiso/iso.h>
#include <netiso/iso_var.h>
#include <netiso/iso_snpac.h>
#endif

#ifdef LLC
#include <netccitt/dll.h>
#include <netccitt/llc_var.h>
#endif

#if defined(LLC) && defined(CCITT)
extern struct ifqueue pkintrq;
#endif

#ifdef INET
struct	llc llc_snap_ip;
struct	llc llc_snap_arp;
#endif
extern	struct ifnet loif;
#define senderr(e) { error = (e); goto bad;}

/*
 * Perform common duties while attaching to interface list
 */
void
token_attach(ifp)
	struct ifnet *ifp;
{
	register struct ifaddr *ifa;
	register struct sockaddr_dl *sdl;

	ifp->if_type = IFT_ISO88025;
	ifp->if_addrlen = ISO88025_ADDR_LEN;
	ifp->if_hdrlen = sizeof(struct token_header);	/* sometimes */
	ifp->if_mtu = ISO88025_MTU;
	ifp->if_output = token_output;
	if (max_linkhdr < ALIGN(sizeof(struct token_header) + LLC_SNAPLEN))
		max_linkhdr = ALIGN(sizeof(struct token_header) + LLC_SNAPLEN);

	if_attach(ifp);
	for (ifa = ifp->if_addrlist; ifa; ifa = ifa->ifa_next)
		if ((sdl = (struct sockaddr_dl *)ifa->ifa_addr) &&
		    sdl->sdl_family == AF_LINK) {
			sdl->sdl_alen = ifp->if_addrlen;
			bcopy((caddr_t)((struct arpcom *)ifp)->ac_enaddr,
			      LLADDR(sdl), ifp->if_addrlen);
			break;
		}

#ifdef INET
	/* construct prototype llc/snap header for IP */
	llc_snap_ip.llc_dsap = LLC_SNAP_LSAP;
	llc_snap_ip.llc_ssap = LLC_SNAP_LSAP;
	llc_snap_ip.llc_control = LLC_UI;
#if 0	/* this is in bss */
	llc_snap_ip.llc_org_code[0] = 0;
	llc_snap_ip.llc_org_code[1] = 0;
	llc_snap_ip.llc_org_code[2] = 0;
#endif
	llc_snap_ip.llc_ether_type = htons(ETHERTYPE_IP);

	/* construct prototype llc/snap header for ARP */
	llc_snap_arp = llc_snap_ip;
	llc_snap_arp.llc_ether_type = htons(ETHERTYPE_ARP);
#endif /* INET */
}

/*
 * generic token-ring output routine.
 * Encapsulate a packet of type family for the local net.
 * Assumes that ifp is actually pointer to arpcom structure.
 */
token_output(ifp, m0, dst, rt0)
        register struct ifnet *ifp;
        struct mbuf *m0;
        struct sockaddr *dst;
        struct rtentry *rt0;
{
        short type;
        int s, error = 0;
        u_char edst[24];	/* XXX room for hdwr address + routing bytes */
        struct in_addr idst;
        register struct mbuf *m = m0;
	register struct rtentry *rt;
        struct mbuf *mcopy = (struct mbuf *)0;
        u_int8_t rcf0 = 0, rcf1;
        register struct token_header *mac;
        register struct llc *llc;
        int i, ri_len, hdr_len;
	struct arpcom *ac = (struct arpcom *)ifp;

        if ((ifp->if_flags & (IFF_UP | IFF_RUNNING)) != (IFF_UP | IFF_RUNNING)) 
		senderr(ENETDOWN);
        ifp->if_lastchange = time;
	if (rt = rt0) {
		if ((rt->rt_flags & RTF_UP) == 0)
			if (rt0 = rt = rtalloc1(dst, 1))
				rt->rt_refcnt--;
			else 
				senderr(EHOSTUNREACH);
		if (rt->rt_flags & RTF_GATEWAY) {
			if (rt->rt_gwroute == 0)
				goto lookup;
			if (((rt = rt->rt_gwroute)->rt_flags & RTF_UP) == 0) {
				rtfree(rt); rt = rt0;
			lookup: rt->rt_gwroute = rtalloc1(rt->rt_gateway, 1);
				if ((rt = rt->rt_gwroute) == 0)
					senderr(EHOSTUNREACH);
			}
		}
		if (rt->rt_flags & RTF_REJECT)
			if (rt->rt_rmx.rmx_expire == 0 ||
			    time.tv_sec < rt->rt_rmx.rmx_expire)
				senderr(rt == rt0 ? EHOSTDOWN : EHOSTUNREACH);
	}

        switch (dst->sa_family) {

	case AF_LINK:
		break;

#ifdef INET
	case AF_INET:
		bzero((caddr_t)edst, sizeof(edst));	/* XXX why? */
		if (arpresolve(ac, rt, m, dst, edst) == 0)
			return (0);	/* if not yet resolved */
		/* If broadcasting on a simplex interface, loopback a copy */
		if ((m->m_flags & M_BCAST) && (ifp->if_flags & IFF_SIMPLEX))
			mcopy = m_copy(m, 0, (int)M_COPYALL);
                type = htons(ETHERTYPE_IP);

		/*
		 * routing info is stored with the hardware address.
		 */
		rcf0 = *(u_int8_t *)(edst + ISO88025_ADDR_LEN);
		rcf1 = *(u_int8_t *)(edst + ISO88025_ADDR_LEN + 1);
		
		/*
		 * set broadcast bits and frame size in rcf, if needed.
		 * XXX: frame size should not be limited to 2k
		 */
		if ((m->m_flags & M_BCAST) && (ifp->if_flags & IFF_ALLCAST)) {
			/* all rings broadcast */
			rcf0 = (sizeof(rcf0) + sizeof(rcf1)) |
			    RCF0_ALL_BROADCAST; 
			rcf1 = RCF_FRAME2;
                }

		/* Add token-ring header */
		ri_len = rcf0 ? (rcf0 & RCF0_LEN_MASK) : 0;
		hdr_len = sizeof(*mac) + ri_len + LLC_SNAPLEN;

		M_PREPEND(m, hdr_len, M_DONTWAIT);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}

		/* now fill the header */
		mac = mtod(m, struct token_header *);
		mac->token_acf = ACF_PRIORITY3;
		mac->token_fcf = FCF_LLC_FRAME;
		bcopy(edst, mac->token_dhost, ISO88025_ADDR_LEN);
		bcopy(ac->ac_enaddr, mac->token_shost, ISO88025_ADDR_LEN); 

		if (rcf0) {
#define	RCFLEN	(sizeof(rcf0) + sizeof(rcf1))
			struct token_rif *rif = (struct token_rif *)(mac + 1);

			mac->token_shost[0] |= RI_PRESENT;
			rif->rcf0 = rcf0;
			rif->rcf1 = rcf1;
			bcopy(edst + ISO88025_ADDR_LEN + RCFLEN, rif->rseg,
			    ri_len - RCFLEN);
		}
		bcopy(&llc_snap_ip, (caddr_t)mac + sizeof(*mac) + ri_len, 
			LLC_SNAPLEN);
		break;
#endif

	/* 
	 * we expect to be passed a *completed* header here (mac + llc) in
	 * a sockaddr_dl (actually sockaddr_dl_8025, which has enough room).
	 */
        case AF_UNSPEC:
	    {
		register caddr_t hdrp, hdrp2;

		hdrp = LLADDR((struct sockaddr_dl *) dst);
		hdr_len = ((struct sockaddr_dl *) dst)->sdl_alen;

		M_PREPEND(m, hdr_len, M_DONTWAIT);
		if (m == 0) {
		    error = ENOBUFS;
		    goto bad;
		}

		/* now fill the header */
		hdrp2 = mtod(m, caddr_t);
		bcopy(hdrp, hdrp2, hdr_len);
                break;
	    }

        default:
                printf("%s%d: can't handle af%d\n", ifp->if_name, ifp->if_unit,
                        dst->sa_family);
                error = EAFNOSUPPORT;
                goto bad;
	}

        /*
         * Queue message on interface, and start output if interface
         * not yet active.
         */
        s = splimp();
        if (IF_QFULL(&ifp->if_snd)) {
                IF_DROP(&ifp->if_snd);
                splx(s);
                error = ENOBUFS;
                goto bad;
        }
        IF_ENQUEUE(&ifp->if_snd, m);
        if ((ifp->if_flags & IFF_OACTIVE) == 0)
                (*ifp->if_start)(ifp);
        splx(s);
        if (mcopy)
                (void) looutput(&loif, mcopy, dst, rt);
        if (ETHER_IS_MULTICAST(edst))
                ifp->if_omcasts++;
        return (error);

bad:
        if (mcopy)
                m_freem(mcopy);
        if (m)
                m_freem(m);
	return (error);
}

/*
 * Process a received Token-ring packet;
 * the packet is in the mbuf chain m without
 * the ether header, which is provided separately.
 *
 * TODO: deal with test & XID requests, etc.
 */
void
token_input(ifp, m)
        struct ifnet *ifp;
        struct mbuf *m;
{
        struct token_header *mac;
        register struct ifqueue *inq;
        register struct llc *llc;
	int hdrlen;
        int s;

        if ((ifp->if_flags & IFF_UP) == 0) {
                m_freem(m);
                return;
        }
	mac = mtod(m, struct token_header *);
        ifp->if_lastchange = time;
	hdrlen = sizeof(*mac);
	if (HAS_ROUTE(mac))
		hdrlen += ROUTE_BYTES(mac);
        ifp->if_ibytes += m->m_pkthdr.len;
        if (bcmp((caddr_t)etherbroadcastaddr, (caddr_t)mac->token_dhost,
            sizeof(etherbroadcastaddr)) == 0)
                m->m_flags |= M_BCAST;
        else if (mac->token_dhost[0] & 1)
                m->m_flags |= M_MCAST;
        if (m->m_flags & (M_BCAST|M_MCAST))
                ifp->if_imcasts++;

	llc = (struct llc *)((caddr_t)mac + hdrlen);
	switch (llc->llc_dsap) {

	case LLC_SNAP_LSAP:

		switch (ntohs(llc->llc_ether_type)) {
#ifdef INET
		case ETHERTYPE_IP:
			m->m_data += hdrlen + LLC_SNAPLEN;
			m->m_len -= hdrlen + LLC_SNAPLEN;
			m->m_pkthdr.len -= hdrlen + LLC_SNAPLEN;
			schednetisr(NETISR_IP);
			inq = &ipintrq;
			break;

		case ETHERTYPE_ARP:
			schednetisr(NETISR_ARP);
			inq = &arpintrq;
			break;
#endif

		default:
			goto dropanyway;
		}
		break;

	default:
dropanyway:;
		m_freem(m);
		return;
	}

        s = splimp();
        if (IF_QFULL(inq)) {
                IF_DROP(inq);
                m_freem(m);
        } else 
                IF_ENQUEUE(inq, m);
        splx(s);
}
