/*	BSDI $Id: tty_conf.c,v 2.1 1995/02/03 07:54:26 polk Exp $	*/

/*-
 * Copyright (c) 1982, 1986, 1991, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)tty_conf.c	8.4 (Berkeley) 1/21/94
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/buf.h>
#include <sys/ioctl.h>
#include <sys/proc.h>
#include <sys/tty.h>
#include <sys/conf.h>

#undef nullioctl		/* want our own, not nullop */

#define	ttynodisc ((int (*) __P((dev_t, struct tty *)))enodev)
#define	ttyerrclose ((int (*) __P((struct tty *, int flags)))enodev)
#define	ttyerrio ((int (*) __P((struct tty *, struct uio *, int)))enodev)
#define	ttynoinput ((void (*) __P((int c, struct tty *)))nullop)
#define	ttyerrstart ((int (*) __P((struct tty *)))enodev)

int	nullioctl __P((struct tty *tp, int cmd, caddr_t data,
			int flag, struct proc *p));

#define	TERMIOS_DISC_INIT \
	{ ttyopen, ttylclose, ttread, ttwrite, nullioctl, \
	  ttyinput, ttstart, ttymodem }

#define	UNUSED_DISC_INIT \
	{ ttynodisc, ttyerrclose, ttyerrio, ttyerrio, nullioctl, \
	  ttynoinput, ttyerrstart, nullmodem }

#include "tb.h"
#if NTB > 0
int	tbopen __P((dev_t dev, struct tty *tp));
int	tbclose __P((struct tty *tp, int flags));
int	tbread __P((struct tty *, struct uio *, int flags));
int	tbioctl __P((struct tty *tp, int cmd, caddr_t data,
			int flag, struct proc *p));
void	tbinput __P((int c, struct tty *tp));

#define	TABLET_DISC_INIT \
	{ tbopen, tbclose, tbread, enodev, tbioctl, \
	  tbinput, ttstart, nullmodem }
#else
#define	TABLET_DISC_INIT UNUSED_DISC_INIT
#endif

#include "sl.h"
#if NSL > 0
int	slopen __P((dev_t dev, struct tty *tp));
int	slclose __P((struct tty *tp, int flags));
int	sltioctl __P((struct tty *tp, int cmd, caddr_t data,
			int flag, struct proc *p));
void	slinput __P((int c, struct tty *tp));
int	slstart __P((struct tty *tp));

#define	SLIP_DISC_INIT \
	{ slopen, slclose, ttyerrio, ttyerrio, sltioctl, \
	  slinput, slstart, nullmodem }
#else
#define	SLIP_DISC_INIT UNUSED_DISC_INIT
#endif

#ifdef PPP
#include "appp.h"
#endif
#if defined(PPP) && NAPPP > 0
int	apppopen __P((dev_t, struct tty *));
int	apppclose __P((struct tty *, int));
void	apppinput __P((int, struct tty *));
int	apppioctl __P((struct tty *, int, caddr_t, int, struct proc *));
int	apppstart __P((struct tty *));
int	apppmodem __P((struct tty *, int));

#define	PPP_DISC_INIT \
	{ apppopen, apppclose, ttyerrio, ttyerrio, apppioctl, \
	  apppinput, apppstart, apppmodem }
#else
#define	PPP_DISC_INIT UNUSED_DISC_INIT
#endif

struct	linesw linesw[] = {
	TERMIOS_DISC_INIT,		/* 0- termios */
	UNUSED_DISC_INIT,		/* 1- defunct */
	UNUSED_DISC_INIT,		/* 2- defunct */
	TABLET_DISC_INIT,		/* 3- TABLDISC */
	SLIP_DISC_INIT,			/* 4- SLIPDISC */
	PPP_DISC_INIT,			/* 5- PPPDISC */
};

int	nlinesw = sizeof (linesw) / sizeof (linesw[0]);

/*
 * Do nothing specific version of line
 * discipline specific ioctl command.
 */
/*ARGSUSED*/
nullioctl(tp, cmd, data, flags, p)
	struct tty *tp;
	int cmd;
	char *data;
	int flags;
	struct proc *p;
{

#ifdef lint
	tp = tp; data = data; flags = flags;
#endif
	return (-1);
}
