/*-
 * Copyright (c) 1992, 1993, 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: trapsupport.s,v 2.1 1995/02/03 07:49:33 polk Exp $
 */
 
/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	from: @(#)locore.s	7.3 (Berkeley) 5/13/91
 *	from NetBSD: Id: locore.s,v 1.12 1993/05/27 16:44:13 cgd Exp
 *
 *      @(#)locore.s	8.3 (Berkeley) 9/23/93
 */

/*
 * locore.s:	4BSD machine support for the Intel 386
 */
#define KERNEL
#include "i386/include/trap.h"
#undef KERNEL
#include "i386/i386/asm.h"

/*
 * start of stuff needed to handle traps
 * only in boot
 */

#define IDTVEC(name)    .align 4; .globl _X/**/name; _X/**/name:

#define TRAP(a)         pushl $(a) ; jmp alltraps

IDTVEC(div)
	pushl $0; TRAP(T_DIVIDE)
IDTVEC(dbg)
	pushl $0; TRAP(T_TRCTRAP)
IDTVEC(nmi)
	pushl $0; TRAP(T_NMI)
IDTVEC(bpt)
	pushl $0; TRAP(T_BPTFLT)
IDTVEC(ofl)
	pushl $0; TRAP(T_OFLOW)
IDTVEC(bnd)
	pushl $0; TRAP(T_BOUND)
IDTVEC(ill)
	pushl $0; TRAP(T_PRIVINFLT)
IDTVEC(dna)
	pushl $0; TRAP(T_DNA)
IDTVEC(fpusegm)
	pushl $0; TRAP(T_FPOPFLT)
IDTVEC(tss)
	TRAP(T_TSSFLT)
	/*PANIC("TSS not valid");*/
IDTVEC(missing)
	TRAP(T_SEGNPFLT)
IDTVEC(stk)
	TRAP(T_STKFLT)
IDTVEC(prot)
	TRAP(T_PROTFLT)
IDTVEC(page)
	TRAP(T_PAGEFLT)
IDTVEC(rsvd)
	pushl $0; TRAP(T_RESERVED_15)
IDTVEC(fpu)
	pushl $0; TRAP(T_ARITHTRAP)
IDTVEC(align)
	pushl $0; TRAP(T_ALIGNFLT)
	/* 18 - 31 reserved for future exp */
IDTVEC(rsvd1)
	pushl $0; TRAP(T_RESERVED_18)
IDTVEC(rsvd2)
	pushl $0; TRAP(T_RESERVED_19)
IDTVEC(rsvd3)
	pushl $0; TRAP(T_RESERVED_20)
IDTVEC(rsvd4)
	pushl $0; TRAP(T_RESERVED_21)
IDTVEC(rsvd5)
	pushl $0; TRAP(T_RESERVED_22)
IDTVEC(rsvd6)
	pushl $0; TRAP(T_RESERVED_23)
IDTVEC(rsvd7)
	pushl $0; TRAP(T_RESERVED_24)
IDTVEC(rsvd8)
	pushl $0; TRAP(T_RESERVED_25)
IDTVEC(rsvd9)
	pushl $0; TRAP(T_RESERVED_26)
IDTVEC(rsvd10)
	pushl $0; TRAP(T_RESERVED_27)
IDTVEC(rsvd11)
	pushl $0; TRAP(T_RESERVED_28)
IDTVEC(rsvd12)
	pushl $0; TRAP(T_RESERVED_29)
IDTVEC(rsvd13)
	pushl $0; TRAP(T_RESERVED_30)
IDTVEC(rsvd14)
	pushl $0; TRAP(T_RESERVED_31)

#define ALIGN32 .align 2        /* 2^2  = 4 */
	ALIGN32

alltraps:
	pushal
	nop
	push %ds
	push %es
	movw	$0x10,%ax
	movw	%ax,%ds
	movw	%ax,%es
calltrap:
	call	_trap
	pop %es
	pop %ds
	popal
	nop
	addl	$8,%esp			# pop type, code

	.globl _iret_from_trap
_iret_from_trap:
	iret

  
	/*
	 * int rcr2(void)
	 */

	ALIGN32
ENTRY(rcr2)
	movl    %cr2,%eax
	ret

	/* 
	 * void lidt(*idt, nidt);
	 * As with lgdt, this could take a "struct region_descriptor".
	 */
	.data
yyy:    .word   255
	.long   0
	.text
ENTRY(lidt)
	movl    4(%esp),%eax
	movl    %eax,yyy+2
	movl    8(%esp),%eax
	movw    %ax,yyy
	lidt    yyy 
	ret
         

	ALIGN32
ENTRY(flush486)
	.byte 0x0f, 0x09
	ret
