/*-
 * Copyright (c) 1992, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: srt0.s,v 2.3 1995/05/04 23:54:28 karels Exp $
 */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)srt0.c      8.1 (Berkeley) 6/11/93
 */

/*
 * Startup code for standalone system
 * Non-relocating version -- for programs which are loaded by boot
 * Relocating version for boot (-DBOOT)
 * Small version for second-stage boot (-DBOOT -DSMALL)
 */

#include <i386/include/cpu.h>
#include <i386/include/psl.h>
#include <i386/include/limits.h>
#include <sys/reboot.h>

#ifdef DEBUG
#define	DO_PUT_DELAY	/* debugging putchars and delay */
#define	DO_PUT		/* debugging putchars */
#else
#ifdef SMALL
#define	DO_PUT		/* debugging putchars */
#endif /* SMALL */
#endif /* DEBUG */

/* Warning, PUT and DEL trash %ecx */

#define CRT_MONO	(0xb0000+(24*80*2))	/* start of last line */
#define CRT_COLOR	(0xb8000+(24*80*2))	/* start of last line */

#ifdef DO_PUT
#ifdef DO_PUT_DELAY
#define	PUT(c,col) \
	movw	$(0x1f<<8)+(c),CRT_MONO+2*(col); \
	movw	$(0x1f<<8)+(c),CRT_COLOR+2*(col); \
	DEL(100000)
#else /* DO_PUT_DELAY */
#define	PUT(c,col) \
	movw	$(0x1f<<8)+(c),CRT_MONO+2*(col); \
	movw	$(0x1f<<8)+(c),CRT_COLOR+2*(col)
#endif /* DO_PUT_DELAY */

/* erase debugging PUT; assumes black background */
#define	UNPUT(col) \
	movw	$(0x07<<8)+0x20,CRT_MONO+2*(col); \
	movw	$(0x07<<8)+0x20,CRT_COLOR+2*(col)
#else /* DO_PUT */

#define	PUT(c,col)	/* void */
#define	UNPUT(col)	/* void */
#endif /* DO_PUT */

#define	DEL(n) \
	movl	$(n),%ecx; \
9:	outb	%al,$0x80; \
	loop	9b

	.globl	_end
	.globl	_edata
	.globl	_main
	.globl	_exit
	.globl	_bootdev
	.globl	_cyloffset
	.globl	_cpu

#ifdef BOOT
	.globl  __start			# artificial value for entry point
	.set    __start,LOADADR
#endif

#ifdef SMALL
	/* where the disklabel goes if we have one */
	.globl	_disklabel
_disklabel:
	.space 512
#endif

entry:	.globl	entry
	.globl	start

	PUT(0x47,0)		/* 'G' */

#if	defined(BOOT) && !defined(SMALL)

#define	KBDATA	0x60		/* kbd data port */
#define	KBSTAT	0x64		/* kbd status/cmd port */
#define	KBS_IFULL	0x02	/* kbd input buffer full, not ready */

#define	WAIT_IRDY \
1:	inb	$KBSTAT,%al; \
	andb	$KBS_IFULL,%al; \
	jnz	1b

	/* enable gate a20! yecchh!! */
	WAIT_IRDY
	movb	$0xd1,%al
	outb	%al,$KBSTAT
	WAIT_IRDY
	movb	$0xdf,%al
	outb	%al,$KBDATA

	/* send a NOP to 8042 to wait for A20 command to complete */
	WAIT_IRDY
	movb    $0xff,%al
	NOP
	outb    %al,$KBSTAT
	NOP
	WAIT_IRDY


	/* relocate program and enter at symbol "start" */

	# movl	$entry-RELOCADR,%esi	# from beginning of ram
	# movl	$entry,%edi		# to relocated area
	# movl	$_edata-RELOCADR,%ecx	# this much

	movl    $__start,%esi		# from load address
	movl    $RELOCADR,%edi		# to relocated area
	#movl    $64*1024,%ecx		# copy 64K (XXX should compute)
	leal	_edata,%ecx
	subl	$RELOCADR,%ecx		# amount to copy
	cld
	rep
	movsb

	#
	# Load up new GDT table
	#
	lgdt gdtarg

	# relocate program counter to relocation base
	pushl	$start
	ret
#endif

start:

	/* setup stack pointer */

#ifdef BOOT
	/*
	 * Copy our arguments to a safe place.
	 * Note that boot blocks don't use CALL.
	 */
#ifndef SMALL
	popl	%ecx		/* pop EIP word left by CALL */
#endif
	popl	%edx
	popl	%ebx
	popl	%eax
#ifdef SMALL
	movl	$LOADADR-4,%esp
#else
	/* copy boot parameters if present (bios disk parameters should be) */
	movl	%esp,%esi		# params should be at top of old stack
	movl	$RELOCADR-4,%esp	# new stack
	cmpl	$BOOT_MAGIC,B_MAGIC(%esi)
	jne	1f
	movl	B_LEN(%esi),%ecx	# length of parameters
	subl	%ecx,%esp		# make space on stack
	movl	%esp,%edi
	cld
	rep
	movsb
1:
#endif
	pushl	%eax
	pushl	%ebx
	pushl	%edx

#else /* BOOT */
	movl	8(%esp), %eax
	movl	%eax, _bootdev
	/* save old stack state */
	movl	%esp,savearea
	movl	%ebp,savearea+4
	/* movl	$SECONDLD-0x2400,%esp */	/* Why move sp? */
#endif /* BOOT */

	PUT(0x48,0)		/* 'H' */
#ifdef SMALL
	/* retrieve BIOS disk parameters before we trash too much */
	.globl	_getbiosgeom
	call	_getbiosgeom
#endif
	/* clear memory as needed */

	movl	%esp,%esi
#ifdef	BOOT

	/*
	 * Clear Bss and up to 64K heap
	 */
	movl	$64*1024,%ebx
	movl	$_end,%eax	# should be movl $_end-_edata but ...
	subl	$_edata,%eax
	addl	%ebx,%eax
	pushl	%eax
	pushl	$_edata
	call	_bzero

	/*
	 * Clear 64K of stack
	 */
	movl	%esi,%eax
	subl	%ebx,%eax
	subl	$5*4,%ebx
	pushl	%ebx
	pushl	%eax
	call	_bzero

	/* determine cpu type; default is CPU_386 */
	pushfl				# stuff EFLAGS on the stack
	popl	%eax			# so we can grab them into AX
	movl	%eax,%ecx		# save a copy of orig EFLAGS in CX
	orl	$PSL_AC,%eax		# set AC bit (on 486+)
	xorl	$PSL_ID,%eax		# toggle ID bit (Pentium+)
	pushl	%eax			# stuff new EFLAGS on the stack
	popfl				# so we can hand them to the processor
	pushfl				# have it push them on the stack
	popl	%eax			# and grab the new EFLAGS into AX
	pushl	%ecx			# restore original EFLAGS
	popfl
	testl	$PSL_AC,%eax		# see if AC bit stayed (only on 486+)
	jz	1f			# is this really a 386?
	movl	$CPU_486,_cpu		# no, must be a 486+
	/*
	 * Check the PSL_ID bit, which can be toggled on Pentium
	 * and newer 486 chips; if so, the cpuid instruction is supported.
	 */
	andl	$PSL_ID,%eax		# see if ID bit stayed (only on newer)
	andl	$PSL_ID,%ecx
	cmpl	%eax,%ecx		# see if ID bit toggled
	je	1f			# if no cpuid instruction, done

	/* try cpuid instruction, see what we get */
#define	cpuid	.byte 0x0f, 0xa2
	xorl	%eax,%eax		# input value to cpuid
	cpuid				# find highest input value supported
	cmpl	$1,%eax			# must be at least 1 (we want 1)
	jb	1f
	movl	$1,%eax			# input to cpuid: find ID
	cpuid
#if 0
	movl	%eax,_cpu_id		# family/model/stepping
	movl	%ebx,_cpu_id+4		# on Intel, "Genu" (G is low nibble)
	movl	%edx,_cpu_id+8		# on Intel, "ineI"
	movl	%ecx,_cpu_id+12		# on Intel, "ntel"
#endif
	andl	$0xf00,%eax		# extract family
	cmpl	$0x500,%eax		# family 5 is Pentium, 4 is 486
	jl	1f

	movl	$CPU_586,_cpu		# must be a Pentium or later
1:
#else
#if 0
	movl	$_edata,%edx
	movl	%esp,%eax
	subl	%edx,%eax
	pushl	%edx
	pushl	%esp
	call	_bzero
#endif
#endif
	movl	%esi,%esp
	PUT(0x49,0)		/* 'I' */

	pushl	$0
	popf

#ifndef	SMALL
	call	_cninit		/* initialize console */
#endif

	call	_main
	jmp	ret_from_main

	.globl	_erase_status_line
_erase_status_line:
	UNPUT(0)		/* ' ', erasing earlier debug char */
	ret

	.data
_bootdev:	.long	0
_cyloffset:	.long	0
_cpu:		.long	CPU_386
savearea:	.long	0,0	# sp & bp to return to

#if	!defined(SMALL) && defined(BOOT)
.globl	_gdt
gdtarg:
.short	 0x1f		/* see segment.c for size */
	.long _gdt
#endif

	.text

#ifdef BOOT
	.globl _reboot
/*
 * exit for bootstrap: reboot (which will wait for input
 * so any messages can be read, and we don't get into a reboot cycle).
 */
_exit:
ret_from_main:
	call	_reboot
	/* NOTREACHED */
#else
/* exit for standalone programs: return to bootstrap */
_exit:
	movl	4(%esp),%eax
ret_from_main:
	movl	savearea,%esp
	movl	savearea+4,%ebp
	ret
#endif

	.globl	_inb
_inb:	movl	4(%esp),%edx
	subl	%eax,%eax	# clr eax
	inb	%dx,%al
	ret

	.globl	_outb
_outb:	movl	4(%esp),%edx
	movl	8(%esp),%eax
	outb	%al,%dx
	ret

#ifndef SMALL
	.globl	_rtcin
_rtcin:	movl	4(%esp),%eax
	outb	%al,$0x70
	subl	%eax,%eax	# clr eax
	inb	$0x71,%al
	ret
#endif

	.globl ___udivsi3
___udivsi3:
	movl 4(%esp),%eax
	xorl %edx,%edx
	divl 8(%esp)
	ret

	.globl ___divsi3
___divsi3:
	movl 4(%esp),%eax
	xorl %edx,%edx
	cltd
	idivl 8(%esp)
	ret

	#
	# bzero (base,cnt)
	#

	.globl _bzero
_bzero:
	pushl	%edi
	movl	8(%esp),%edi
	movl	12(%esp),%ecx
	movb	$0x00,%al
	cld
	rep
	stosb
	popl	%edi
	ret

	#
	# bcopy (src,dst,cnt)
	# NOTE: does not (yet) handle overlapped copies
	#

	.globl	_bcopy
_bcopy:
	pushl	%esi
	pushl	%edi
	movl	12(%esp),%esi
	movl	16(%esp),%edi
	movl	20(%esp),%ecx
	cld
	rep
	movsb
	popl	%edi
	popl	%esi
	ret

	# insw(port,addr,cnt)
	.globl	_insw
_insw:
	pushl	%edi
	movw	8(%esp),%dx
	movl	12(%esp),%edi
	movl	16(%esp),%ecx
	cld
	.byte 0x66,0xf2,0x6d	# rep insw
	movl	%edi,%eax
	popl	%edi
	ret

	# outsw(port,addr,cnt)
	.globl	_outsw
_outsw:
	pushl	%esi
	movw	8(%esp),%dx
	movl	12(%esp),%esi
	movl	16(%esp),%ecx
	cld
	.byte 0x66,0xf2,0x6f	# rep outsw
	movl	%esi,%eax
	popl	%esi
	ret

