/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: setcons.c,v 2.2 1996/01/11 16:34:50 karels Exp $
 */

#include <sys/types.h>
#include <sys/reboot.h>

/*
 * This is logically a part of cons.c, but it is called only
 * in the boot program, and it calls addbootparam() in boot.c.
 */

extern	int comconsole;
extern	int comautosw, comauto;

void
setconsole(p)
	char *p;
{
	struct bootparam param;
	struct bootcons cons;

	bzero(&cons, sizeof(cons));
	if (strncmp(p, "auto", sizeof("auto") - 1) == 0) {
		/* switch kernel to com if boot did so */
		if (comauto && setcomconsole("com", &cons) == 0)
			goto doparam;
		return;
	}
	if (strncmp(p, "com", sizeof("com") - 1) == 0) {
		if (setcomconsole(p, &cons) == 0)
			goto doparam;
		return;
	}
	if (strncmp(p, "kbd", sizeof("kbd") - 1) == 0) {
		comautosw = 0;
		if (comconsole) {
			comconsole = 0;
			cninit();
		}
		cons.type = BOOTCONS_KBDISP;
		goto doparam;
	}
	printf("%s: not supported\n", p);
	return;

doparam:
	param.b_type = B_CONSOLE;
	param.b_len = sizeof(param) + sizeof(cons);
	addbootparam(&param, (void *)&cons);
}
