/*-
 * Copyright (c) 1992, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: kbd_reset.c,v 2.3 1995/12/01 03:27:48 karels Exp $
 */

/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)kbd.c	7.4 (Berkeley) 5/4/91
 */

#include <stand/stand.h>
#include <i386/isa/ic/i8042.h>

u_char inb();

#define	KBDATAP		0x60	/* kbd data port */
#define	KBSTATUSPORT	0x61	/* kbd status */
#define	KBSTATP		0x64	/* kbd status port */
#define	KBINRDY		0x01
#define	KBOUTRDY	0x02

int
kbdcninit()
{
	u_char c;
	int i = 100000;		/* about 1 sec with delay(10) below */

	/* Enable interrupts and keyboard controller */
	while (inb(KBSTATP) & KBOUTRDY)
		;
	outb(KBSTATP, KCMD_WCMD);
	while (inb(KBSTATP) & KBOUTRDY)
		;
	outb(KBDATAP, KBC_KBDXLATE|KBC_INHIBDIS|KBC_SYSTEM|KBC_ENABLEKBDI);

#ifndef	IBM_THINKPAD_KBD_BOTCH
	/* Start keyboard RESET */
	while (inb(KBSTATP) & KBOUTRDY)
		;	/* wait input ready */
	outb(KBDATAP, KCMD_RESET);

	while (((c = inb(KBDATAP)) != KBD_ACK && c != KBD_RESETOK) && i-- > 1)
		delay(10);
	if (c == KBD_ACK) {
		i = 100000;	/* up to 10 sec... */
		while ((inb(KBDATAP) != KBD_RESETOK) && i-- > 1)
			delay(100);
		if (i == 0) {
			printf("keyboard: timed out waiting for reset\n");
			i = 1;	/* Pretend it worked, we did get an ack. */
		}
	}
	if (i == 0)
		printf("no keyboard detected\n");
#endif
	return (i);
}
