/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: cons.c,v 2.4 1996/01/11 16:34:56 karels Exp $
 */

#include <sys/param.h>
#include <i386/isa/isa.h>
#include "stand.h"

int	comconsole = 0;
int	comautosw = 1;
static	int consinitdone = 0;
int	comauto;

void
putchar(c)
	int c;
{
	if (!consinitdone)
		cninit();

	if (c == '\n')
		putchar('\r');
	if (comconsole) {
		comcnputc(c);
		if (comauto)
			cgacnputc(c);
	} else
		cgacnputc(c);
}

#ifndef SMALL
int
cngetc()
{

	if (comconsole)
		return (comcngetc());
	else
		return (kbdcngetc());
}

int
cnpoll()
{

	if (comconsole)
		return (comcnpoll());
	else
		return (kbdcnpoll());
}
#endif

/*
 * Initialize console: choose one and initialize.
 * Enable auto switch to com if no keyboard
 * and com port has carrier.
 */
cninit()
{

	consinitdone = 1;
	if (comconsole)
		(void) comcninit();
	else if (!kbdcninit() && comautosw && bootdebug == 0 && comcninit()) {
		comconsole = 1;
		comauto = 1;
#ifndef SMALL
		printf("keyboard error, auto switch to com console\n");
		/* need to pass console option to kernel */
		/* ??? what if there is a -console directive in boot.default? */
#endif
	}
}
