/*-
 * Copyright (c) 1992, 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: conf.c,v 2.2 1996/01/11 16:37:31 karels Exp $
 */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)conf.c	8.2 (Berkeley) 1/21/94
 */

#include <stand/stand.h>

extern struct devsw wdops, fdops, biosops, sdops, srops;

/* host adapters -- these switch i_ops to &sdops */
extern struct devsw ahaops, eahaops;

/*
 * The "regular" block devices below agree with the kernel entries;
 * we overlay some of the character-only devices with standalone-only
 * devices (bios, aha, eaha).
 */
struct devsw *devsw[] = {
	&biosops,	/* 0 = disk via BIOS (floppy or hard) */
	&ahaops,	/* 1 = sd on aha; see ahaopen */
	&eahaops,	/* 2 = sd on eaha; see eahaopen */
	&wdops,		/* 3 = wd */
	NULL,		/* 4 = swapdev place holder */
	NULL,		/* 5 = pts place holder */
	NULL,		/* 6 = ptc place holder */
	NULL,		/* 7 = klog place holder */
	NULL,		/* 8 = com place holder */
	&fdops,		/* 9 = fd */
	NULL,		/* XXX 10 = QIC-02/QIC-36 tape */
	NULL,		/* 11 = rc place holder */
	NULL,		/* 12 = vga place holder */
	NULL,		/* 13 = pcaux place holder */
	NULL,		/* 14 = bpf place holder */
	NULL,		/* 15 = fd place holder */
	NULL,		/* 16 = vga place holder */
	NULL,		/* 17 = pccons place holder */
	&sdops,		/* 18 = sd */
	NULL,		/* XXX 19 = SCSI tape */
	NULL,		/* 20 */
	NULL,		/* 21 */
	NULL,		/* 22 */
	NULL,		/* 23 */
	NULL,		/* 24 */
	NULL,		/* 25 */
	NULL,		/* 26 */
	NULL,		/* 27 */
	NULL,		/* 28 */
	NULL,		/* 29 */
	NULL,		/* 30 */
	NULL,		/* 31 */
	NULL,		/* 32 */
	NULL,		/* 33 */
	&srops,		/* 34 = sr */
};

int	ndevs = (sizeof(devsw)/sizeof(devsw[0]));
