/*-
 * Copyright (c) 1994 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      $Id: bioscall.h,v 2.2 1995/02/22 21:55:33 cp Exp $
 */

#define	BIOS_BUFSIZE	0x1000

#ifndef LOCORE
union wordchar {
	struct highlow {
		u_char low;
		u_char high;
	} highlow;
	u_short word;
};


/*
 * The exact layout of this structure is assumed
 * by the code in bios_call.s.  Changes here must
 * be reflected there.
 */
struct bios_args {
	union	wordchar ba_wa;
	union	wordchar ba_wb;
	union	wordchar ba_wc;
	union	wordchar ba_wd;
	u_short	ba_es;		/* this field shouldn't be here */
	u_short	ba_di;		/* this field not currently used */
	u_short	ba_flags;
};

#define ba_ax ba_wa.word
#define ba_ah ba_wa.highlow.high
#define ba_al ba_wa.highlow.low

#define ba_bx ba_wb.word
#define ba_bh ba_wb.highlow.high
#define ba_bl ba_wb.highlow.low

#define ba_cx ba_wc.word
#define ba_ch ba_wc.highlow.high
#define ba_cl ba_wc.highlow.low

#define ba_dx ba_wd.word
#define ba_dh ba_wd.highlow.high
#define ba_dl ba_wd.highlow.low
#endif /* LOCORE */
