/*-
 * Copyright (c) 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: bios_call.s,v 2.4 1995/05/05 00:01:24 karels Exp $
 */

/*
 * The following to entry points are provided for:
 *
 * _bios_call()		Treat this as the actual function, we will relocate
 *			code here in bdopen()
 *
 * bios_call_reloc	Same value as bios_call(), but provides a nicer
 *			mechansim to relocate the code in bdopen()
 *
 * bios_call_start	This is where the assembler put the code, where we
 *			relocate from
 *
 * bios_call_end	This is all the farther that we have to relocate code
 *
 * bios_call_buffer	The bounce buffer for read/write data
 */

#define	LOCORE
#include "bioscall.h"

.globl	_bios_call_buffer
.set	_bios_call_buffer, BIOSCALL

#define BDINT_RELOC (BIOSCALL+BIOS_BUFSIZE+0x100)
#define SREG (BIOSCALL+BIOS_BUFSIZE)

.set	_bios_call_stack, BDINT_RELOC - 4

.globl	__bios_call
.set	__bios_call, BDINT_RELOC	/* Room for buffer + stack */

.globl	_bios_call_reloc
.set	_bios_call_reloc, BDINT_RELOC


.text
.align 2


.globl	_bios_call_start
_bios_call_start:
	pushl	%ebp
	movl	%esp, %ebp

	movl	$_bios_call_stack, %esp	/* Switch to stack in low memory */

	pusha				/* Save all the registers */

        movb	8(%ebp),%dl		/* interrupt number */
	movl	int_addr, %eax		/* address of int instruction + 1 */
	movb	%dl, (%eax)		/* stuff in interrupt */
        movl	12(%ebp),%ebp		/* pointer to argument list */
	pushl	%ebp

        movw	0(%ebp),%ax		
	pushw	%ax
        movw	2(%ebp),%bx
        movw	4(%ebp),%cx
        movw	6(%ebp),%dx
        movw	8(%ebp),%si		/* Acutally the ES argument */
	pushw	%si
	movw	10(%ebp),%di

	/*
	 * This is required for some devices.
	 * What actually is needed is that ebp must be an address under 64k.
	 */
	movl	%esp, %ebp

	/*
	 * Switch to use16 code segment.  I can't find anything in the
	 * Intel manuals that says you have to do this, but if you don't
	 * then it winds up in some kind of mutant 32 bit real mode
	 * after clearing the PE bit in cr0.
	 */
	.byte 0xea	/* ljmp switch_to_use16 */
	.long switch_to_use16 - _bios_call_start + __bios_call
	.word 0x18
switch_to_use16:

	/* turn off protected mode */
	movl	%cr0, %eax
	andb	$0xfe, %al
	movl	%eax, %cr0

	/* flush prefetch queue and load real mode cs */
	.byte 0xea	/* ljmp int_real */
	.word int_real - _bios_call_start + __bios_call
	.word 0
int_real:

	mov	%cs, %ax	
	mov	%ax, %ds
	mov	%ax, %ss
	pop	%es
	pop	%ax

	sti
int_instruction:
	int	$0
	cli
	
	.short 0x6667
	lgdt	gdtarg

	pushf
	push	%ax
	push	%es


	/* turn on protected mode */
	smsw	%ax
	orb	$1,%al
	lmsw	%ax

	/* flush prefetch queue and load %cs */
	.byte 0xea	/* ljmp	prot */
	.word prot - _bios_call_start + __bios_call
	.word 8
prot:

	/*
	 * Restore ds, es and ss to their index values
	 */
        movl    $0x10,%eax
        movl    %ax,%ds
        movl    %ax,%es
        movl    %ax,%ss

	popw	%si
	popw	%ax			
	popfw
	popl	%ebp
	pushfw
	movw	%ax,0(%ebp)
        movw	%bx,2(%ebp)
        movw	%cx,4(%ebp)
        movw	%dx,6(%ebp)
        movw	%si,8(%ebp)
        movw	%di,10(%ebp)
	popw	%ax
	movw	%ax,12(%ebp)		/* flags */
	popa
	leave
	ret
int_addr:
	.long int_instruction - _bios_call_start + __bios_call + 1
scratch:
	.word 0

.globl _gdt
gdtarg:
	.short	0x1f		/* see size in segment.c */
	.long	_gdt
	
.globl	_bios_call_end
_bios_call_end:
