/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: pci.h,v 2.6 1995/12/01 22:45:44 cp Exp $
 */

/*
 * PCI
 */

/* 
 * Definitions needed to talk to PCI configuration mechanism 1.
 */
#define	PCI_M1_CAR	0x0cf8	/* Configuration space address register */
#define	PCI_M1_CDR	0x0cfc	/* Configuration space data register */

#define	PCI_M1_CM	0x80000000
#define	PCI_M1_BUS_S	16
#define	PCI_M1_AGENT_S	11
#define	PCI_M1_FN_S	8
#define	PCI_M1_OFFSET_M 0xfc

/* 
 * Definitions needed to talk to PCI configuration mechanism 2.
 */
#define	PCI_M2_CSE	0x0cf8	/* Configuration space enable register */
#define	PCI_M2_FORW	0x0cfa	/* Forward register */

#define	PCI_M2_CM	0x80	/* configuration mode */
#define	PCI_M2_FN_S	1
#define	PCI_M2_FN_M	0xe0
#define	PCI_M2_CBP	0xc000	/* configuration base port */
#define	PCI_M2_AGENT_S	8

/* 
 * Offsets into standard part of a devices pci configuration address space.
 */
#define	PCI_VENDOR_ID	0x00
#define	PCI_DEVICE_ID	0x02
#define	PCI_COMMAND	0x04
#define	PCI_REVISION_ID	0x08
#define	PCI_CLASSCODE_L	0x09		/* low order byte of class code */
#define	PCI_CLASSCODE_H	0x0a		/* high 16 bits of class code */
#define	PCI_LATENCY	0x0f
#define	PCI_MEMORY_BA	0x14
#define	PCI_PORT_BA	0x10
#define	PCI_I_PIN	0x3d
#define	PCI_I_LINE	0x3c

/*
 * Structure used to define a pci configuration address.
 * This structure is typically treated as opaque by the
 * various drivers though there is no real reason they
 * shouldn't look in it if need be.
 */
typedef struct pci_devaddr {
	u_char		d_bus;
	u_char		d_agent;
	u_char		d_function;
} pci_devaddr_t;

/* 
 * Define size of various pieces of pci configuration address
 */
#define	PCI_M2_AGENTS	16		/* 16 mechanism 2 agents */
#define	PCI_M1_AGENTS	32		/* 32 mechanism 2 agents */
#define	PCI_FUNCTIONS	8
#define	PCI_BUSES	256

extern int pci_log2_burstsize;

u_char	pci_inb __P((pci_devaddr_t *, u_char offset));
u_short	pci_inw __P((pci_devaddr_t *, u_char offset));
u_long	pci_inl __P((pci_devaddr_t *, u_char offset));
void	pci_outb __P((pci_devaddr_t *, u_char offset, u_char value));
void	pci_outw __P((pci_devaddr_t *, u_char offset, u_short value));
void	pci_outl __P((pci_devaddr_t *, u_char offset, u_long value));
pci_devaddr_t *pci_scan __P((int (*matcher)(pci_devaddr_t*)));
