/*
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: ncrreg.h,v 2.2 1995/08/01 22:09:35 cp Exp $
 */

#define MEM2CONFIG	0x80	/* memory address 2 config space address */

#define SCNTL0		0x00
#define SCNTL1		0x01
#define SCNTL2		0x02
#define SCNTL3		0x03
#define SCID		0x04
#define SXFER		0x05
#define SDID		0x06
#define	GPREG		0x07
#define	SFBR		0x08
#define	SOCL		0x09
#define SSID		0x0a
#define SBCL		0x0b
#define DSTAT		0x0c
#define SSTAT0		0x0d
#define SSTAT1		0x0e
#define SSTAT2		0x0f
#define DSA		0x10
#define ISTAT		0x14
#define CTEST0		0x18
#define CTEST1		0x19
#define CTEST2		0x1a
#define CTEST3		0x1b
#define TEMP		0x1c
#define DFIFO		0x20
#define CTEST4		0x21
#define CTEST5		0x22
#define CTEST6		0x23
#define DBC		0x24
#define DCMD		0x27
#define DNAD		0x28
#define DSP		0x2C
#define DSPS		0x30
#define SCRATCHA	0x34
#define	DMODE		0x38
#define DIEN		0x39
#define DWT		0x3a
#define DCNTL		0x3b
#define ADDER		0x3c
#define SIEN0		0x40
#define SIEN1		0x41
#define SIST0		0x42
#define SIST1		0x43
#define SLPAR		0x44
#define SWIDE		0x45
#define MACNTL		0x46
#define GPCNTL		0x47
#define STIME0		0x48
#define STIME1		0x49
#define RESPID0		0x4a
#define RESPID1		0x4b
#define STEST0		0x4c
#define STEST1		0x4d
#define STEST2		0x4e
#define STEST3		0x4f
#define SIDL		0x50
#define SODL		0x54
#define SBDL		0x58
#define SCRATCHB	0x5c

typedef struct ncr_io {
	u_char	io_scntl0;		/* scsi control 0 */
	u_char	io_scntl1;		/* scsi control 1 */
	u_char	io_scntl2;		/* scsi control 2 */
	u_char	io_scntl3;		/* scsi control 3 */

	u_char	io_scid;
	u_char	io_sxfer;
	u_char	io_sdid;
	u_char	io_gpreg;

	u_char	io_sfbr;
	u_char	io_socl;
	u_char	io_ssid;
	u_char	io_sbcl;

	u_char	io_dstat;
	u_char	io_sstat0;
	u_char	io_sstat1;
	u_char	io_sstat2;

	u_long	io_dsa;

	u_char	io_istat;
	u_char	io_reserved1[3];

	u_char	io_ctest0;
	u_char	io_ctest1;
	u_char	io_ctest2;
	u_char	io_ctest3;

	u_long	io_temp;

	u_char	io_dfifo:7;
	u_char	io_dfifo_res:1;
	u_char	io_ctest4;
	u_char	io_ctest5;
	u_char	io_ctest6;

	u_int	io_dbc:24;
	u_int	io_dcmd:8;

	u_long	io_dnad;
	u_long	io_dsp;
	u_long	io_dsps;
	u_long	io_scratcha;

	u_char	io_dmode;
	u_char	io_dien;
	u_char	io_dwt;
	u_char	io_dcntl;

	u_long	io_adder;

	u_char	io_sien0;
	u_char	io_sien1;
	u_char	io_sist0;
	u_char	io_sist1;

	u_char	io_slpar;
	u_char  io_swide;
	u_char	io_macntl;
	u_char	io_gpcntl;

	u_char	io_stime0;
	u_char	io_stime1;
	u_char	io_respid0;
	u_char	io_respid1;

	u_char	io_stest0;
	u_char	io_stest1;
	u_char	io_stest2;
	u_char	io_stest3;

	u_char	io_sidl;
	u_char	io_reserved4[3];

	u_char	io_sodl;
	u_char	io_reserved5[3];

	u_char	io_sbdl;
	u_char	io_reserved6[3];

	u_long	io_scratchb;
} volatile ncr_io_t;

/* scntl0	default 1 1 0 0 0 x 0 0*/
#define NCR_ARB1	0x80	/* B1 and B0 off simple arbitration */
#define NCR_ARB0	0x40	/* Both on full arbitration */
#define	NCR_START	0x20	/* Start arbitration */
#define NCR_WATN	0x10	/* Select with SATN on a start sequence */
#define NCR_EPC		0x08	/* Enable parity checking */
	/*		0x02	   Reserved */
#define NCR_AAP		0x02	/* Assert SATN on parity error */
#define NCR_TRG		0x01	/* Target mode 0 is initiator mode */

/* scntl1	default 0 0 0 0 0 0 0 0 */
#define	NCR_EXC		0x80	/* Extra clock cycle of data setup */
#define NCR_ADB		0x40	/* Assert SCSI data bus */
#define NCR_DHP		0x20	/* Disable halt on parity error or atn */
#define	NCR_CON		0x10	/* Connected */
#define NCR_ARST	0x08	/* Assert SCSI RST signal */
#define NCR_AESP	0x04	/* Assert even SCSI parity */
#define NCR_IARB	0x02	/* Immediate Arbitration */
#define NCR_SST		0x01	/* Start scsi transfer */

/* scntl2	default 0 x x x x x x x */
#define NCR_SDU		0x80	/* SCSI Disconnect Unexpected */

/* scntl3	default x 0 0 0 x 0 0 0 */
#define NCR_SCF_M	0x70	/* Synchronous Clock Conversion Factor */
#define NCR_SCF_S	4
#define NCR_CCF_M	0x07	/* Clock Conversion Factor */
#define NCR_CCF_S	0

/* scid 	default	x 0 0 x x 0 0 0 */
#define NCR_RRE		0x40	/* Enable Response to Reselection */
#define NCR_SRE		0x20	/* Enable Response to Selection */
				/* low three bits are incoded scsi id */

/* sxfer	default 0 0 0 x 0 0 0 0 */
#define NCR_TP_M	0xe0	/* SCSI Synchronous Transfer Period */
#define NCR_TP_S	5
#define NCR_MO_M	0x0f	/* Max SCSI synchronous offset */	
#define NCR_MO_S	0	/* 0 = async 8 largest legal value */

/* sdid		default x x x x x 0 0 0		scsi destination id */
				/* low order thre bits are inteded target */

/* socl 	default 0 0 0 0 0 0 0 0		SCSI output control latch */
/* sbcl 	default x x x x x x x x		SCSI Bus Control Lines (RO) */
#define NCR_REQ		0x80	/* Assert SCSI REQ signal */
#define NCR_ACK		0x40	/* Assert SCSI ACK signal */
#define NCR_BSY		0x20	/* Assert SCSI BSY signal */
#define NCR_SEL		0x10	/* Assert SCSI SEL signal */
#define NCR_ATN		0x08	/* Assert SCSI ATN signal */
#define NCR_MSG		0x04	/* Assert SCSI MSG signal */
#define NCR_CTL		0x02	/* Assert SCSI CTL signal */
#define NCR_IO		0x01	/* Assert SCSI IO signal */

/* dstat	default 1 0 0 0 0 0 x 0		DMA STATUS (RO) */
#define NCR_DFE		0x80	/* DMA FIFO empty */
#define NCR_MDPE	0x40	/* Master Data Parity Error */
#define NCR_BF		0x20	/* Bus Fault */
#define NCR_ABRT	0x10	/* Aborted */
#define NCR_SSI		0x08	/* Single step interrupt */
#define NCR_SIR		0x04	/* SCRIPTS interrupt instruction received */
#define NCR_IID		0x01	/* Illegal instruction detected */

/* sstat0	default 0 0 0 0 0 0 0 0		SCSI status 0 (RO) */
#define NCR_ILF		0x80	/* SIDL	full */
#define NCR_ORF		0x40	/* SODR full */
#define NCR_OLF		0x20	/* OLF	full */
#define NCR_AIF		0x10	/* Aribtration in progress */
#define NCR_LOA		0x08	/* Lost arbitration */
#define NCR_WOA		0x04	/* Won arbitration */
#define NCR_RST		0x02	/* Current SCSI reset signal */
#define NCR_SDP		0x01	/* Current SCSI parity signal */

/* sstat1	default	0 0 0 0 x x x x 	SCSI status 1 (RO) */
#define NCR_FF_M	0xf0	/* FIFO flags - really byte/word count */
#define NCR_FF_S	4
#define NCR_SDPL	0x80	/* Latched SCSI parity */
				/* low order 3 bits from sbcl */

/* sstat2	default x x x x x x 1 x		SCSI status 2 (RO) */
#define NCR_LDSC	0x02	/* last disconnect */

/* istat	default 0 0 0 0 0 0 0 0		Interrupt status */
#define NCR_IABRT	0x80	/* Abort operation */
#define NCR_ISRST	0x40	/* Software reset */
#define NCR_ISIGP	0x20	/* Signal process */
#define NCR_ISEM	0x10	/* Semaphore */
#define NCR_ICON	0x08	/* Connected */
#define NCR_INTF	0x04	/* Interrupt on the fly */
#define NCR_ISIP	0x02	/* SCSI interrupt pending */
#define NCR_IDMA	0x01	/* DMA interrupt pending */

/* ctest1	default 1 1 1 1 0 0 0 0		chip test 1 (RO) */
#define NCR_FMT3	0x80	/* fifo byte lane 3 empty */
#define NCR_FMT2	0x40	/* fifo byte lane 2 empty */
#define NCR_FMT1	0x20	/* fifo byte lane 1 empty */
#define NCR_FMT0	0x10	/* fifo byte lane 0 empty */
#define NCR_FFL3	0x08	/* fifo byte lane 3 full */
#define NCR_FFL2	0x08	/* fifo byte lane 2 full */
#define NCR_FFL1	0x08	/* fifo byte lane 1 full */
#define NCR_FFL0	0x08	/* fifo byte lane 0 full */

/* ctest2	default 0 0 x x 0 0 0 1		chip test 2 (RO) */
#define NCR_DDIR	0x80	/* Data Transfer Direction */
#define NCR_SIGP	0x40	/* Signal Process */
#define NCR_CIO		0x20	/* Configured as IO */
#define NCR_CM		0x10	/* Configured as Memory */
#define NCR_TEOP	0x40	/* SCSI true end of process */
#define NCR_DREQ	0x20	/* Data request status */
#define NCR_DACK	0x10	/* Data acknowledge status */

/* ctest3	default x x x x 0 0 0 1		chip test 3 */
#define NCR_V_M		0xf0	/* Chip revision level docs for version 1 */
#define NCR_V_S		4
#define	NCR_FLF		0x08	/* Flush DMA FIFO */
#define NCR_CLF		0x04	/* Clear DMA FIFO */
#define NCR_FM		0x02	/* Fetch pin mode */

/* DFIFO	default x 0 0 0 0 0 0 0		DMA FIFO */
#define NCR_BO_M	0x7f	/* Byte offset Counter */

/* ctest4	default	0 0 0 0 0 0 0 0		chipt test 4 */
#define NCR_BDIS	0x80	/* Burst Disable */
#define NCR_ZMOD	0x40	/* High impedance mode */
#define NCR_ZSD		0x20	/* SCSI Data High Impedance */
#define NCR_SRTM	0x10	/* Shadow Register Test Mode */
#define NCR_MPEE	0x08	/* Master Parity Error Enable */
#define NCR_FBL_M	0x03	/* FIFO byte control */
#define NCR_FBL_S	0

/* ctest5	default 0 0 x 0 0 x x x 	*/
#define	NCR_ADCK	0x80	/* Clock address incrementor */
#define NCR_BBCK	0x40	/* Clock byte counter */
#define NCR_MASR	0x10	/* Master control for set or reset pulsed */
#define NCR_DDIR	0x80	/* DMA direction */

/* dmode	default 0 0 0 0 0 x x 0		DMA mode */
#define NCR_BL_M	0xc0	/* Burst length */
#define NCR_BL_S	6
#define NCR_SIOM	0x20	/* Source I/O-Memory Enable */
#define NCR_DIOM	0x10	/* Destination I/O-Memory Enable */
#define NCR_ERL		0x08	/* Enable Read line */
#define NCR_MAN		0x01	/* Manual Start Mode */

/* dien		default x 0 0 0 0 0 x 0		dma interrupt enable */
/* same as dstat */

/* dcntl	default x x x 0 0 0 x 0		DMA Control  */
#define NCR_SSM		0x10	/* single step mode */
#define NCR_IRQM	0x08	/* IRQ Mode */
#define NCR_STD		0x04	/* Start DMA operation */
#define NCR_COM		0x01	/* 53C700 compatatility */

/* sien0	default 0 0 0 0 0 0 0 0		SCSI Interrupt 0 */
#define NCR_PMM		0x80	/* Phase mismatch */
#define NCR_CMP		0x40	/* arbitration and selection complete */
#define NCR_SELECTED	0x20	/* the n53 has been selected */
#define NCR_RSL		0x10	/* the n53 has been reselected */
#define NCR_SGE		0x08	/* SCSI Gross Error */
#define NCR_UDC		0x04	/* Unexpected Disconnect */
#define NCR_RST		0x02	/* SCSI Reset condition */
#define NCR_PAR		0x01	/* SCSI parity error */

/* sien1	default 0 0 0 0 0 0 0 0		SCSI Interrupt 1 */
#define NCR_STO		0x04	/* Selection Time out */
#define NCR_GEN		0x02	/* General Purpose Timer Expired */
#define NCR_HTH		0x01	/* Handshake to Handshake tiemr Expired */
/* sist0 same as sien0 */
/* sist1 same as sien1 */

/* macntl	default 0 0 0 0 0 0 0 0		Memory access control */
#define	NCR_TYP_M	0xf0	/* Chip type */
#define NCR_TYP_S	4
#define NCR_DWR		0x08	/* DataWR  is a local memory access */
#define NCR_DRD		0x04	/* DataRD  is a local memory access */
#define NCR_PSCPT	0x02	/* Pointer SCRIPTS is a local memory access */
#define NCR_SCRIPTS	0x01	/* SCRIPTS fetch is a local memory access */

/* gpcntl	default 0 0 x x x x 1 1		General Purpose Pin Control */
#define NCR_ME		0x80	/* Master Enable */
#define NCR_FE		0x40	/* Fetch enable */
#define NCR_GPIO1_EN	0x02	/* GPIO1 Enable */
#define NCR_GPIO0_EN	0x01	/* GPIO0 Enable */
#define NCR_HTH_M	0xf8	/* Handshake to Handshake timer period */
#define NCR_HTH_S	3
#define NCR_SEL_M	0x07	/* Selection time out */
#define NCR_SEL_S	0

/* stime1	default x x x x 0 0 0 0		scsi timer register one */
#define NCR_GEN_M	0x0f	/* General Purpose timer period */
#define NCR_GEN_S	0

/* stest0	default x x x x 0 x 1 1		scsi test register 0 */
#define NCR_SLT		0x08	/* Selection Response Logic Test */
#define NCR_ART		0x04	/* Arbitration Priority Encoder Test */
#define NCR_SOZ		0x02	/* SCSI Synchronous Offset Zero */
#define NCR_SOM		0x01	/* SCSI Synchronous Offset Maximum */

/* stest 1	default 0 x x x x x x x		SCSI test register 1 */
#define NCR_SCLK	0x80	/* SCLK */

/* stest2	default 0 0 x 0 0 0 0 0		SCSI test register 2 */
#define NCR_SCE		0x80	/* SCSI Control Enable */
#define NCR_ROF		0x40	/* Reset SCSI Offset */
#define NCR_SLB		0x10	/* SCSI Loopback Mode */
#define NCR_SZM		0x08	/* SCSI High-Impedance Mode */
#define NCR_EXT		0x02	/* Extended SREQ/SACK filtering */
#define NCR_LOW		0x01	/* SCSI Low level Mode */

/* stest3	default 0 0 0 0 x 0 0 0		SCSI test register 3 */
#define NCR_TE		0x80	/* TolerANT Enable */
#define NCR_STR		0x40	/* SCSI FIFO Test Read */
#define NCR_HSC		0x20	/* Halt SCSI Clock */
#define NCR_DSI		0x10	/* Disable Single Initiator Responce */
#define NCR_TTM		0x04	/* Timer Test Mode */
#define NCR_CSF		0x02	/* Clear SCSI FIFO */
#define NCR_STW		0x01	/* SCSI FIFO Test Write */

/*
 * start of stuff which pertains to scripts
 */
#define NCR_PHASE_DO		0x0	/* Data out */
#define NCR_PHASE_DI		0x1	/* Data in */
#define NCR_PHASE_CMD		0x2	/* Cmd */
#define NCR_PHASE_STATUS	0x3	/* Status */
#define NCR_PHASE_MO		0x6	/* Message out */
#define NCR_PHASE_MI		0x7	/* Message in */

#define NCR_IO_SELECT		0x0
#define NCR_IO_DISCONNECT	0x1	/* Wait Disconnect */
#define NCR_IO_RESELECT		0x2
#define NCR_IO_SET		0x3	/* Set */
#define NCR_IO_CLEAR		0x4	/* Clear */

#define NCR_IO_DIRECT		0
#define NCR_IO_TABLE_INDIRECT	1
#define NCR_IO_RELATIVE		2
#define NCR_IO_TABLE_RELATIVE	3

#define NCR_RW_LD		0
#define NCR_RW_OR		1
#define NCR_RW_AND		2
#define NCR_RW_ADD		3

#define NCR_RW_RMW		0x7
#define NCR_RW_FROMSFBR		0x5
#define NCR_RW_TOSFBR		0x6

#define NCR_TC_JUMP		0x0
#define NCR_TC_CALL		0x1
#define NCR_TC_RETURN		0x2
#define NCR_TC_INTERRUPT	0x3

typedef struct ncr_bmte {		/* block move table entry */
	u_int		bm_count :24;
	u_int		bm_stop  :8;
	vm_offset_t	bm_addr;
} ncr_bmte_t;

typedef struct ncr_srte {
	u_char		sr_f1;
	u_char		sr_sxfer;
	u_char		sr_id;
	u_char		sr_scntl3;
} ncr_srte_t;

