/*
 * Copyright (c) 1992, 1993 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *      BSDI $Id: pcconstab.FR,v 2.1 1995/02/03 07:42:52 polk Exp $
 */

/*-
 * Copyright (c) 1992 Dirk Husemann, University of Erlangen-Nurnberg,
 * Germany. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      Erlangen-Nuremberg, Germany.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 *      French (FR) Keyboard mapping tables
 *	received from jt@ratp.fr
 */

/*
 * Accented key table. 
 * when a key is entered that may be accented (action ACCENTED),
 * its entry gives us an index into the accented key table.
 * Each key has a group of entries, indexed by these values
 * (0 is unaccented).  Thus we have 3 adjacent entries for each key:
 * unaccented, circumflex, trema
 */
#define	M_CIRCUMFLEX	1
#define	M_TREMA		2

int maxaccent = M_TREMA;

struct key accenttab[] = {
#define	ACCENT_A	0
/* 10 */ KMALPHA('a',   'A',    001,    001),	/* unaccented */
/* 10 */ KMALPHA(0203,  'A',    001,    001),	/* circumflex */
/* 10 */ KMALPHA(0204,  'A',    001,    001),	/* trema */

#define	ACCENT_E	3
/* 12 */ KMALPHA('e',   'E',    005,    005),	/* unaccented */
/* 12 */ KMALPHA(0210,  'E',    005,    005),	/* circumflex */
/* 12 */ KMALPHA(0211,  'E',    005,    005),	/* trema */

#define	ACCENT_U	6
/* 16 */ KMALPHA('u',   'U',    025,    025),	/* unaccented */
/* 16 */ KMALPHA(0226,  'U',    025,    025),	/* circumflex */
/* 16 */ KMALPHA(0201,  'U',    025,    025),	/* trema */

#define	ACCENT_I	9
/* 17 */ KMALPHA('i',   'I',    011,    011),	/* unaccented */
/* 17 */ KMALPHA(0214,  'I',    011,    011),	/* circumflex */
/* 17 */ KMALPHA(0213,  'I',    011,    011),	/* trema */

#define	ACCENT_O	12
/* 18 */ KMALPHA('o',   'O',    017,    017),	/* unaccented */
/* 18 */ KMALPHA(0223,  'O',    017,    017),	/* circumflex */
/* 18 */ KMALPHA(0224,  'O',    017,    017),	/* trema */

#define	ACCENT_SPACE	15
/* 39 */ KMCHAR(' ',	' ',	000,	000),		/* unaccented */
/* 39 */ KCONST(0136),		/* circumflex */
/* 39 */ KMCHAR(' ',	' ',	000,	000),		/* no trema */
};

struct key pcconstab[] = {
/* 00 */ KNULL,
/* 01 */ KCONST(033),
/* 02 */ KMCHAR('&',    '1',    '&',    '1'),
/* 03 */ KCHAR(0202,    '2',    000,    000,    '~',    '~',    000,    000),
/* 04 */ KCHAR('"',     '3',    '"',    '3',    '#',    '#',    '"',    '3'),
/* 05 */ KCHAR('\'',    '4',    '\'',   '4',    '{',    '{',    '\'',   '3'),
/* 06 */ KCHAR('(',     '5',    '(',    '5',    '[',    '[',    033,    033),
/* 07 */ KCHAR('-',     '6',    '-',    '6',    '|',    '|',    000,    000),
/* 08 */ KCHAR(0212,    '7',    0212,   '7',    '`',    '`',    0212,   0212),
/* 09 */ KCHAR('_',     '8',    '_',    '8',    '\\',   '\\',   034,    034),
/* 0a */ KCHAR(0207,    '9',    0207,   '9',    '^',    '^',    036,    036),
/* 0b */ KCHAR(0205,    '0',    0205,   '0',    '@',    '@',    000,    000),
/* 0c */ KCHAR(')',     0370,   ')',    0370,   ']',    ']',    035,    035),
/* 0d */ KCHAR('=',     '+',    '=',    '+',    '}',    '}',    '}',    '}'),
/* 0e */ KMCHAR(010,    010,    034,    034),
/* 0f */ KMCHAR('\t',   '\t',   '\177', '\177'),
/* 10 */ KACCENTED(ACCENT_A),
/* 11 */ KMALPHA('z',   'Z',    032,    032),
/* 12 */ KACCENTED(ACCENT_E),
/* 13 */ KMALPHA('r',   'R',    022,    022),
/* 14 */ KMALPHA('t',   'T',    024,    024),
/* 15 */ KMALPHA('y',   'Y',    031,    031),
/* 16 */ KACCENTED(ACCENT_U),
/* 17 */ KACCENTED(ACCENT_I),
/* 18 */ KACCENTED(ACCENT_O),
/* 19 */ KMALPHA('p',   'P',    020,    020),
/* 1a */ KACCENT(M_CIRCUMFLEX, M_TREMA, M_CIRCUMFLEX, M_TREMA,
		 M_CIRCUMFLEX, M_TREMA, M_CIRCUMFLEX, M_TREMA),
/* 1b */ KCHAR('$',     0234,   '$',    0234,   0317,   0317,   0000,   0000),
/* 1c */ KMCHAR('\r',   '\r',   '\r',   '\r'),
/* 1d */ KCTL,
/* 1e */ KMALPHA('q',   'Q',    021,    021),
/* 1f */ KMALPHA('s',   'S',    023,    023),
/* 20 */ KMALPHA('d',   'D',    004,    004),
/* 21 */ KMALPHA('f',   'F',    006,    006),
/* 22 */ KMALPHA('g',   'G',    007,    007),
/* 23 */ KMALPHA('h',   'H',    010,    010),
/* 24 */ KMALPHA('j',   'J',    012,    012),
/* 25 */ KMALPHA('k',   'K',    013,    013),
/* 26 */ KMALPHA('l',   'L',    014,    014),
/* 27 */ KMALPHA('m',   'M',    015,    015),
/* 28 */ KMCHAR(0227,   '%',    0227,   '%'),
/* 29 */ KMCHAR(0375,   0,      0375,   0),
/* 2a */ KSHF,
/* 2b */ KMCHAR('*',    0346,   '*',    0346),
/* 2c */ KMALPHA('w',   'W',    027,    027),
/* 2d */ KMALPHA('x',   'X',    030,    030),
/* 2e */ KMALPHA('c',   'C',    003,    003),
/* 2f */ KMALPHA('v',   'V',    026,    026),
/* 30 */ KMALPHA('b',   'B',    002,    002),
/* 31 */ KMALPHA('n',   'N',    016,    016),
/* 32 */ KMCHAR(',',    '?',    ',',    '?'),
/* 33 */ KMCHAR(';',    '.',    ';',    '.'),
/* 34 */ KMCHAR(':',    '/',    ':',    '/'),
/* 35 */ KMCHAR('!',    025,    '!',    025),
/* 36 */ KRSHF,
/* 37 */ KCONST('*'),
/* 38 */ KALT,
/* 39 */ KACCENTED(ACCENT_SPACE),
#ifndef CAPSLOCK_CONTROL
/* 3a */ KCAPSLOCK,
#else
/* 3a */ KCTL,
#endif
/* 3b */ KSFUNC('M', 'Y', 'k', 'w', 'M', 'Y', 'k', 'w'),
/* 3c */ KSFUNC('N', 'Z', 'l', 'x', 'N', 'Z', 'l', 'x'),
/* 3d */ KSFUNC('O', 'a', 'm', 'y', 'O', 'a', 'm', 'y'),
/* 3e */ KSFUNC('P', 'b', 'n', 'z', 'P', 'b', 'n', 'z'),
/* 3f */ KSFUNC('Q', 'c', 'o', '@', 'Q', 'c', 'o', '@'),
/* 40 */ KSFUNC('R', 'd', 'p', '[', 'R', 'd', 'p', '['),
/* 41 */ KSFUNC('S', 'e', 'q', '\\', 'S', 'e', 'q', '\\'),
/* 42 */ KSFUNC('T', 'f', 'r', ']', 'T', 'f', 'r', ']'),
/* 43 */ KSFUNC('U', 'g', 's', '^', 'U', 'g', 's', '^'),
/* 44 */ KSFUNC('V', 'h', 't', '_', 'V', 'h', 't', '_'),
/* 45 */ KNUM,
/* 46 */ KSCROLL,
/* 47 */ KNUMPAD('7', '\033', '[', 'H' ),
/* 48 */ KNUMPAD('8', '\033', '[', 'A'),
/* 49 */ KNUMPAD('9', '\0', '\0', '\0'),
/* 4a */ KCONST('-'),
/* 4b */ KNUMPAD('4', '\033', '[', 'D'),
/* 4c */ KNUMPAD('5', '\0', '\0', '\0'),
/* 4d */ KNUMPAD('6', '\033', '[', 'C'),
/* 4e */ KCONST('+'),
/* 4f */ KNUMPAD('1', '\0', '\0', '\0'),
/* 50 */ KNUMPAD('2', '\033', '[', 'B'),
/* 51 */ KNUMPAD('3', '\0', '\0', '\0'),
/* 52 */ KNUMPAD('0', '\0', '\0', '\0'),
/* 53 */ KNUMPAD('.', '\177', '\0', '\0'),
/* 54 */ KNULL,
/* 55 */ KNULL,
/* 56 */ KCHAR('<',    '>',    '<',    '>',    '|',    '|',    '|',    '|'),
/* 57 */ KSFUNC('W', 'i', 'u', '`', 'W', 'i', 'u', '`'),
/* 58 */ KMCHAR('<',    '>',    '<',    '>'),
/* 59 */ KNULL,
/* what are the rest of these, compaq extensions? ??? */
/* 5a */ KCHAR(0,       0,      033,    033,    0,      0,      033,    033),
/* 5b */ KCHAR(0,       0,      '7',    '7',    0,      0,      '7',    '7'),
/* 5c */ KCHAR(0,       0,      '4',    '4',    0,      0,      '4',    '4'),
/* 5d */ KCHAR(0,       0,      '1',    '1',    0,      0,      '1',    '1'),
/* 5e */ KNULL,
/* 5f */ KCHAR(0,       0,      NUM,    NUM,    0,      0,      NUM,    NUM),
/* 60 */ KCHAR(0,       0,      '8',    '8',    0,      0,      '8',    '8'),
/* 61 */ KCHAR(0,       0,      '5',    '5',    0,      0,      '5',    '5'),
/* 62 */ KCHAR(0,       0,      '2',    '2',    0,      0,      '2',    '2'),
/* 63 */ KNULL,
#define STP 0   /* ??? */
/* 64 */ KCHAR(0,       0,      STP,    STP,    0,      0,      STP,    STP),
/* 65 */ KCHAR(0,       0,      '9',    '9',    0,      0,      '9',    '9'),
/* 66 */ KCHAR(0,       0,      '6',    '6',    0,      0,      '6',    '6'),
/* 67 */ KCHAR(0,       0,      '3',    '3',    0,      0,      '3',    '3'),
/* 68 */ KCHAR(0,       0,      '.',    '.',    0,      0,      '.',    '.'),
/* 69 */ KNULL,
/* 6a */ KCHAR(0,       0,      '*',    '*',    0,      0,      '*',    '*'),
/* 6b */ KCHAR(0,       0,      '-',    '-',    0,      0,      '-',    '-'),
/* 6c */ KCHAR(0,       0,      '+',    '+',    0,      0,      '+',    '+'),
};

int pcconstabsize = sizeof(pcconstab) / sizeof(pcconstab[0]);

int pcextstart = 0x1c;
int pcextend = 0x54;

struct key pcexttab[] = {
/* 1c */ KCHAR('\r',    '\r',   '\r',   '\r',   '\r',   '\r',   '\r',   '\r'),
/* 1d */ KRCTL,
/* 1e */ KNULL,
/* 1f */ KNULL,
/* 20 */ KNULL,
/* 21 */ KNULL,
/* 22 */ KNULL,
/* 23 */ KNULL,
/* 24 */ KNULL,
/* 25 */ KNULL,
/* 26 */ KNULL,
/* 27 */ KNULL,
/* 28 */ KNULL,
/* 29 */ KNULL,
/* 2a */ KNULL,         /* simulated left shift */
/* 2b */ KNULL,
/* 2c */ KNULL,
/* 2d */ KNULL,
/* 2e */ KNULL,
/* 2f */ KNULL,
/* 30 */ KNULL,
/* 31 */ KNULL,
/* 32 */ KNULL,
/* 33 */ KNULL,
/* 34 */ KNULL,
/* 35 */ KCHAR('/',     '/',    '/',    '/',    '/',    '/',    '/',    '/'),
/* 36 */ KNULL,         /* simulated right shift */
/* 37 */ KNULL,         /* print scrn */
/* 38 */ KRALT,
/* 39 */ KNULL,
/* 3a */ KNULL,
/* 3b */ KNULL,
/* 3c */ KNULL,
/* 3d */ KNULL,
/* 3e */ KNULL,
/* 3f */ KNULL,
/* 40 */ KNULL,
/* 41 */ KNULL,
/* 42 */ KNULL,
/* 43 */ KNULL,
/* 44 */ KNULL,
/* 45 */ KNUM,
/* 46 */ KNULL,                 /* break (control-pause) */
/* 47 */ KFUNC("\033[H"),       /* edit-pad home */
/* 48 */ KFUNC("\033[A"),       /* cursor-pad up arrow */
/* 49 */ KFUNC("\033[I"),       /* edit-pad page up */
/* 4a */ KNULL,
/* 4b */ KFUNC("\033[D"),       /* cursor-pad left arrow */
/* 4c */ KNULL,
/* 4d */ KFUNC("\033[C"),       /* cursor-pad right arrow */
/* 4e */ KNULL,
/* 4f */ KFUNC("\033[F"),       /* edit-pad end */
/* 50 */ KFUNC("\033[B"),        /* cursor-pad down arrow */
/* 51 */ KFUNC("\033[G"),       /* edit-pad page down */
/* 52 */ KNULL,                 /* edit-pad insert */
/* 53 */ KCONST(0177),          /* edit-pad delete */
};

/* Alternate key mapping: unused */
struct key pcaltconstab[] = {
/* 00 */ KNULL,
};

int pcaltconstabsize = sizeof(pcaltconstab) / sizeof(pcaltconstab[0]);
