/*-
 * Copyright (c) 1992, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: isavar.h,v 2.4 1995/12/01 03:16:05 karels Exp $
 */

/*
 * ISA driver attach arguments
 */
struct isa_attach_args {
	u_short	ia_iobase;		/* base i/o address */
	u_short	ia_iosize;		/* span of ports used */
	u_short	ia_irq;			/* interrupt request */
	u_short	ia_drq;			/* DMA request */
	caddr_t ia_maddr;		/* physical i/o mem addr */
	u_int	ia_msize;		/* size of i/o memory */
	int	ia_bustype;		/* specific bus type */
	void	*ia_aux;		/* driver specific */
};

/*
 * per-device ISA variables
 */
struct isadev {
	struct  device *id_dev;		/* back pointer to generic */
	struct	isadev *id_bchain;	/* forward link in bus chain */	
};

/*
 * ISA masterbus 
 */
struct isa_softc {
	struct	device sc_dev;		/* base device */
	struct	isadev *sc_isadev;	/* list of all children */
};

#define	LOC_IOBASE	0
#define	LOC_IOSIZE	1
#define	LOC_MADDR	2
#define	LOC_MSIZE	3
#define	LOC_IRQ		4
#define	LOC_DRQ		5
#define	LOC_BUSTYPE	6	/* one of BUS_* above */

#define	cf_iobase	cf_loc[LOC_IOBASE]
#define	cf_iosize	cf_loc[LOC_IOSIZE]
#define	cf_maddr	cf_loc[LOC_MADDR]
#define	cf_msize	cf_loc[LOC_MSIZE]
#define	cf_irq		cf_loc[LOC_IRQ]
#define	cf_drq		cf_loc[LOC_DRQ]
#define	cf_bustype	cf_loc[LOC_BUSTYPE]


/*
 * Interrupt handler chains.  Interrupt handlers should return 0 for
 * `not I', 1 (`I took care of it'), or -1 (`I guess it was mine, but
 * I wasn't expecting it').  intr_establish() inserts a handler into
 * the list.  The handler is called with its (single) argument.
 */
struct intrhand {
	int	(*ih_fun)();
	void	*ih_arg;
	u_long	ih_count;
	struct	intrhand *ih_next;
} *intrhand[16];

void intr_establish __P((int intr, struct intrhand *, enum devclass));
int isa_portcheck __P((int base, int size));
void isa_portalloc __P((int base, int size));

/*
 * software conventions
 */

/*
 * Bus types.  More than one type of bus can be present on a system.
 * "isa" locators contain one of these values to indicate the type
 * of bus on which the device was configured.
 */
#define	BUS_ANY		0	/* not normally used */
#define	BUS_ISA		1
#define	BUS_EISA	2
#define	BUS_MCA		3
#define	BUS_PCI		4
#define	BUS_PCMCIA	5

extern int atdevbase;		/* kernel virtual address of "hole" */
extern int eisa_present;	/* set if EISA bus is present */
extern int pci_present;		/* set if PCI bus is present */
extern int elcr_present;	/* do we have edge/level config registers */

#define	EISA_PRESENT()	(eisa_present)	/* see if EISA bus is present */
#define	PCI_PRESENT()	(pci_present)	/* see if PCI bus is present */

/*
 * Given a kernel virtual address for some location
 * in the "hole" I/O space, return a physical address.
 */
#define	ISA_PHYSADDR(v)	((caddr_t) ((int)(v) - atdevbase + IOM_BEGIN))
/*
 * Given a physical address in the "hole",
 * return a kernel virtual address.
 */
#define	ISA_HOLE_VADDR(p)  ((caddr_t) ((int) (p) - IOM_BEGIN + atdevbase))

/* 
 * The definition of isa_type and extern isa_bustype are only supplied
 * for backwards compatability and will be removed in the future. Only
 * binary compatability is maintained. Re-compilation requires updating
 * the code to the current standard.
 */
typedef enum { OLDBUS_ISA, OLDBUS_EISA} isa_type;
extern isa_type isa_bustype;	/* type of bus */
