/*
 * Copyright (c) 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: if_trreg.h,v 2.1 1995/09/22 21:52:00 ewv Exp $
 */

/*
 * IBM TRA 16/4 token ring adapter (Natl Semi TROPIC)
 */

/*
 * I/O registers
 */
#define	TR_SETUP	0x00	/* R   Setup */
#define TR_RESET	0x01	/* W   Hold reset */
#define TR_RUN		0x02	/* W   Release reset */
#define TR_IEN		0x03	/* W   Interrupt enable */

#define TR_IOSIZE	0x04

/*
 * Attachment control area registers
 */
typedef struct tr_aca {
	u_char	rrr_even;
	u_char	rrr_odd;
	u_short	wrb;
	u_short	wwo;
	u_short	wwc;
	u_char	isrp_even;
	u_char	isrp_odd;
	u_char	isra_even;
	u_char	isra_odd;
	u_char	tcr_even;
	u_char	tcr_odd;
	u_char	tvr_even;
	u_char	tvr_odd;
	u_char	srpr_even;
	u_char	srpr_odd;
	u_char	pad[14];	/* Pad to 32 bytes */
} volatile tr_aca_t;

/* If this line fails the above structure isn't laid our correctly */
typedef int _tr_aca_test[1 / (sizeof(tr_aca_t) == 32)];

/* rrr_even */
#define TR_RRR_OMASK	0xe0
#define TR_RRR_OSHIFT	1

/* rrr_odd */
#define TR_RRR_WMASK	0x0c	/* RAM window size mask */
#define TR_RRR_SHFT	2
#define TR_RRR_8K	0x00
#define TR_RRR_16K	0x04
#define TR_RRR_32K	0x08
#define TR_RRR_64K	0x0c

/* isrp_even */
#define PRIALT		0x01
#define USER_IBLOCK	0x02
#define ACCESS_INT	0x04
#define ERROR_INT	0x08
#define TIMER_INT	0x10
#define INT_ENABLE	0x40
#define CHCK_IRQ	0x80

/* isrp_odd */
#define FPT_COMPL	0x02
#define SSB_RESP 	0x04
#define ARB_CMD		0x08
#define ASB_FREE	0x10
#define SRB_RESP	0x20
#define ADAPTER_CHECK	0x40

/* isra_even */
#define SOFT_INT_MASK	0x01
#define HARD_INT_MASK	0x02
#define PROC_CHECK	0x08
#define DEADMAN		0x10
#define ADAP_ACCESS_INT	0x20
#define ADAP_TIMER_INT	0x40
#define PARITY_ERROR	0x80

/* isra_odd */
#define SSB_FREE	0x01
#define ARB_FREE	0x02
#define ASB_FREE_REQ	0x04
#define SRB_FREE_REQ	0x08
#define ASB_RESP	0x10
#define SRB_CMD		0x20
#define FPT_REQ		0x40

/*
 * BIOS/Memory mapped I/O space (MMIO)
 */
typedef struct tr_mio {
	/* BIOS ROM (if installed) */
	u_char	romid1;		/* ROM ID bytes */
	u_char	romid2;
	u_char	bios_len;	/* BIOS length/512 */
	u_char	code[7677];	/* BIOS code */

	/* Incarnations of the ACA */
	tr_aca_t rw;		/* Straight read/write */
	tr_aca_t and;		/* AND write bits with register */
	tr_aca_t or;		/* OR write bits with register */
	tr_aca_t inval;		/* Operation not used */

	u_char	pad1[128];	/* Not used */

	/* AIP area (all are encoded into high order nibble */
	u_char	macaddr[24];	/* MAC address */
	u_char	macaddrc[24];	/* MAC address complemented */
	u_char	chnid[48];	/* Channel identifier */
	u_char	csum1;		/* Checksum of lower part of ID prom */
	u_char	pad[31];

	u_char	testpat[32];	/* ID prom test pattern */

	/* AIP config data */
	u_short	type;		/* Adapter type */
	u_short	rate;		/* Speed */
	u_short etr;		/* Early token release */
	u_short totram;		/* Total available shared RAM */
	u_short rampage;	/* Shared RAM paging */
	u_short dhbsize4;	/* max DHB size at 4MB */
	u_short dbcsize16;	/* max DHB size at 16MB */
	u_char	pad2[66];

	u_char	csum2;		/* AIP checksum */
	u_char	pad3[15];
} volatile tr_mio_t;

/* Check size of mmio area */
typedef int _tr_mio_test[1 / (sizeof(tr_mio_t) == 0x2000)];

/* chnid */
#define TR_ISA_ID	0x5049

/* totram */
#define	TR_RAM64_B	0x0b00

/*
 * Response to adapter init
 */
typedef struct {
	u_char	cmd;
	u_char	status;
	u_char	pad[4];
	u_short	bup_code;
	/* Following are shared RAM offsets */
	u_short	encoded_addr;
	u_short	level_addr;
	u_short adapter_addr;
	u_short	parms_addr;
	u_short mac_addr;
	u_short util_addr;
} tr_init_srb_t;

/* tr_init_srb_t.status */
#define	RING_SPEED_16	0x01
#define RPL_AVAIL	0x02
#define UTIL_AVAIL	0x08
#define FPT_AVAIL	0x20

/*
 * Config fast path SRB and return block
 */
typedef struct {
	u_char	cmd;
	u_char	pad;
	u_char	rc;
	u_char	pad1[5];
	u_short	parm1;
	u_short	parm2;
} tr_cfpr_t;

/*
 * Open adapter SRB
 */
typedef struct tr_srb {
	u_char	cmd;
	u_char	pad[7];
	u_short	options;
	u_char	node_addr[6];
	u_char	group_addr[4];
	u_char	func_addr[4];
	u_short	num_rcv_buf;
	u_short	rcv_buf_len;
	u_short	dhb_length;
	u_char	num_dhb;
	u_char	pad1;
	u_char	dlc_max_sap;
	u_char	dlc_max_sta;
	u_char	dlc_max_gsap;
	u_char	dlc_max_gmem;
	u_char	dlc_t1_tick1;
	u_char	dlc_t2_tick1;
	u_char	dlc_ti_tick1;
	u_char	dlc_t1_tick2;
	u_char	dlc_t2_tick2;
	u_char	dlc_ti_tick2;
	u_char	product_id[18];
} tr_open_srb_t;

/*
 * Open SRB response
 */
typedef struct {
	u_char	cmd;
	u_char	pad;
	u_char	rc;
	u_char	pad1[3];
	u_short	err;
	u_short	asb;
	u_short	srb;
	u_short	arb;
	u_short	ssb;
} tr_open_resp_t;

/* Open return codes */
#define OPEN_INVALID		0x01
#define OPEN_ALREADY		0x03
#define OPEN_MISSING		0x05
#define OPEN_CANCEL		0x07
#define OPEN_NORX		0x30
#define OPEN_BADNODE		0x32
#define OPEN_BADRXLEN		0x33
#define OPEN_BADTXLEN		0x34

#define INVALID_FAIL		0x01
#define OPEN_FAIL		0x03
#define PARAM_FAIL		0x05
#define CANCEL_FAIL		0x07
#define RBUF_FAIL		0x30
#define ADDR_FAIL		0x32
#define RBUF_LEN_FAIL		0x33
#define XBUF_LEN_FAIL		0x34

/*
 * Fast path transmit control area
 */
typedef struct {
	u_short	buffer_count;
	u_short	fqh;
	u_short	fqt;
	u_short	aqh;
	u_short bsize;
	u_short cqt;
} volatile tr_fptca_t;

/*
 * Fast path transmit buffer
 */
typedef struct {
	u_char	cmd;
	u_char	corr;
	u_char	rc;
	u_char	pad;
	u_short	stn_id;
	u_short	frame_len;
	u_char	hdr_len;
	u_char	rsap_val;
	u_short	pad1;
	u_short	last_bufr;
	u_short	frame_ptr;
	u_short	next_bufr;
	u_char	tx_stat;
	u_char	stripped_fs;
	u_short	buffer_len;
	u_char	data[0];
} tr_fpb_t;

/* Check size of above structure */
typedef int _tr_fpb_test[1 / (sizeof(tr_fpb_t) == 22)];

#define NEXTOFF	((int)&((tr_fpb_t *)0)->next_bufr)

/*
 * Received data ARB
 */
typedef struct {
	u_char	cmd;
	u_char	pad[3];
	u_short	stn_id;
	u_short	bufr;
	u_char	lan_hdr_len;
	u_char	dlc_hdr_len;
	u_short	frame_len;
	u_char	ncb_type;
} tr_rxarb_t;

/*
 * Ring status change ARB
 */
typedef struct {
	u_char	cmd;
	u_char	pad[5];
	u_short	ring_stat;
} tr_ringstat_t;

/*
 * Receive data buffer
 */
typedef struct {
	u_short	pad;
	u_short	next_buf;
	u_char	pad1;
	u_char	rx_fs;
	u_short	buf_len;
	u_char	data[0];
} tr_rxb_t;

/*
 * ASB receive response
 */
typedef struct {
	u_char	cmd;
	u_char	pad;
	u_char	rc;
	u_char	pad1;
	u_short	stn_id;
	u_short	rbuf;
} tr_asb_t;

/* PC to adapter commands (DLC/SAP omitted) */
#define DIR_INTERUPT		0x00
#define DIR_MODIFY_OPEN_PARMS	0x01
#define DIR_RESTORE_OPEN_PARMS	0x02
#define DIR_OPEN_ADAPTER	0x03
#define DIR_CLOSE_ADAPTER	0x04
#define DIR_SET_GROUP_ADDR	0x06
#define DIR_SET_FUCTIONAL_ADDR	0x07
#define DIR_READ_LOG		0x08
#define DIR_SET_BRIDGE_PARMS	0x09
#define TRANSMIT_DIR_FRAME	0x0a
#define DIR_CONFIG_BRIDGE_RAM	0x0c
#define DIR_CFG_FAST_PATH_RAM	0x12
#define DIR_SNGL_RT_BCAST	0x1f

/* adapter to PC commands */
#define INIT_COMPLETE		0x80
#define RECEIVED_DATA		0x81
#define TRANSMIT_DATA_REQUEST	0x82
#define DLC_STATUS		0x83
#define RING_STATUS_CHANGE	0x84
#define RCVD_BRIDGE_DATA	0x85

/* where all messages are routed */
#define DIRECT_STATION		0x0000		/* In network order */

/* 
 * Bit masks for Ring Commands that we might receive.
 */
#define SIGNAL_LOSS		0x8000
#define HARD_ERROR		0x4000
#define SOFT_ERROR		0x2000
#define TRANSMIT_BEACON 	0x1000
#define LOBE_WIRE_FAULT 	0x0800
#define AUTO_REMOVAL		0x0400
#define REMOVE_RECEIVED  	0x0100
#define COUNTER_OVERFLOW 	0x0080
#define SINGLE_STATION   	0x0040
#define RING_RECOVERY	 	0x0020
