/*-
 * Copyright (c) 1993, 1994 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: digiioctl.h,v 2.3 1995/11/01 20:07:01 cp Exp $
 *
 * from Id: digiioctl.h,v 1.2 1993/11/16 00:03:23 nerd Exp nerd
 */

/*
 * board types
 */
typedef enum {PCXE, PCXI, PCXM, PCXE8K, PCXEM, PCXR, PC_UNKNOWN} digi_type_t;

/*
 * All ioctls here are specific to the DigiBoard and can only be called by
 * root (they check)
 */
#ifdef __STDC__
#define DIOCGNLINES	_IOR('D', 0, int)	/* get # of ports */
#define DIOCGFLAGS	_IOR('D', 1, int)	/* get config flags */
#define DIOCSFLAGS	_IOW('D', 2, int)	/* set config flags */
#define DIOCGIFREQ	_IOR('D', 3, int)	/* get interupt frequency */
#define DIOCSIFREQ	_IOW('D', 4, int)	/* set interupt frequency */
#define DIOCSVERB	_IOW('D', 5, int)	/* set debug on / off */
#define DIOCGALTPIN	_IOR('D', 6, int)	/* swap dcd & dsr */
#define DIOCSALTPIN	_IOW('D', 7, int)	/* swap dcd & dsr */
#define DIOCGLOWAT	_IOR('D', 8, int)	/* get output low water mark */
#define DIOCSLOWAT	_IOW('D', 9, int)	/* set output low water mark */
#define DIOCGOQSIZE	_IOR('D', 10, int)	/* get output queue lenghth */
#define DIOCSOQSIZE	_IOW('D', 11, int)	/* set output queue lenghth */
#else
#define DIOCNGLINES	_IOR(D, 0, int)		/* get # of ports */
#define DIOCGFLAGS	_IOR(D, 1, int)		/* get config flags */
#define DIOCSFLAGS	_IOW(D, 2, int)		/* set config flags */
#define DIOCGIFREQ	_IOR(D, 3, int)		/* get interupt frequency */
#define DIOCSIFREQ	_IOW(D, 4, int)		/* set interupt frequency */
#define DIOCSVERB	_IOW(D, 5, int)		/* set debug on / off */
#define DIOCGALTPIN	_IOR(D, 6, int)		/* swap dcd & dsr */
#define DIOCSALTPIN	_IOW(D, 7, int)		/* swap dcd & dsr */
#define DIOCGLOWAT	_IOR(D, 8, int)		/* get output low water mark */
#define DIOCSLOWAT	_IOW(D, 9, int)		/* set output low water mark */
#define DIOCGOQSIZE	_IOR(D, 10, int)	/* get output queue lenghth */
#define DIOCSOQSIZE	_IOW(D, 11, int)	/* set output queue lenghth */
#endif

/* parameters to DIOCVEB ioctl */
#define DV_OFF		0		/* turn off all driver messages */
#define DV_VERBOSE	1		/* turn on verbose only */
#define DV_DEBUG	2		/* turn on verbose & debug */
