/*-
 *	Copyright (c) 1993, 1994 Robert J.Dunlop. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted provided the following conditions are met:
 *   1.	Redistributions in source form must retain the above copyright, this
 *	list of conditions and the following disclaimers.
 *   2. Redistributions in binary form must reproduce all items from condition
 *	1 in the accompanying documentation and/or other materials.
 *   3. Neither the names of Chase Research PLC and it's subsidiary companies,
 *	nor that of Robert Dunlop may be used to endorse, advertise or promote
 *	products derived from this software without specific written permission
 *	from the party or parties concerned.
 *   4.	Adaptation of this software to operating systems other than BSD/OS
 *	requires the prior written permission of Chase Research PLC.
 *   5.	Adaptation of this software for operation with communications hardware
 *	other than the Chase IOPRO and IOLITE series requires the prior written
 *	permission of Chase Research PLC.
 */

/*
 *	Chase Research IOPRO (aim) driver
 *
 *	Driver data structures common to both the control driver (aimc) and
 *	the data driver (aim)
 *
 *	aimvar.h,v 1.10 1995/07/28 08:59:41 rjd Exp
 */


/*
 *	Convert _BSDI_VERSION to something a little more manageable
 */
#if ! defined ( _BSDI_VERSION )
#  define BSDI_RELEASE 100		/* First released driver at 1.0 */
#else
#  if _BSDI_VERSION < 199312
#    define BSDI_RELEASE 100		/* First released driver at 1.0 */
#  else
#    if _BSDI_VERSION < 199501
#      define BSDI_RELEASE 101		/* Added select code at 1.1 */
#    else
#      define BSDI_RELEASE 200		/* New config system at 2.0 */
#    endif
#  endif
#endif

/*
 *	Per logical channel device driver data
 *	======================================
 *
 *	Information is held in external unit memory for easy access from
 *	interrupt and similar routines. The only thing we store at present
 *	is a backpointer to host based information.
 */
#define osminor	ddinfo[0]


/*
 *	Per external unit control data
 *	==============================
 */
struct unit_info {
	Ubyte	unit_flags;		/* See below */
	Ubyte	unit_maxpage;		/* Maximum interrupting page */
};

					/* unit_flags */
#define UNIT_PRESENT	0x01		/* Unit possibly present */
#define UNIT_WCOMMAND	0x02		/* Someone waiting for access to command
					 * region
					 */
#define UNIT_WRESPONSE	0x04		/* Someone waiting for a response */


/*
 *	Per card control data
 *	=====================
 */
struct aimc_softc {
	struct device sc_dev;		/* OS base device info */
	struct isadev sc_id;		/* OS ISA device info */
	struct intrhand sc_ih;		/* OS interrupt control */

#if BSDI_RELEASE >= 200
	struct evcnt sc_intr;		/* Count interrupts for display */
#endif
					/* Remainder are for DD */
	volatile struct aim_memory *card_mem;	/* Card's memory location */
	u_short card_iobase;		/* Card's I/O base address */
	Ubyte	card_page;		/* Currently selected page */
	Ubyte	card_unit;		/* Selected external unit */
	Ubyte	card_flags;		/* See below */
	Ubyte	card_nunits;		/* Number of external units */
	Ubyte	card_num;		/* Index of card ( used for diags ) */
	struct unit_info card_uinfo[ NUNITS ];	/* Per unit info */
	struct atshutdown card_shutdown;	/* Card shutdown info */
};

					/* card_flags */
#define	CARD_POWER	0x01		/* External units are powered */
#define	CARD_WPOWER	0x02		/* Waiting for power */
#define	CARD_WBPOWER	0x04		/* Waiting for power to go bad */


/*
 *	Control macros
 *	==============
 */
				/* "Raw" selection of unit and page */
#define RPAGE_SEL(C,U,P) { \
				(C)->card_page = (P); \
				(C)->card_unit = (U); \
				(C)->card_mem->page_select[ U ].hw_reg = (P); \
			 }

				/* Select unit and page checking that it is not
				 * already selected. ( While the AIM bus is
				 * fast it can't compete with host memory ).
				 */
#define PAGE_SEL(C,U,P)	 if ( (C)->card_page != (P) || (C)->card_unit != (U) ) \
				RPAGE_SEL ( C, U, P )



/*
 *	Debug control and macros
 *	========================
 *
 *	Undefine to remove all debuging code or define to set initial debuging
 *	level.
 */
/* #define AIM_DEBUG	DBG_OPEN */
#ifdef AIM_DEBUG
    extern int aim_debug;
#   define dbg(l,p)	if ( aim_debug & ( l )) printf p
#else
#   define dbg(l,p)
#endif


/*
 *	Miscellaneous macros
 *	====================
 *
 *	Interrupt protection
 *	NOTE: I mean interrupt protection, this is not multi-threading support.
 */
#define PROTECT		{ int splval; splval = spltty ();
#define ALLOW		splx ( splval ); }

#define MYPRI		25		/* Priority for miscellaneous sleeps */

/*
 *	User permissions ( we only worry about one special user )
 */
#define issuser(P)	( suser ((P)->p_ucred, 0 ) == 0 )

/*
 *	Missing error code ( should be in errno.h perhaps ? )
 */
#define ENOERROR	0
