/*-
 *	Copyright (c) 1993 Robert J.Dunlop. All rights reserved.
 *
 *	Portions Copyright (c) 1991, 1992, 1993 Chase Research PLC.
 *	Portions Trade Secrets of Chase Research PLC.
 *	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted provided the following conditions are met:
 *   1.	Redistributions in source form must retain the above copyright and trade
 *	secret notices, this list of conditions and the following disclaimers.
 *   2. Redistributions in binary form must reproduce all items from condition
 *	1 in the accompanying documentation and/or other materials.
 *   3. Neither the names of Chase Research PLC and it's subsidiary companies,
 *	nor that of Robert Dunlop may be used to endorse, advertise or promote
 *	products derived from this software without specific written permission
 *	from the party or parties concerned.
 *   4.	Adaptation of this software to operating systems other than BSD/OS
 *	requires the prior written permission of Chase Research PLC.
 *   5.	Adaptation of this software for operation with communications hardware
 *	other than the Chase IOPRO and IOLITE series requires the prior written
 *	permission of Chase Research PLC.
 */

/*
 *	Chase Research IOPRO (aim) driver
 *
 *	The firmware and hardware interface memory layout
 *
 *	aimreg.h,v 1.3 1995/07/28 08:59:39 rjd Exp
 */

/* Fixed size data types extracted from "chase.h".
 * IOPRO firmware interface data structures are careful to align these on
 * appropriate boundarys
 */
typedef char		Byte;
typedef short		Word;
typedef long		Quad;
typedef unsigned char	Ubyte;
typedef unsigned short	Uword;
typedef unsigned long	Uquad;

/* Firmware data structures */
#include "aim_channel.h"
#include "aim_master.h"

/* Hardware registers */
/* All memory mapped hardware registers are byte wide located on a four byte
 * boundary.
 */
struct hwreg {
	Ubyte	hw_reg;			/* The register */
	Byte	hw_junk1;		/* Three junk locations */
	Byte	hw_junk2;
	Byte	hw_junk3;
};

/* Hardware sets a memory window size of 1K. Fortunately this matches the size
 * of our firmware data structures :-)
 */
#define PGSIZE	1024

/* 256 pages are visible to the host.
 * Once booted firmware generally moves into hidden memory.
 */
#define NPAGES 256

/* Hardware allows for up to 8 units per host interface although worst case
 * study of current cable impedance restricts this to 4 :-(
 */
#define MAX_NUNITS	8
#define NUNITS		4

/* Driver could support a maximum of 8 host interface cards but we normally
 * restrict this to 4.
 * XXX This restriction is not so necessary under BSD with startup memory
 *	allocation.
 */
#define MAX_NCARDS	8
#define NCARDS		4

/* Combine the hardware and firmware structures together */
struct aim_memory {
	union {				/* External box memory window */
	    struct master_page	master_page;
	    struct channel_page	channel_page;
	    Ubyte physical_page[ PGSIZE ];
	} external_memory;
					/* Hardware registers (per unit) */
	struct hwreg	page_select[ MAX_NUNITS ];	/* Write only */
	struct hwreg	proc_control[ MAX_NUNITS ];	/* Write only */
	struct hwreg	product_id[ MAX_NUNITS ];	/* Read only */
	struct hwreg	unit_status[ MAX_NUNITS ];	/* Read only */
	struct hwreg	_spares[ 4 * MAX_NUNITS ];
					/* Interface card registers */
	struct hwreg	intr_status;			/* Read only */
	struct hwreg	_spares2[ 63 ];
	struct hwreg	intr_ack;			/* Read only */
	struct hwreg	_spares3[ 63 ];
	struct hwreg	_spares4[ 64 ];
};

/* proc_control register bits */
#define PROC_INT	0x01
#define PROC_NMI	0x02
#define PROC_RESET	0x10

/* product_id values */
#define AIM_ID_IOPRO	165		/* IOPRO 186 based units */

/* intr_status and intr_ack/control register bits */
#define INTR_UNIT	0x01		/* External unit interrupts */
#define INTR_BUS	0x02		/* AIM bus xfer timeout */
#define INTR_PGOOD	0x04		/* External power gone good */
#define INTR_PBAD	0x08		/* External power gone bad */
#define INTR_ENABLE	0x20		/* Interrupt enable */

#define ALL_INTRS	( INTR_UNIT | INTR_BUS | INTR_PGOOD | INTR_PBAD )

/* typing short cuts */
#define msp	external_memory.master_page
#define chp	external_memory.channel_page
#define hwp	external_memory.physical_page


/*
 *	"chase.h"
 *
 *	The remainder of this file has nothing to do with IOPRO directly but
 *	contains extracts from "chase.h" that I find it hard to live without.
 */

/* Flag forward decl'ns as such */
#define forward		extern

/* One day I will find a compiler that handles "enum Bool { FALSE, TRUE }"
 * nicely and don't blow up on "if ( bool1 && bool2 )".
 * In the mean time this will have to do.
 */
typedef int		Bool;
#if ! defined ( TRUE )
#   define TRUE		(1==1)
#   define FALSE	(!TRUE)
#endif

/* Common macros that move around the header files so much it isn't worth trying
 * to find them
 */
#if ! defined ( min )
#   define min(A,B)	((A) < (B) ? (A) : (B))
#   define max(A,B)	((A) > (B) ? (A) : (B))
#endif

#if ! defined NULL
#   define NULL		((void *)0)
#endif
