/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: values.h,v 2.1 1995/05/25 02:55:31 bostic Exp $
 */

#ifndef _VALUES_H_
#define _VALUES_H_

/*
 * THIS HEADER FILE IS FOR COMPATIBILITY ONLY -- IT SHOULD NOT BE USED FOR
 * NEW SOFTWARE.
 */

#include <machine/limits.h>
#include <machine/float.h>

/* The bits per C type. */
#define	BITSPERBYTE	8
#define	BITS(type)	(BITSPERBYTE * sizeof(type))

/* The high-order bit for shorts, ints, longs. */
#define	HIBITS		((short)(1 << BITS(short) - 1))
#define	HIBITI		((int)(1 << BITS(int) - 1)
#define	HIBITL		((long)(1 << BITS(int) - 1)

/* Maximum short, int, long. */
#define	MAXSHORT	SHRT_MAX	/* Max short. */
#define	MAXINT		INT_MAX		/* Max int. */
#define	MAXLONG		LONG_MAX	/* Max long. */

#define	_IEEE		1		/* 1 if IEEE standard. */
#define	_HIDDENBIT	1		/* 1 if mantissa high-bit is implicit */

#define MAXDOUBLE	DBL_MAX		/* Max double. */
#define MINDOUBLE	DBL_MIN		/* Min double. */
#define	DMAXEXP		DBL_MAX_EXP	/* Max double exponent. */
#define	DMINEXP		DBL_MIN_EXP	/* Min double exponent. */
#define	DMAXPOWTWO	4503599627370496/* Max power of 2 in a double. */
#define	DSIGNIF		DBL_MANT_DIG	/* Significant bits in a double. */
#define	_DEXPLEN	11		/* Bits in double exponent. */
					/* natural log(MAXDOUBLE) */
#define	LN_MAXDOUBLE	709.78271289338399
					/* natural log(MINDOUBLE) */
#define	LN_MINDOUBLE	-708.3964185322641

#define MAXFLOAT	FLT_MAX		/* Max float. */
#define MINFLOAT	FLT_MIN		/* Min float. */
#define	FMAXEXP		FLT_MAX_EXP	/* Max float exponent. */
#define	FMINEXP		FLT_MIN_EXP	/* Min float exponent. */
#define	FMAXPOWTWO	8388608		/* Max power of 2 in a float. */
#define	FSIGNIF		FLT_MANT_DIG	/* Significant bits in a float. */
#define	_FEXPLEN	8		/* Bits in float exponent. */
#define	LN_MAXFLOAT	88.722839	/* natural log(MAXFLOAT) */
#define	LN_MINFLOAT	-87.336544	/* natural log(MINFLOAT) */
#endif /* !_VALUES_H_ */
