/*-
 * Copyright (c) 1995 Berkeley Software Design, Inc. All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: ieeefp.h,v 2.1 1995/12/05 20:39:43 donn Exp $
 */

/*
 * The interface is defined in fpgetround(3C) on p538 of the SVr4 API.
 */

#ifndef _MACHINE_IEEEFP_H_
#define	_MACHINE_IEEEFP_H_

typedef int fp_rnd;
typedef int fp_except;

#define	FP_X_INV	0x0001	/* invalid operation */
#define	FP_X_DZ		0x0004	/* zero divide */
#define	FP_X_OFL	0x0008	/* overflow */
#define	FP_X_UFL	0x0010	/* underflow */
#define	FP_X_IMP	0x0020	/* precision */
				/* denormalized operand? */

#define	_FP_X_MASK	0x003d

#define	FP_RN		0x0000	/* round to nearest or even */
#define	FP_RM		0x0400	/* round down (toward -Inf) */
#define	FP_RP		0x0800	/* round up (toward +Inf) */
#define	FP_RZ		0x0c00	/* chop (truncate toward 0) */

#define	_FP_R_MASK	0x0c00

#ifdef __GNUC__

static __inline fp_except
fpgetmask(void)
{
	__volatile fp_except f = 0;

	__asm __volatile ("fnstcw %0" : "=m" (f));
	return (~f & _FP_X_MASK);
}

static __inline fp_rnd
fpgetround(void)
{
	__volatile fp_rnd f = 0;

	__asm __volatile ("fnstcw %0" : "=m" (f));
	return (f & _FP_R_MASK);
}

static __inline fp_except
fpgetsticky(void)
{
	__volatile fp_except f = 0;

	__asm __volatile ("fnstsw %0" : "=m" (f));
	return (f & _FP_X_MASK);
}

static __inline fp_except
fpsetmask(fp_except f)
{
	__volatile fp_except o;
	__volatile fp_except n;

	__asm __volatile ("fnstcw %0" : "=m" (o));
	n = ~f & _FP_X_MASK | o & ~_FP_X_MASK;
	__asm __volatile ("fldcw %0" : : "m" (n));

	return (~o & _FP_X_MASK);
}

static __inline fp_rnd
fpsetround(fp_rnd f)
{
	__volatile fp_rnd o;
	__volatile fp_rnd n;

	__asm __volatile ("fnstcw %0" : "=m" (o));
	n = f & _FP_R_MASK | o & ~_FP_R_MASK;
	__asm __volatile ("fldcw %0" : : "m" (n));

	return (o & _FP_R_MASK);
}

static __inline fp_except
fpsetsticky(fp_except f)
{
	__volatile fp_except o;
	__volatile fp_except n;

	__asm __volatile ("fnstsw %0" : "=m" (o));
	n = f & _FP_X_MASK | o & ~_FP_X_MASK;
	__asm __volatile ("fldcw %0" : : "m" (n));

	return (o & _FP_X_MASK);
}

#endif

#endif
