/*-
 * Copyright (c) 1992, 1993, 1994, 1995 Berkeley Software Design, Inc.
 * All rights reserved.
 * The Berkeley Software Design Inc. software License Agreement specifies
 * the terms and conditions for redistribution.
 *
 *	BSDI $Id: cpu.h,v 2.5 1995/12/01 03:11:27 karels Exp $
 */

/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * William Jolitz.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)cpu.h	8.4 (Berkeley) 1/5/94
 */

/*
 * Definitions unique to i386 cpu support.
 */
#ifndef LOCORE
#include <machine/frame.h>
#include <machine/segments.h>
#include <machine/psl.h>

/*
 * definitions of cpu-dependent requirements
 * referenced in generic code
 */
#define	COPY_SIGCODE		/* copy sigcode above user stack in exec */

#define	cpu_exec(p)			/* nothing */
#define	cpu_swapin(p)			/* nothing */
#define cpu_setstack(p, ap)		(p)->p_md.md_regs[SP] = ap
#ifndef NO_KSTACK
#define cpu_set_init_frame(p, fp)	(p)->p_md.md_regs = fp
#else
#define cpu_set_init_frame(p, fp)	/* nothing; done in cpu_fork */
#endif

extern u_int nonemask;

/*
 * Arguments to hardclock and statclock
 * encapsulate the previous machine state in an opaque
 * clockframe; for now, use generic intrframe.
 *
 * Currently, we can't tell if we were running at interrupt level,
 * and thus CLKF_INTR always evaluates to false.
 */
struct clockframe {
	struct intrframe	cf_if;
};

#define	CLKF_USERMODE(framep)	(((framep)->cf_if.if_eflags & PSL_VM) || \
				 (ISPL((framep)->cf_if.if_cs) == SEL_UPL))
#define	CLKF_BASEPRI(framep)	((framep)->cf_if.if_ppl == nonemask)
#define	CLKF_PC(framep)		((framep)->cf_if.if_eip)
#define	CLKF_INTR(framep)	0	/* wish for better */

/*
 * Preempt the current process if in interrupt from user mode,
 * or after the current trap/syscall if in system mode.
 */
#define	need_resched()	{ want_resched++; aston(); }

/*
 * Give a profiling tick to the current process when the user profiling
 * buffer pages are invalid.  On i386, request an ast to send us
 * through trap, marking the proc as needing a profiling tick.
 */
#define	need_proftick(p)	{ (p)->p_flag |= P_OWEUPC; aston(); }

/*
 * Notify the current process (p) that it has a signal pending,
 * process as soon as possible.
 */
#define	signotify(p)	aston()

#define aston() (astpending++)
#define	setsoftclock()	schednetisr(NETISR_SCLK)
#define	setsoftnet()	/* setting netisr is sufficient */


int	astpending;		/* need to trap before returning to user mode */
int	want_resched;		/* resched() was called */
#endif

/*
 * Kinds of processor
 */

#define	CPU_386SX	1
#define	CPU_386		2
#define	CPU_486SX	3
#define	CPU_486		4
#define	CPU_586		5	/* Pentium (tm) */
#define	CPU_686		6	/* Pentium Pro (tm) */

#ifndef LOCORE
int	cpu;

struct cpuident {
	int	cputype;
	int	cliplevel;
	char	*ident;
	int 	mhz;
};

/*
 * CTL_MACHDEP definitions.
 */
#define	CPU_CONSDEV		1	/* dev_t: console terminal device */
#define	CPU_BIOS		2	/* node: PC/AT BIOS information */
#define	CPU_CNTLALTDEL		3	/* int: recognize cntl-alt-del */
#define	CPU_CNTLALTDELCORE	4	/* int: recognize cntl-alt-del */
#define	CPU_PARITYERRORPANIC	5	/* int: panic on parity err */
#define	CPU_MAXID		6	/* number of valid machdep ids */

#define CTL_MACHDEP_NAMES { \
	{ 0, 0 }, \
	{ "console_device", CTLTYPE_STRUCT }, \
	{ "bios", CTLTYPE_NODE }, \
	{ "cntlaltdel", CTLTYPE_INT }, \
	{ "cntlaltdelcore", CTLTYPE_INT }, \
	{ "parityerrorpanic", CTLTYPE_INT }, \
}

/*
 * CPU_BIOS definitions.
 */
#define	BIOS_DISKGEOM		1	/* biosgeom[4]: CMOS/BIOS disk geom */
#ifdef notyet
#define	BIOS_INFO		2	/* biosinfo: various BIOS info */
#endif
#define	BIOS_MAXID		2	/* number of valid BIOS ids */

#define CTL_BIOS_NAMES { \
	{ 0, 0 }, \
	{ "diskgeom", CTLTYPE_STRUCT }, \
}
#endif
